/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import java.time.Instant;
import net.minecraft.network.FriendlyByteBuf;
import org.jspecify.annotations.Nullable;

public class CriterionProgress {
    private @Nullable Instant obtained;

    public CriterionProgress() {
    }

    public CriterionProgress(Instant var0) {
        this.obtained = var0;
    }

    public boolean isDone() {
        return this.obtained != null;
    }

    public void grant() {
        this.obtained = Instant.now();
    }

    public void revoke() {
        this.obtained = null;
    }

    public @Nullable Instant getObtained() {
        return this.obtained;
    }

    public String toString() {
        return "CriterionProgress{obtained=" + String.valueOf(this.obtained == null ? "false" : this.obtained) + "}";
    }

    public void serializeToNetwork(FriendlyByteBuf var0) {
        var0.writeNullable(this.obtained, FriendlyByteBuf::writeInstant);
    }

    public static CriterionProgress fromNetwork(FriendlyByteBuf var0) {
        CriterionProgress var1 = new CriterionProgress();
        var1.obtained = var0.readNullable(FriendlyByteBuf::readInstant);
        return var1;
    }
}

