/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.advancements.criterion.DistancePredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.LocationPredicate;
import net.minecraft.advancements.criterion.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class FallAfterExplosionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @Override
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer var0, Vec3 var1, @Nullable Entity var2) {
        Vec3 var3 = var0.position();
        LootContext var42 = var2 != null ? EntityPredicate.createContext(var0, var2) : null;
        this.trigger(var0, var4 -> var4.matches(var0.level(), var1, var3, var42));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<LocationPredicate> startPosition, Optional<DistancePredicate> distance, Optional<ContextAwarePredicate> cause) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)LocationPredicate.CODEC.optionalFieldOf("start_position").forGetter(TriggerInstance::startPosition), (App)DistancePredicate.CODEC.optionalFieldOf("distance").forGetter(TriggerInstance::distance), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("cause").forGetter(TriggerInstance::cause)).apply((Applicative)var0, TriggerInstance::new));

        public static Criterion<TriggerInstance> fallAfterExplosion(DistancePredicate var0, EntityPredicate.Builder var1) {
            return CriteriaTriggers.FALL_AFTER_EXPLOSION.createCriterion(new TriggerInstance(Optional.empty(), Optional.empty(), Optional.of(var0), Optional.of(EntityPredicate.wrap(var1))));
        }

        @Override
        public void validate(CriterionValidator var0) {
            SimpleCriterionTrigger.SimpleInstance.super.validate(var0);
            var0.validateEntity(this.cause(), "cause");
        }

        public boolean matches(ServerLevel var0, Vec3 var1, Vec3 var2, @Nullable LootContext var3) {
            if (this.startPosition.isPresent() && !this.startPosition.get().matches(var0, var1.x, var1.y, var1.z)) {
                return false;
            }
            if (this.distance.isPresent() && !this.distance.get().matches(var1.x, var1.y, var1.z, var2.x, var2.y, var2.z)) {
                return false;
            }
            return !this.cause.isPresent() || var3 != null && this.cause.get().matches(var3);
        }
    }
}

