/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.advancements.criterion.FluidPredicate;
import net.minecraft.advancements.criterion.LightPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.levelgen.structure.Structure;

public record LocationPredicate(Optional<PositionPredicate> position, Optional<HolderSet<Biome>> biomes, Optional<HolderSet<Structure>> structures, Optional<ResourceKey<Level>> dimension, Optional<Boolean> smokey, Optional<LightPredicate> light, Optional<BlockPredicate> block, Optional<FluidPredicate> fluid, Optional<Boolean> canSeeSky) {
    public static final Codec<LocationPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)PositionPredicate.CODEC.optionalFieldOf("position").forGetter(LocationPredicate::position), (App)RegistryCodecs.homogeneousList(Registries.BIOME).optionalFieldOf("biomes").forGetter(LocationPredicate::biomes), (App)RegistryCodecs.homogeneousList(Registries.STRUCTURE).optionalFieldOf("structures").forGetter(LocationPredicate::structures), (App)ResourceKey.codec(Registries.DIMENSION).optionalFieldOf("dimension").forGetter(LocationPredicate::dimension), (App)Codec.BOOL.optionalFieldOf("smokey").forGetter(LocationPredicate::smokey), (App)LightPredicate.CODEC.optionalFieldOf("light").forGetter(LocationPredicate::light), (App)BlockPredicate.CODEC.optionalFieldOf("block").forGetter(LocationPredicate::block), (App)FluidPredicate.CODEC.optionalFieldOf("fluid").forGetter(LocationPredicate::fluid), (App)Codec.BOOL.optionalFieldOf("can_see_sky").forGetter(LocationPredicate::canSeeSky)).apply((Applicative)var0, LocationPredicate::new));

    public boolean matches(ServerLevel var0, double var1, double var3, double var5) {
        if (this.position.isPresent() && !this.position.get().matches(var1, var3, var5)) {
            return false;
        }
        if (this.dimension.isPresent() && this.dimension.get() != var0.dimension()) {
            return false;
        }
        BlockPos var7 = BlockPos.containing(var1, var3, var5);
        boolean var8 = var0.isLoaded(var7);
        if (!(!this.biomes.isPresent() || var8 && this.biomes.get().contains(var0.getBiome(var7)))) {
            return false;
        }
        if (!(!this.structures.isPresent() || var8 && var0.structureManager().getStructureWithPieceAt(var7, this.structures.get()).isValid())) {
            return false;
        }
        if (this.smokey.isPresent() && (!var8 || this.smokey.get() != CampfireBlock.isSmokeyPos(var0, var7))) {
            return false;
        }
        if (this.light.isPresent() && !this.light.get().matches(var0, var7)) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().matches(var0, var7)) {
            return false;
        }
        if (this.fluid.isPresent() && !this.fluid.get().matches(var0, var7)) {
            return false;
        }
        return !this.canSeeSky.isPresent() || this.canSeeSky.get().booleanValue() == var0.canSeeSky(var7);
    }

    record PositionPredicate(MinMaxBounds.Doubles x, MinMaxBounds.Doubles y, MinMaxBounds.Doubles z) {
        public static final Codec<PositionPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("x", (Object)MinMaxBounds.Doubles.ANY).forGetter(PositionPredicate::x), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("y", (Object)MinMaxBounds.Doubles.ANY).forGetter(PositionPredicate::y), (App)MinMaxBounds.Doubles.CODEC.optionalFieldOf("z", (Object)MinMaxBounds.Doubles.ANY).forGetter(PositionPredicate::z)).apply((Applicative)var0, PositionPredicate::new));

        static Optional<PositionPredicate> of(MinMaxBounds.Doubles var0, MinMaxBounds.Doubles var1, MinMaxBounds.Doubles var2) {
            if (var0.isAny() && var1.isAny() && var2.isAny()) {
                return Optional.empty();
            }
            return Optional.of(new PositionPredicate(var0, var1, var2));
        }

        public boolean matches(double var0, double var2, double var4) {
            return this.x.matches(var0) && this.y.matches(var2) && this.z.matches(var4);
        }
    }

    public static class Builder {
        private MinMaxBounds.Doubles x = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Doubles y = MinMaxBounds.Doubles.ANY;
        private MinMaxBounds.Doubles z = MinMaxBounds.Doubles.ANY;
        private Optional<HolderSet<Biome>> biomes = Optional.empty();
        private Optional<HolderSet<Structure>> structures = Optional.empty();
        private Optional<ResourceKey<Level>> dimension = Optional.empty();
        private Optional<Boolean> smokey = Optional.empty();
        private Optional<LightPredicate> light = Optional.empty();
        private Optional<BlockPredicate> block = Optional.empty();
        private Optional<FluidPredicate> fluid = Optional.empty();
        private Optional<Boolean> canSeeSky = Optional.empty();

        public static Builder location() {
            return new Builder();
        }

        public static Builder inBiome(Holder<Biome> var0) {
            return Builder.location().setBiomes(HolderSet.direct(var0));
        }

        public static Builder inDimension(ResourceKey<Level> var0) {
            return Builder.location().setDimension(var0);
        }

        public static Builder inStructure(Holder<Structure> var0) {
            return Builder.location().setStructures(HolderSet.direct(var0));
        }

        public static Builder atYLocation(MinMaxBounds.Doubles var0) {
            return Builder.location().setY(var0);
        }

        public Builder setX(MinMaxBounds.Doubles var0) {
            this.x = var0;
            return this;
        }

        public Builder setY(MinMaxBounds.Doubles var0) {
            this.y = var0;
            return this;
        }

        public Builder setZ(MinMaxBounds.Doubles var0) {
            this.z = var0;
            return this;
        }

        public Builder setBiomes(HolderSet<Biome> var0) {
            this.biomes = Optional.of(var0);
            return this;
        }

        public Builder setStructures(HolderSet<Structure> var0) {
            this.structures = Optional.of(var0);
            return this;
        }

        public Builder setDimension(ResourceKey<Level> var0) {
            this.dimension = Optional.of(var0);
            return this;
        }

        public Builder setLight(LightPredicate.Builder var0) {
            this.light = Optional.of(var0.build());
            return this;
        }

        public Builder setBlock(BlockPredicate.Builder var0) {
            this.block = Optional.of(var0.build());
            return this;
        }

        public Builder setFluid(FluidPredicate.Builder var0) {
            this.fluid = Optional.of(var0.build());
            return this;
        }

        public Builder setSmokey(boolean var0) {
            this.smokey = Optional.of(var0);
            return this;
        }

        public Builder setCanSeeSky(boolean var0) {
            this.canSeeSky = Optional.of(var0);
            return this;
        }

        public LocationPredicate build() {
            Optional<PositionPredicate> var0 = PositionPredicate.of(this.x, this.y, this.z);
            return new LocationPredicate(var0, this.biomes, this.structures, this.dimension, this.smokey, this.light, this.block, this.fluid, this.canSeeSky);
        }
    }
}

