/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public interface MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.swapped"));

    public Bounds<T> bounds();

    default public Optional<T> min() {
        return this.bounds().min;
    }

    default public Optional<T> max() {
        return this.bounds().max;
    }

    default public boolean isAny() {
        return this.bounds().isAny();
    }

    public static final class Bounds<T extends Number>
    extends Record {
        final Optional<T> min;
        final Optional<T> max;

        public Bounds(Optional<T> var0, Optional<T> var1) {
            this.min = var0;
            this.max = var1;
        }

        public boolean isAny() {
            return this.min().isEmpty() && this.max().isEmpty();
        }

        public DataResult<Bounds<T>> validateSwappedBoundsInCodec() {
            if (this.areSwapped()) {
                return DataResult.error(() -> "Swapped bounds in range: " + String.valueOf(this.min()) + " is higher than " + String.valueOf(this.max()));
            }
            return DataResult.success((Object)this);
        }

        public boolean areSwapped() {
            return this.min.isPresent() && this.max.isPresent() && ((Comparable)((Object)((Number)this.min.get()))).compareTo((Number)this.max.get()) > 0;
        }

        public Optional<T> asPoint() {
            Optional<T> var1;
            Optional<T> var0 = this.min();
            return var0.equals(var1 = this.max()) ? var0 : Optional.empty();
        }

        public static <T extends Number> Bounds<T> any() {
            return new Bounds(Optional.empty(), Optional.empty());
        }

        public static <T extends Number> Bounds<T> exactly(T var0) {
            Optional<T> var1 = Optional.of(var0);
            return new Bounds<T>(var1, var1);
        }

        public static <T extends Number> Bounds<T> between(T var0, T var1) {
            return new Bounds<T>(Optional.of(var0), Optional.of(var1));
        }

        public static <T extends Number> Bounds<T> atLeast(T var0) {
            return new Bounds<T>(Optional.of(var0), Optional.empty());
        }

        public static <T extends Number> Bounds<T> atMost(T var0) {
            return new Bounds(Optional.empty(), Optional.of(var0));
        }

        public <U extends Number> Bounds<U> map(Function<T, U> var0) {
            return new Bounds<U>(this.min.map(var0), this.max.map(var0));
        }

        static <T extends Number> Codec<Bounds<T>> createCodec(Codec<T> var03) {
            Codec var12 = RecordCodecBuilder.create(var1 -> var1.group((App)var03.optionalFieldOf("min").forGetter(Bounds::min), (App)var03.optionalFieldOf("max").forGetter(Bounds::max)).apply((Applicative)var1, Bounds::new));
            return Codec.either((Codec)var12, var03).xmap(var02 -> (Bounds)var02.map(var0 -> var0, var0 -> Bounds.exactly((Number)var0)), var0 -> {
                Optional var1 = var0.asPoint();
                return var1.isPresent() ? Either.right((Object)((Number)var1.get())) : Either.left((Object)var0);
            });
        }

        static <B extends ByteBuf, T extends Number> StreamCodec<B, Bounds<T>> createStreamCodec(final StreamCodec<B, T> var0) {
            return new StreamCodec<B, Bounds<T>>(){
                private static final int MIN_FLAG = 1;
                private static final int MAX_FLAG = 2;

                @Override
                public Bounds<T> decode(B var02) {
                    byte var1 = var02.readByte();
                    Optional var2 = (var1 & 1) != 0 ? Optional.of((Number)var0.decode(var02)) : Optional.empty();
                    Optional var3 = (var1 & 2) != 0 ? Optional.of((Number)var0.decode(var02)) : Optional.empty();
                    return new Bounds(var2, var3);
                }

                @Override
                public void encode(B var02, Bounds<T> var1) {
                    Optional<Number> var22 = var1.min();
                    Optional<Number> var3 = var1.max();
                    var02.writeByte((var22.isPresent() ? 1 : 0) | (var3.isPresent() ? 2 : 0));
                    var22.ifPresent(var2 -> var0.encode(var02, var2));
                    var3.ifPresent(var2 -> var0.encode(var02, var2));
                }

                @Override
                public /* synthetic */ void encode(Object object, Object object2) {
                    this.encode((Object)((ByteBuf)object), (Bounds)object2);
                }

                @Override
                public /* synthetic */ Object decode(Object object) {
                    return this.decode((B)((ByteBuf)object));
                }
            };
        }

        public static <T extends Number> Bounds<T> fromReader(StringReader var0, Function<String, T> var1, Supplier<DynamicCommandExceptionType> var2) throws CommandSyntaxException {
            if (!var0.canRead()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
            }
            int var3 = var0.getCursor();
            try {
                Optional<T> var5;
                Optional<T> var4 = Bounds.readNumber(var0, var1, var2);
                if (var0.canRead(2) && var0.peek() == '.' && var0.peek(1) == '.') {
                    var0.skip();
                    var0.skip();
                    var5 = Bounds.readNumber(var0, var1, var2);
                } else {
                    var5 = var4;
                }
                if (var4.isEmpty() && var5.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
                }
                return new Bounds<T>(var4, var5);
            }
            catch (CommandSyntaxException var4) {
                var0.setCursor(var3);
                throw new CommandSyntaxException(var4.getType(), var4.getRawMessage(), var4.getInput(), var3);
            }
        }

        private static <T extends Number> Optional<T> readNumber(StringReader var0, Function<String, T> var1, Supplier<DynamicCommandExceptionType> var2) throws CommandSyntaxException {
            int var3 = var0.getCursor();
            while (var0.canRead() && Bounds.isAllowedInputChar(var0)) {
                var0.skip();
            }
            String var4 = var0.getString().substring(var3, var0.getCursor());
            if (var4.isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of((Number)var1.apply(var4));
            }
            catch (NumberFormatException var5) {
                throw var2.get().createWithContext((ImmutableStringReader)var0, (Object)var4);
            }
        }

        private static boolean isAllowedInputChar(StringReader var0) {
            char var1 = var0.peek();
            if (var1 >= '0' && var1 <= '9' || var1 == '-') {
                return true;
            }
            if (var1 == '.') {
                return !var0.canRead(2) || var0.peek(1) != '.';
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Bounds.class, "min;max", "min", "max"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Bounds.class, "min;max", "min", "max"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Bounds.class, "min;max", "min", "max"}, this, var0);
        }

        public Optional<T> min() {
            return this.min;
        }

        public Optional<T> max() {
            return this.max;
        }
    }

    public record FloatDegrees(Bounds<Float> bounds) implements MinMaxBounds<Float>
    {
        public static final FloatDegrees ANY = new FloatDegrees(Bounds.any());
        public static final Codec<FloatDegrees> CODEC = Bounds.createCodec(Codec.FLOAT).xmap(FloatDegrees::new, FloatDegrees::bounds);
        public static final StreamCodec<ByteBuf, FloatDegrees> STREAM_CODEC = Bounds.createStreamCodec(ByteBufCodecs.FLOAT).map(FloatDegrees::new, FloatDegrees::bounds);

        public static FloatDegrees fromReader(StringReader var0) throws CommandSyntaxException {
            Bounds<Float> var1 = Bounds.fromReader(var0, Float::parseFloat, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidFloat());
            return new FloatDegrees(var1);
        }
    }

    public record Doubles(Bounds<Double> bounds, Bounds<Double> boundsSqr) implements MinMaxBounds<Double>
    {
        public static final Doubles ANY = new Doubles(Bounds.any());
        public static final Codec<Doubles> CODEC = Bounds.createCodec(Codec.DOUBLE).validate(Bounds::validateSwappedBoundsInCodec).xmap(Doubles::new, Doubles::bounds);
        public static final StreamCodec<ByteBuf, Doubles> STREAM_CODEC = Bounds.createStreamCodec(ByteBufCodecs.DOUBLE).map(Doubles::new, Doubles::bounds);

        private Doubles(Bounds<Double> var0) {
            this(var0, var0.map(Mth::square));
        }

        public static Doubles exactly(double var0) {
            return new Doubles(Bounds.exactly(var0));
        }

        public static Doubles between(double var0, double var2) {
            return new Doubles(Bounds.between(var0, var2));
        }

        public static Doubles atLeast(double var0) {
            return new Doubles(Bounds.atLeast(var0));
        }

        public static Doubles atMost(double var0) {
            return new Doubles(Bounds.atMost(var0));
        }

        public boolean matches(double var0) {
            if (this.bounds.min.isPresent() && (Double)this.bounds.min.get() > var0) {
                return false;
            }
            return this.bounds.max.isEmpty() || !((Double)this.bounds.max.get() < var0);
        }

        public boolean matchesSqr(double var0) {
            if (this.boundsSqr.min.isPresent() && (Double)this.boundsSqr.min.get() > var0) {
                return false;
            }
            return this.boundsSqr.max.isEmpty() || !((Double)this.boundsSqr.max.get() < var0);
        }

        public static Doubles fromReader(StringReader var0) throws CommandSyntaxException {
            int var1 = var0.getCursor();
            Bounds<Double> var2 = Bounds.fromReader(var0, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble());
            if (var2.areSwapped()) {
                var0.setCursor(var1);
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new Doubles(var2);
        }
    }

    public record Ints(Bounds<Integer> bounds, Bounds<Long> boundsSqr) implements MinMaxBounds<Integer>
    {
        public static final Ints ANY = new Ints(Bounds.any());
        public static final Codec<Ints> CODEC = Bounds.createCodec(Codec.INT).validate(Bounds::validateSwappedBoundsInCodec).xmap(Ints::new, Ints::bounds);
        public static final StreamCodec<ByteBuf, Ints> STREAM_CODEC = Bounds.createStreamCodec(ByteBufCodecs.INT).map(Ints::new, Ints::bounds);

        private Ints(Bounds<Integer> var02) {
            this(var02, var02.map(var0 -> Mth.square(var0.longValue())));
        }

        public static Ints exactly(int var0) {
            return new Ints(Bounds.exactly(var0));
        }

        public static Ints between(int var0, int var1) {
            return new Ints(Bounds.between(var0, var1));
        }

        public static Ints atLeast(int var0) {
            return new Ints(Bounds.atLeast(var0));
        }

        public static Ints atMost(int var0) {
            return new Ints(Bounds.atMost(var0));
        }

        public boolean matches(int var0) {
            if (this.bounds.min.isPresent() && (Integer)this.bounds.min.get() > var0) {
                return false;
            }
            return this.bounds.max.isEmpty() || (Integer)this.bounds.max.get() >= var0;
        }

        public boolean matchesSqr(long var0) {
            if (this.boundsSqr.min.isPresent() && (Long)this.boundsSqr.min.get() > var0) {
                return false;
            }
            return this.boundsSqr.max.isEmpty() || (Long)this.boundsSqr.max.get() >= var0;
        }

        public static Ints fromReader(StringReader var0) throws CommandSyntaxException {
            int var1 = var0.getCursor();
            Bounds<Integer> var2 = Bounds.fromReader(var0, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt());
            if (var2.areSwapped()) {
                var0.setCursor(var1);
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)var0);
            }
            return new Ints(var2);
        }
    }
}

