/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.TagValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public record NbtPredicate(CompoundTag tag) {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<NbtPredicate> CODEC = TagParser.LENIENT_CODEC.xmap(NbtPredicate::new, NbtPredicate::tag);
    public static final StreamCodec<ByteBuf, NbtPredicate> STREAM_CODEC = ByteBufCodecs.COMPOUND_TAG.map(NbtPredicate::new, NbtPredicate::tag);
    public static final String SELECTED_ITEM_TAG = "SelectedItem";

    public boolean matches(DataComponentGetter var0) {
        CustomData var1 = var0.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY);
        return var1.matchedBy(this.tag);
    }

    public boolean matches(Entity var0) {
        return this.matches(NbtPredicate.getEntityTagToCompare(var0));
    }

    public boolean matches(@Nullable Tag var0) {
        return var0 != null && NbtUtils.compareNbt(this.tag, var0, true);
    }

    public static CompoundTag getEntityTagToCompare(Entity var0) {
        try (ProblemReporter.ScopedCollector var1 = new ProblemReporter.ScopedCollector(var0.problemPath(), LOGGER);){
            Player var3;
            ItemStack var4;
            TagValueOutput var2 = TagValueOutput.createWithContext(var1, var0.registryAccess());
            var0.saveWithoutId(var2);
            if (var0 instanceof Player && !(var4 = (var3 = (Player)var0).getInventory().getSelectedItem()).isEmpty()) {
                var2.store(SELECTED_ITEM_TAG, ItemStack.CODEC, var4);
            }
            CompoundTag compoundTag = var2.buildResult();
            return compoundTag;
        }
    }
}

