/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.criterion.ContextAwarePredicate;
import net.minecraft.advancements.criterion.CriterionValidator;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.loot.LootContext;

public abstract class SimpleCriterionTrigger<T extends SimpleInstance>
implements CriterionTrigger<T> {
    private final Map<PlayerAdvancements, Set<CriterionTrigger.Listener<T>>> players = Maps.newIdentityHashMap();

    @Override
    public final void addPlayerListener(PlayerAdvancements var02, CriterionTrigger.Listener<T> var1) {
        this.players.computeIfAbsent(var02, var0 -> Sets.newHashSet()).add(var1);
    }

    @Override
    public final void removePlayerListener(PlayerAdvancements var0, CriterionTrigger.Listener<T> var1) {
        Set<CriterionTrigger.Listener<T>> var2 = this.players.get(var0);
        if (var2 != null) {
            var2.remove(var1);
            if (var2.isEmpty()) {
                this.players.remove(var0);
            }
        }
    }

    @Override
    public final void removePlayerListeners(PlayerAdvancements var0) {
        this.players.remove(var0);
    }

    protected void trigger(ServerPlayer var0, Predicate<T> var1) {
        PlayerAdvancements var2 = var0.getAdvancements();
        Set<CriterionTrigger.Listener<T>> var3 = this.players.get(var2);
        if (var3 == null || var3.isEmpty()) {
            return;
        }
        LootContext var4 = EntityPredicate.createContext(var0, var0);
        List var5 = null;
        for (CriterionTrigger.Listener<Object> var7 : var3) {
            Optional<ContextAwarePredicate> var9;
            SimpleInstance var8 = (SimpleInstance)var7.trigger();
            if (!var1.test(var8) || !(var9 = var8.player()).isEmpty() && !var9.get().matches(var4)) continue;
            if (var5 == null) {
                var5 = Lists.newArrayList();
            }
            var5.add(var7);
        }
        if (var5 != null) {
            for (CriterionTrigger.Listener<Object> var7 : var5) {
                var7.run(var2);
            }
        }
    }

    public static interface SimpleInstance
    extends CriterionTriggerInstance {
        @Override
        default public void validate(CriterionValidator var0) {
            var0.validateEntity(this.player(), "player");
        }

        public Optional<ContextAwarePredicate> player();
    }
}

