/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.permissions.Permissions;
import org.jspecify.annotations.Nullable;

public class MessageArgument
implements SignedArgument<Message> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");
    static final Dynamic2CommandExceptionType TOO_LONG = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("argument.message.too_long", var0, var1));

    public static MessageArgument message() {
        return new MessageArgument();
    }

    public static Component getMessage(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        Message var2 = (Message)var0.getArgument(var1, Message.class);
        return var2.resolveComponent((CommandSourceStack)var0.getSource());
    }

    public static void resolveChatMessage(CommandContext<CommandSourceStack> var0, String var1, Consumer<PlayerChatMessage> var2) throws CommandSyntaxException {
        Message var3 = (Message)var0.getArgument(var1, Message.class);
        CommandSourceStack var4 = (CommandSourceStack)var0.getSource();
        Component var5 = var3.resolveComponent(var4);
        CommandSigningContext var6 = var4.getSigningContext();
        PlayerChatMessage var7 = var6.getArgument(var1);
        if (var7 != null) {
            MessageArgument.resolveSignedMessage(var2, var4, var7.withUnsignedContent(var5));
        } else {
            MessageArgument.resolveDisguisedMessage(var2, var4, PlayerChatMessage.system(var3.text).withUnsignedContent(var5));
        }
    }

    private static void resolveSignedMessage(Consumer<PlayerChatMessage> var0, CommandSourceStack var1, PlayerChatMessage var2) {
        MinecraftServer var32 = var1.getServer();
        CompletableFuture<FilteredText> var4 = MessageArgument.filterPlainText(var1, var2);
        Component var5 = var32.getChatDecorator().decorate(var1.getPlayer(), var2.decoratedContent());
        var1.getChatMessageChainer().append(var4, var3 -> {
            PlayerChatMessage var4 = var2.withUnsignedContent(var5).filter(var3.mask());
            var0.accept(var4);
        });
    }

    private static void resolveDisguisedMessage(Consumer<PlayerChatMessage> var0, CommandSourceStack var1, PlayerChatMessage var2) {
        ChatDecorator var3 = var1.getServer().getChatDecorator();
        Component var4 = var3.decorate(var1.getPlayer(), var2.decoratedContent());
        var0.accept(var2.withUnsignedContent(var4));
    }

    private static CompletableFuture<FilteredText> filterPlainText(CommandSourceStack var0, PlayerChatMessage var1) {
        ServerPlayer var2 = var0.getPlayer();
        if (var2 != null && var1.hasSignatureFrom(var2.getUUID())) {
            return var2.getTextFilter().processStreamMessage(var1.signedContent());
        }
        return CompletableFuture.completedFuture(FilteredText.passThrough(var1.signedContent()));
    }

    public Message parse(StringReader var0) throws CommandSyntaxException {
        return Message.parseText(var0, true);
    }

    public <S> Message parse(StringReader var0, @Nullable S var1) throws CommandSyntaxException {
        return Message.parseText(var0, EntitySelectorParser.allowSelectors(var1));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader, @Nullable Object object) throws CommandSyntaxException {
        return this.parse(stringReader, object);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static final class Message
    extends Record {
        final String text;
        private final Part[] parts;

        public Message(String var0, Part[] var1) {
            this.text = var0;
            this.parts = var1;
        }

        Component resolveComponent(CommandSourceStack var0) throws CommandSyntaxException {
            return this.toComponent(var0, var0.permissions().hasPermission(Permissions.COMMANDS_ENTITY_SELECTORS));
        }

        public Component toComponent(CommandSourceStack var0, boolean var1) throws CommandSyntaxException {
            if (this.parts.length == 0 || !var1) {
                return Component.literal(this.text);
            }
            MutableComponent var2 = Component.literal(this.text.substring(0, this.parts[0].start()));
            int var3 = this.parts[0].start();
            for (Part var7 : this.parts) {
                Component var8 = var7.toComponent(var0);
                if (var3 < var7.start()) {
                    var2.append(this.text.substring(var3, var7.start()));
                }
                var2.append(var8);
                var3 = var7.end();
            }
            if (var3 < this.text.length()) {
                var2.append(this.text.substring(var3));
            }
            return var2;
        }

        public static Message parseText(StringReader var0, boolean var1) throws CommandSyntaxException {
            if (var0.getRemainingLength() > 256) {
                throw TOO_LONG.create((Object)var0.getRemainingLength(), (Object)256);
            }
            String var2 = var0.getRemaining();
            if (!var1) {
                var0.setCursor(var0.getTotalLength());
                return new Message(var2, new Part[0]);
            }
            ArrayList var3 = Lists.newArrayList();
            int var4 = var0.getCursor();
            while (var0.canRead()) {
                if (var0.peek() == '@') {
                    EntitySelector var6;
                    int var5 = var0.getCursor();
                    try {
                        EntitySelectorParser var7 = new EntitySelectorParser(var0, true);
                        var6 = var7.parse();
                    }
                    catch (CommandSyntaxException var7) {
                        if (var7.getType() == EntitySelectorParser.ERROR_MISSING_SELECTOR_TYPE || var7.getType() == EntitySelectorParser.ERROR_UNKNOWN_SELECTOR_TYPE) {
                            var0.setCursor(var5 + 1);
                            continue;
                        }
                        throw var7;
                    }
                    var3.add(new Part(var5 - var4, var0.getCursor() - var4, var6));
                    continue;
                }
                var0.skip();
            }
            return new Message(var2, var3.toArray(new Part[0]));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Message.class, "text;parts", "text", "parts"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Message.class, "text;parts", "text", "parts"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Message.class, "text;parts", "text", "parts"}, this, var0);
        }

        public String text() {
            return this.text;
        }

        public Part[] parts() {
            return this.parts;
        }
    }

    public record Part(int start, int end, EntitySelector selector) {
        public Component toComponent(CommandSourceStack var0) throws CommandSyntaxException {
            return EntitySelector.joinNames(this.selector.findEntities(var0));
        }
    }
}

