/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.scores.ScoreAccess;

public class OperationArgument
implements ArgumentType<Operation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType ERROR_INVALID_OPERATION = new SimpleCommandExceptionType((Message)Component.translatable("arguments.operation.invalid"));
    private static final SimpleCommandExceptionType ERROR_DIVIDE_BY_ZERO = new SimpleCommandExceptionType((Message)Component.translatable("arguments.operation.div0"));

    public static OperationArgument operation() {
        return new OperationArgument();
    }

    public static Operation getOperation(CommandContext<CommandSourceStack> var0, String var1) {
        return (Operation)var0.getArgument(var1, Operation.class);
    }

    public Operation parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead()) {
            int var1 = var0.getCursor();
            while (var0.canRead() && var0.peek() != ' ') {
                var0.skip();
            }
            return OperationArgument.getOperation(var0.getString().substring(var1, var0.getCursor()));
        }
        throw ERROR_INVALID_OPERATION.createWithContext((ImmutableStringReader)var0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return SharedSuggestionProvider.suggest(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static Operation getOperation(String var02) throws CommandSyntaxException {
        if (var02.equals("><")) {
            return (var0, var1) -> {
                int var2 = var0.get();
                var0.set(var1.get());
                var1.set(var2);
            };
        }
        return OperationArgument.getSimpleOperation(var02);
    }

    private static SimpleOperation getSimpleOperation(String var02) throws CommandSyntaxException {
        return switch (var02) {
            case "=" -> (var0, var1) -> var1;
            case "+=" -> Integer::sum;
            case "-=" -> (var0, var1) -> var0 - var1;
            case "*=" -> (var0, var1) -> var0 * var1;
            case "/=" -> (var0, var1) -> {
                if (var1 == 0) {
                    throw ERROR_DIVIDE_BY_ZERO.create();
                }
                return Mth.floorDiv(var0, var1);
            };
            case "%=" -> (var0, var1) -> {
                if (var1 == 0) {
                    throw ERROR_DIVIDE_BY_ZERO.create();
                }
                return Mth.positiveModulo(var0, var1);
            };
            case "<" -> Math::min;
            case ">" -> Math::max;
            default -> throw ERROR_INVALID_OPERATION.create();
        };
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    @FunctionalInterface
    public static interface Operation {
        public void apply(ScoreAccess var1, ScoreAccess var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface SimpleOperation
    extends Operation {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(ScoreAccess var0, ScoreAccess var1) throws CommandSyntaxException {
            var0.set(this.apply(var0.get(), var1.get()));
        }
    }
}

