/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreHolder;

public class ScoreHolderArgument
implements ArgumentType<Result> {
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_SCORE_HOLDERS = (var0, var12) -> {
        StringReader var2 = new StringReader(var12.getInput());
        var2.setCursor(var12.getStart());
        EntitySelectorParser var3 = new EntitySelectorParser(var2, ((CommandSourceStack)var0.getSource()).permissions().hasPermission(Permissions.COMMANDS_ENTITY_SELECTORS));
        try {
            var3.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var3.fillSuggestions(var12, var1 -> SharedSuggestionProvider.suggest(((CommandSourceStack)var0.getSource()).getOnlinePlayerNames(), var1));
    };
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType ERROR_NO_RESULTS = new SimpleCommandExceptionType((Message)Component.translatable("argument.scoreHolder.empty"));
    final boolean multiple;

    public ScoreHolderArgument(boolean var0) {
        this.multiple = var0;
    }

    public static ScoreHolder getName(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(var0, var1).iterator().next();
    }

    public static Collection<ScoreHolder> getNames(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(var0, var1, Collections::emptyList);
    }

    public static Collection<ScoreHolder> getNamesWithDefaultWildcard(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(var0, var1, ((CommandSourceStack)var0.getSource()).getServer().getScoreboard()::getTrackedPlayers);
    }

    public static Collection<ScoreHolder> getNames(CommandContext<CommandSourceStack> var0, String var1, Supplier<Collection<ScoreHolder>> var2) throws CommandSyntaxException {
        Collection<ScoreHolder> var3 = ((Result)var0.getArgument(var1, Result.class)).getNames((CommandSourceStack)var0.getSource(), var2);
        if (var3.isEmpty()) {
            throw EntityArgument.NO_ENTITIES_FOUND.create();
        }
        return var3;
    }

    public static ScoreHolderArgument scoreHolder() {
        return new ScoreHolderArgument(false);
    }

    public static ScoreHolderArgument scoreHolders() {
        return new ScoreHolderArgument(true);
    }

    public Result parse(StringReader var0) throws CommandSyntaxException {
        return this.parse(var0, true);
    }

    public <S> Result parse(StringReader var0, S var1) throws CommandSyntaxException {
        return this.parse(var0, EntitySelectorParser.allowSelectors(var1));
    }

    private Result parse(StringReader var02, boolean var12) throws CommandSyntaxException {
        if (var02.canRead() && var02.peek() == '@') {
            EntitySelectorParser var22 = new EntitySelectorParser(var02, var12);
            EntitySelector var32 = var22.parse();
            if (!this.multiple && var32.getMaxResults() > 1) {
                throw EntityArgument.ERROR_NOT_SINGLE_ENTITY.createWithContext((ImmutableStringReader)var02);
            }
            return new SelectorResult(var32);
        }
        int var23 = var02.getCursor();
        while (var02.canRead() && var02.peek() != ' ') {
            var02.skip();
        }
        String var33 = var02.getString().substring(var23, var02.getCursor());
        if (var33.equals("*")) {
            return (var0, var1) -> {
                Collection var2 = (Collection)var1.get();
                if (var2.isEmpty()) {
                    throw ERROR_NO_RESULTS.create();
                }
                return var2;
            };
        }
        List<ScoreHolder> var4 = List.of(ScoreHolder.forNameOnly(var33));
        if (var33.startsWith("#")) {
            return (var1, var2) -> var4;
        }
        try {
            UUID var5 = UUID.fromString(var33);
            return (var2, var3) -> {
                MinecraftServer var4 = var2.getServer();
                Entity var5 = null;
                ArrayList<Entity> var6 = null;
                for (ServerLevel var8 : var4.getAllLevels()) {
                    Entity var9 = var8.getEntity(var5);
                    if (var9 == null) continue;
                    if (var5 == null) {
                        var5 = var9;
                        continue;
                    }
                    if (var6 == null) {
                        var6 = new ArrayList<Entity>();
                        var6.add(var5);
                    }
                    var6.add(var9);
                }
                if (var6 != null) {
                    return var6;
                }
                if (var5 != null) {
                    return List.of(var5);
                }
                return var4;
            };
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (var2, var3) -> {
                MinecraftServer var4 = var2.getServer();
                ServerPlayer var5 = var4.getPlayerList().getPlayerByName(var33);
                if (var5 != null) {
                    return List.of(var5);
                }
                return var4;
            };
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader, Object object) throws CommandSyntaxException {
        return this.parse(stringReader, object);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    @FunctionalInterface
    public static interface Result {
        public Collection<ScoreHolder> getNames(CommandSourceStack var1, Supplier<Collection<ScoreHolder>> var2) throws CommandSyntaxException;
    }

    public static class SelectorResult
    implements Result {
        private final EntitySelector selector;

        public SelectorResult(EntitySelector var0) {
            this.selector = var0;
        }

        @Override
        public Collection<ScoreHolder> getNames(CommandSourceStack var0, Supplier<Collection<ScoreHolder>> var1) throws CommandSyntaxException {
            List<? extends Entity> var2 = this.selector.findEntities(var0);
            if (var2.isEmpty()) {
                throw EntityArgument.NO_ENTITIES_FOUND.create();
            }
            return List.copyOf(var2);
        }
    }

    public static class Info
    implements ArgumentTypeInfo<ScoreHolderArgument, Template> {
        private static final byte FLAG_MULTIPLE = 1;

        @Override
        public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
            int var2 = 0;
            if (var0.multiple) {
                var2 |= 1;
            }
            var1.writeByte(var2);
        }

        @Override
        public Template deserializeFromNetwork(FriendlyByteBuf var0) {
            byte var1 = var0.readByte();
            boolean var2 = (var1 & 1) != 0;
            return new Template(var2);
        }

        @Override
        public void serializeToJson(Template var0, JsonObject var1) {
            var1.addProperty("amount", var0.multiple ? "multiple" : "single");
        }

        @Override
        public Template unpack(ScoreHolderArgument var0) {
            return new Template(var0.multiple);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
            return this.deserializeFromNetwork(friendlyByteBuf);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<ScoreHolderArgument> {
            final boolean multiple;

            Template(boolean var1) {
                this.multiple = var1;
            }

            @Override
            public ScoreHolderArgument instantiate(CommandBuildContext var0) {
                return new ScoreHolderArgument(this.multiple);
            }

            @Override
            public ArgumentTypeInfo<ScoreHolderArgument, ?> type() {
                return Info.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

