/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.mojang.logging.LogUtils;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BlockInput
implements Predicate<BlockInWorld> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockState state;
    private final Set<Property<?>> properties;
    private final @Nullable CompoundTag tag;

    public BlockInput(BlockState var0, Set<Property<?>> var1, @Nullable CompoundTag var2) {
        this.state = var0;
        this.properties = var1;
        this.tag = var2;
    }

    public BlockState getState() {
        return this.state;
    }

    public Set<Property<?>> getDefinedProperties() {
        return this.properties;
    }

    @Override
    public boolean test(BlockInWorld var0) {
        BlockState var1 = var0.getState();
        if (!var1.is(this.state.getBlock())) {
            return false;
        }
        for (Property<?> var3 : this.properties) {
            if (var1.getValue(var3) == this.state.getValue(var3)) continue;
            return false;
        }
        if (this.tag != null) {
            BlockEntity var2 = var0.getEntity();
            return var2 != null && NbtUtils.compareNbt(this.tag, var2.saveWithFullMetadata(var0.getLevel().registryAccess()), true);
        }
        return true;
    }

    public boolean test(ServerLevel var0, BlockPos var1) {
        return this.test(new BlockInWorld(var0, var1, false));
    }

    public boolean place(ServerLevel var0, BlockPos var1, @Block.UpdateFlags int var2) {
        BlockEntity var5;
        BlockState var3;
        BlockState blockState = var3 = (var2 & 0x10) != 0 ? this.state : Block.updateFromNeighbourShapes(this.state, var0, var1);
        if (var3.isAir()) {
            var3 = this.state;
        }
        var3 = this.overwriteWithDefinedProperties(var3);
        boolean var4 = false;
        if (var0.setBlock(var1, var3, var2)) {
            var4 = true;
        }
        if (this.tag != null && (var5 = var0.getBlockEntity(var1)) != null) {
            try (ProblemReporter.ScopedCollector var6 = new ProblemReporter.ScopedCollector(LOGGER);){
                RegistryAccess var7 = var0.registryAccess();
                ProblemReporter var8 = var6.forChild(var5.problemPath());
                TagValueOutput var9 = TagValueOutput.createWithContext(var8.forChild(() -> "(before)"), var7);
                var5.saveWithoutMetadata(var9);
                CompoundTag var10 = var9.buildResult();
                var5.loadWithComponents(TagValueInput.create((ProblemReporter)var6, (HolderLookup.Provider)var7, this.tag));
                TagValueOutput var11 = TagValueOutput.createWithContext(var8.forChild(() -> "(after)"), var7);
                var5.saveWithoutMetadata(var11);
                CompoundTag var12 = var11.buildResult();
                if (!var12.equals(var10)) {
                    var4 = true;
                    var5.setChanged();
                    var0.getChunkSource().blockChanged(var1);
                }
            }
        }
        return var4;
    }

    private BlockState overwriteWithDefinedProperties(BlockState var0) {
        if (var0 == this.state) {
            return var0;
        }
        for (Property<?> var2 : this.properties) {
            var0 = BlockInput.copyProperty(var0, this.state, var2);
        }
        return var0;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState var0, BlockState var1, Property<T> var2) {
        return (BlockState)var0.trySetValue(var2, var1.getValue(var2));
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((BlockInWorld)object);
    }
}

