/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.LocalCoordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class BlockPosArgument
implements ArgumentType<Coordinates> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "~0.5 ~1 ~-5");
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.unloaded"));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_WORLD = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.outofworld"));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_BOUNDS = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.outofbounds"));

    public static BlockPosArgument blockPos() {
        return new BlockPosArgument();
    }

    public static BlockPos getLoadedBlockPos(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        ServerLevel var2 = ((CommandSourceStack)var0.getSource()).getLevel();
        return BlockPosArgument.getLoadedBlockPos(var0, var2, var1);
    }

    public static BlockPos getLoadedBlockPos(CommandContext<CommandSourceStack> var0, ServerLevel var1, String var2) throws CommandSyntaxException {
        BlockPos var3 = BlockPosArgument.getBlockPos(var0, var2);
        if (!var1.hasChunkAt(var3)) {
            throw ERROR_NOT_LOADED.create();
        }
        if (!var1.isInWorldBounds(var3)) {
            throw ERROR_OUT_OF_WORLD.create();
        }
        return var3;
    }

    public static BlockPos getBlockPos(CommandContext<CommandSourceStack> var0, String var1) {
        return ((Coordinates)var0.getArgument(var1, Coordinates.class)).getBlockPos((CommandSourceStack)var0.getSource());
    }

    public static BlockPos getSpawnablePos(CommandContext<CommandSourceStack> var0, String var1) throws CommandSyntaxException {
        BlockPos var2 = BlockPosArgument.getBlockPos(var0, var1);
        if (!Level.isInSpawnableBounds(var2)) {
            throw ERROR_OUT_OF_BOUNDS.create();
        }
        return var2;
    }

    public Coordinates parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '^') {
            return LocalCoordinates.parse(var0);
        }
        return WorldCoordinates.parseInt(var0);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof SharedSuggestionProvider) {
            String var2 = var1.getRemaining();
            Collection<SharedSuggestionProvider.TextCoordinates> var3 = !var2.isEmpty() && var2.charAt(0) == '^' ? Collections.singleton(SharedSuggestionProvider.TextCoordinates.DEFAULT_LOCAL) : ((SharedSuggestionProvider)var0.getSource()).getRelevantCoordinates();
            return SharedSuggestionProvider.suggestCoordinates(var2, var3, var1, Commands.createValidator(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

