/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public record LocalCoordinates(double left, double up, double forwards) implements Coordinates
{
    public static final char PREFIX_LOCAL_COORDINATE = '^';

    @Override
    public Vec3 getPosition(CommandSourceStack var0) {
        Vec3 var1 = var0.getAnchor().apply(var0);
        return Vec3.applyLocalCoordinatesToRotation(var0.getRotation(), new Vec3(this.left, this.up, this.forwards)).add(var1.x, var1.y, var1.z);
    }

    @Override
    public Vec2 getRotation(CommandSourceStack var0) {
        return Vec2.ZERO;
    }

    @Override
    public boolean isXRelative() {
        return true;
    }

    @Override
    public boolean isYRelative() {
        return true;
    }

    @Override
    public boolean isZRelative() {
        return true;
    }

    public static LocalCoordinates parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        double var2 = LocalCoordinates.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var4 = LocalCoordinates.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var6 = LocalCoordinates.readDouble(var0, var1);
        return new LocalCoordinates(var2, var4, var6);
    }

    private static double readDouble(StringReader var0, int var1) throws CommandSyntaxException {
        if (!var0.canRead()) {
            throw WorldCoordinate.ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)var0);
        }
        if (var0.peek() != '^') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        return var0.canRead() && var0.peek() != ' ' ? var0.readDouble() : 0.0;
    }
}

