/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public record WorldCoordinates(WorldCoordinate x, WorldCoordinate y, WorldCoordinate z) implements Coordinates
{
    public static final WorldCoordinates ZERO_ROTATION = WorldCoordinates.absolute(new Vec2(0.0f, 0.0f));

    @Override
    public Vec3 getPosition(CommandSourceStack var0) {
        Vec3 var1 = var0.getPosition();
        return new Vec3(this.x.get(var1.x), this.y.get(var1.y), this.z.get(var1.z));
    }

    @Override
    public Vec2 getRotation(CommandSourceStack var0) {
        Vec2 var1 = var0.getRotation();
        return new Vec2((float)this.x.get(var1.x), (float)this.y.get(var1.y));
    }

    @Override
    public boolean isXRelative() {
        return this.x.isRelative();
    }

    @Override
    public boolean isYRelative() {
        return this.y.isRelative();
    }

    @Override
    public boolean isZRelative() {
        return this.z.isRelative();
    }

    public static WorldCoordinates parseInt(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        WorldCoordinate var2 = WorldCoordinate.parseInt(var0);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        WorldCoordinate var3 = WorldCoordinate.parseInt(var0);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        WorldCoordinate var4 = WorldCoordinate.parseInt(var0);
        return new WorldCoordinates(var2, var3, var4);
    }

    public static WorldCoordinates parseDouble(StringReader var0, boolean var1) throws CommandSyntaxException {
        int var2 = var0.getCursor();
        WorldCoordinate var3 = WorldCoordinate.parseDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var2);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        WorldCoordinate var4 = WorldCoordinate.parseDouble(var0, false);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var2);
            throw Vec3Argument.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        WorldCoordinate var5 = WorldCoordinate.parseDouble(var0, var1);
        return new WorldCoordinates(var3, var4, var5);
    }

    public static WorldCoordinates absolute(double var0, double var2, double var4) {
        return new WorldCoordinates(new WorldCoordinate(false, var0), new WorldCoordinate(false, var2), new WorldCoordinate(false, var4));
    }

    public static WorldCoordinates absolute(Vec2 var0) {
        return new WorldCoordinates(new WorldCoordinate(false, var0.x), new WorldCoordinate(false, var0.y), new WorldCoordinate(true, 0.0));
    }
}

