/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.network.FriendlyByteBuf;

public class LongArgumentInfo
implements ArgumentTypeInfo<LongArgumentType, Template> {
    @Override
    public void serializeToNetwork(Template var0, FriendlyByteBuf var1) {
        boolean var2 = var0.min != Long.MIN_VALUE;
        boolean var3 = var0.max != Long.MAX_VALUE;
        var1.writeByte(ArgumentUtils.createNumberFlags(var2, var3));
        if (var2) {
            var1.writeLong(var0.min);
        }
        if (var3) {
            var1.writeLong(var0.max);
        }
    }

    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf var0) {
        byte var1 = var0.readByte();
        long var2 = ArgumentUtils.numberHasMin(var1) ? var0.readLong() : Long.MIN_VALUE;
        long var4 = ArgumentUtils.numberHasMax(var1) ? var0.readLong() : Long.MAX_VALUE;
        return new Template(var2, var4);
    }

    @Override
    public void serializeToJson(Template var0, JsonObject var1) {
        if (var0.min != Long.MIN_VALUE) {
            var1.addProperty("min", (Number)var0.min);
        }
        if (var0.max != Long.MAX_VALUE) {
            var1.addProperty("max", (Number)var0.max);
        }
    }

    @Override
    public Template unpack(LongArgumentType var0) {
        return new Template(var0.getMinimum(), var0.getMaximum());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        return this.deserializeFromNetwork(friendlyByteBuf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<LongArgumentType> {
        final long min;
        final long max;

        Template(long var1, long var3) {
            this.min = var1;
            this.max = var3;
        }

        @Override
        public LongArgumentType instantiate(CommandBuildContext var0) {
            return LongArgumentType.longArg((long)this.min, (long)this.max);
        }

        @Override
        public ArgumentTypeInfo<LongArgumentType, ?> type() {
            return LongArgumentInfo.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return this.instantiate(commandBuildContext);
        }
    }
}

