/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

@Immutable
public class BlockPos
extends Vec3i {
    public static final Codec<BlockPos> CODEC = Codec.INT_STREAM.comapFlatMap(var02 -> Util.fixedSize(var02, 3).map(var0 -> new BlockPos(var0[0], var0[1], var0[2])), var0 -> IntStream.of(var0.getX(), var0.getY(), var0.getZ())).stable();
    public static final StreamCodec<ByteBuf, BlockPos> STREAM_CODEC = new StreamCodec<ByteBuf, BlockPos>(){

        @Override
        public BlockPos decode(ByteBuf var0) {
            return FriendlyByteBuf.readBlockPos(var0);
        }

        @Override
        public void encode(ByteBuf var0, BlockPos var1) {
            FriendlyByteBuf.writeBlockPos(var0, var1);
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((ByteBuf)object, (BlockPos)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((ByteBuf)object);
        }
    };
    public static final BlockPos ZERO = new BlockPos(0, 0, 0);
    public static final int PACKED_HORIZONTAL_LENGTH = 1 + Mth.log2(Mth.smallestEncompassingPowerOfTwo(30000000));
    public static final int PACKED_Y_LENGTH = 64 - 2 * PACKED_HORIZONTAL_LENGTH;
    private static final long PACKED_X_MASK = (1L << PACKED_HORIZONTAL_LENGTH) - 1L;
    private static final long PACKED_Y_MASK = (1L << PACKED_Y_LENGTH) - 1L;
    private static final long PACKED_Z_MASK = (1L << PACKED_HORIZONTAL_LENGTH) - 1L;
    private static final int Y_OFFSET = 0;
    private static final int Z_OFFSET = PACKED_Y_LENGTH;
    private static final int X_OFFSET = PACKED_Y_LENGTH + PACKED_HORIZONTAL_LENGTH;
    public static final int MAX_HORIZONTAL_COORDINATE = (1 << PACKED_HORIZONTAL_LENGTH) / 2 - 1;

    public BlockPos(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    public BlockPos(Vec3i var0) {
        this(var0.getX(), var0.getY(), var0.getZ());
    }

    public static long offset(long var0, Direction var2) {
        return BlockPos.offset(var0, var2.getStepX(), var2.getStepY(), var2.getStepZ());
    }

    public static long offset(long var0, int var2, int var3, int var4) {
        return BlockPos.asLong(BlockPos.getX(var0) + var2, BlockPos.getY(var0) + var3, BlockPos.getZ(var0) + var4);
    }

    public static int getX(long var0) {
        return (int)(var0 << 64 - X_OFFSET - PACKED_HORIZONTAL_LENGTH >> 64 - PACKED_HORIZONTAL_LENGTH);
    }

    public static int getY(long var0) {
        return (int)(var0 << 64 - PACKED_Y_LENGTH >> 64 - PACKED_Y_LENGTH);
    }

    public static int getZ(long var0) {
        return (int)(var0 << 64 - Z_OFFSET - PACKED_HORIZONTAL_LENGTH >> 64 - PACKED_HORIZONTAL_LENGTH);
    }

    public static BlockPos of(long var0) {
        return new BlockPos(BlockPos.getX(var0), BlockPos.getY(var0), BlockPos.getZ(var0));
    }

    public static BlockPos containing(double var0, double var2, double var4) {
        return new BlockPos(Mth.floor(var0), Mth.floor(var2), Mth.floor(var4));
    }

    public static BlockPos containing(Position var0) {
        return BlockPos.containing(var0.x(), var0.y(), var0.z());
    }

    public static BlockPos min(BlockPos var0, BlockPos var1) {
        return new BlockPos(Math.min(var0.getX(), var1.getX()), Math.min(var0.getY(), var1.getY()), Math.min(var0.getZ(), var1.getZ()));
    }

    public static BlockPos max(BlockPos var0, BlockPos var1) {
        return new BlockPos(Math.max(var0.getX(), var1.getX()), Math.max(var0.getY(), var1.getY()), Math.max(var0.getZ(), var1.getZ()));
    }

    public long asLong() {
        return BlockPos.asLong(this.getX(), this.getY(), this.getZ());
    }

    public static long asLong(int var0, int var1, int var2) {
        long var3 = 0L;
        var3 |= ((long)var0 & PACKED_X_MASK) << X_OFFSET;
        var3 |= ((long)var1 & PACKED_Y_MASK) << 0;
        return var3 |= ((long)var2 & PACKED_Z_MASK) << Z_OFFSET;
    }

    public static long getFlatIndex(long var0) {
        return var0 & 0xFFFFFFFFFFFFFFF0L;
    }

    @Override
    public BlockPos offset(int var0, int var1, int var2) {
        if (var0 == 0 && var1 == 0 && var2 == 0) {
            return this;
        }
        return new BlockPos(this.getX() + var0, this.getY() + var1, this.getZ() + var2);
    }

    public Vec3 getCenter() {
        return Vec3.atCenterOf(this);
    }

    public Vec3 getBottomCenter() {
        return Vec3.atBottomCenterOf(this);
    }

    @Override
    public BlockPos offset(Vec3i var0) {
        return this.offset(var0.getX(), var0.getY(), var0.getZ());
    }

    @Override
    public BlockPos subtract(Vec3i var0) {
        return this.offset(-var0.getX(), -var0.getY(), -var0.getZ());
    }

    @Override
    public BlockPos multiply(int var0) {
        if (var0 == 1) {
            return this;
        }
        if (var0 == 0) {
            return ZERO;
        }
        return new BlockPos(this.getX() * var0, this.getY() * var0, this.getZ() * var0);
    }

    @Override
    public BlockPos above() {
        return this.relative(Direction.UP);
    }

    @Override
    public BlockPos above(int var0) {
        return this.relative(Direction.UP, var0);
    }

    @Override
    public BlockPos below() {
        return this.relative(Direction.DOWN);
    }

    @Override
    public BlockPos below(int var0) {
        return this.relative(Direction.DOWN, var0);
    }

    @Override
    public BlockPos north() {
        return this.relative(Direction.NORTH);
    }

    @Override
    public BlockPos north(int var0) {
        return this.relative(Direction.NORTH, var0);
    }

    @Override
    public BlockPos south() {
        return this.relative(Direction.SOUTH);
    }

    @Override
    public BlockPos south(int var0) {
        return this.relative(Direction.SOUTH, var0);
    }

    @Override
    public BlockPos west() {
        return this.relative(Direction.WEST);
    }

    @Override
    public BlockPos west(int var0) {
        return this.relative(Direction.WEST, var0);
    }

    @Override
    public BlockPos east() {
        return this.relative(Direction.EAST);
    }

    @Override
    public BlockPos east(int var0) {
        return this.relative(Direction.EAST, var0);
    }

    @Override
    public BlockPos relative(Direction var0) {
        return new BlockPos(this.getX() + var0.getStepX(), this.getY() + var0.getStepY(), this.getZ() + var0.getStepZ());
    }

    @Override
    public BlockPos relative(Direction var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        return new BlockPos(this.getX() + var0.getStepX() * var1, this.getY() + var0.getStepY() * var1, this.getZ() + var0.getStepZ() * var1);
    }

    @Override
    public BlockPos relative(Direction.Axis var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        int var2 = var0 == Direction.Axis.X ? var1 : 0;
        int var3 = var0 == Direction.Axis.Y ? var1 : 0;
        int var4 = var0 == Direction.Axis.Z ? var1 : 0;
        return new BlockPos(this.getX() + var2, this.getY() + var3, this.getZ() + var4);
    }

    public BlockPos rotate(Rotation var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case Rotation.CLOCKWISE_90 -> new BlockPos(-this.getZ(), this.getY(), this.getX());
            case Rotation.CLOCKWISE_180 -> new BlockPos(-this.getX(), this.getY(), -this.getZ());
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(this.getZ(), this.getY(), -this.getX());
            case Rotation.NONE -> this;
        };
    }

    @Override
    public BlockPos cross(Vec3i var0) {
        return new BlockPos(this.getY() * var0.getZ() - this.getZ() * var0.getY(), this.getZ() * var0.getX() - this.getX() * var0.getZ(), this.getX() * var0.getY() - this.getY() * var0.getX());
    }

    public BlockPos atY(int var0) {
        return new BlockPos(this.getX(), var0, this.getZ());
    }

    public BlockPos immutable() {
        return this;
    }

    public MutableBlockPos mutable() {
        return new MutableBlockPos(this.getX(), this.getY(), this.getZ());
    }

    public Vec3 clampLocationWithin(Vec3 var0) {
        return new Vec3(Mth.clamp(var0.x, (double)((float)this.getX() + 1.0E-5f), (double)this.getX() + 1.0 - (double)1.0E-5f), Mth.clamp(var0.y, (double)((float)this.getY() + 1.0E-5f), (double)this.getY() + 1.0 - (double)1.0E-5f), Mth.clamp(var0.z, (double)((float)this.getZ() + 1.0E-5f), (double)this.getZ() + 1.0 - (double)1.0E-5f));
    }

    public static Iterable<BlockPos> randomInCube(RandomSource var0, int var1, BlockPos var2, int var3) {
        return BlockPos.randomBetweenClosed(var0, var1, var2.getX() - var3, var2.getY() - var3, var2.getZ() - var3, var2.getX() + var3, var2.getY() + var3, var2.getZ() + var3);
    }

    @Deprecated
    public static Stream<BlockPos> squareOutSouthEast(BlockPos var0) {
        return Stream.of(var0, var0.south(), var0.east(), var0.south().east());
    }

    public static Iterable<BlockPos> randomBetweenClosed(final RandomSource var0, final int var1, final int var2, final int var3, final int var4, int var5, int var6, int var7) {
        final int var8 = var5 - var2 + 1;
        final int var9 = var6 - var3 + 1;
        final int var10 = var7 - var4 + 1;
        return () -> new AbstractIterator<BlockPos>(){
            final MutableBlockPos nextPos = new MutableBlockPos();
            int counter = var1;

            protected BlockPos computeNext() {
                if (this.counter <= 0) {
                    return (BlockPos)this.endOfData();
                }
                MutableBlockPos var02 = this.nextPos.set(var2 + var0.nextInt(var8), var3 + var0.nextInt(var9), var4 + var0.nextInt(var10));
                --this.counter;
                return var02;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<BlockPos> withinManhattan(BlockPos var0, final int var1, final int var2, final int var3) {
        final int var4 = var1 + var2 + var3;
        final int var5 = var0.getX();
        final int var6 = var0.getY();
        final int var7 = var0.getZ();
        return () -> new AbstractIterator<BlockPos>(){
            private final MutableBlockPos cursor = new MutableBlockPos();
            private int currentDepth;
            private int maxX;
            private int maxY;
            private int x;
            private int y;
            private boolean zMirror;

            protected BlockPos computeNext() {
                if (this.zMirror) {
                    this.zMirror = false;
                    this.cursor.setZ(var7 - (this.cursor.getZ() - var7));
                    return this.cursor;
                }
                MutableBlockPos var0 = null;
                while (var0 == null) {
                    if (this.y > this.maxY) {
                        ++this.x;
                        if (this.x > this.maxX) {
                            ++this.currentDepth;
                            if (this.currentDepth > var4) {
                                return (BlockPos)this.endOfData();
                            }
                            this.maxX = Math.min(var1, this.currentDepth);
                            this.x = -this.maxX;
                        }
                        this.maxY = Math.min(var2, this.currentDepth - Math.abs(this.x));
                        this.y = -this.maxY;
                    }
                    int var12 = this.x;
                    int var22 = this.y;
                    int var32 = this.currentDepth - Math.abs(var12) - Math.abs(var22);
                    if (var32 <= var3) {
                        this.zMirror = var32 != 0;
                        var0 = this.cursor.set(var5 + var12, var6 + var22, var7 + var32);
                    }
                    ++this.y;
                }
                return var0;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Optional<BlockPos> findClosestMatch(BlockPos var0, int var1, int var2, Predicate<BlockPos> var3) {
        for (BlockPos var5 : BlockPos.withinManhattan(var0, var1, var2, var1)) {
            if (!var3.test(var5)) continue;
            return Optional.of(var5);
        }
        return Optional.empty();
    }

    public static Stream<BlockPos> withinManhattanStream(BlockPos var0, int var1, int var2, int var3) {
        return StreamSupport.stream(BlockPos.withinManhattan(var0, var1, var2, var3).spliterator(), false);
    }

    public static Iterable<BlockPos> betweenClosed(AABB var0) {
        BlockPos var1 = BlockPos.containing(var0.minX, var0.minY, var0.minZ);
        BlockPos var2 = BlockPos.containing(var0.maxX, var0.maxY, var0.maxZ);
        return BlockPos.betweenClosed(var1, var2);
    }

    public static Iterable<BlockPos> betweenClosed(BlockPos var0, BlockPos var1) {
        return BlockPos.betweenClosed(Math.min(var0.getX(), var1.getX()), Math.min(var0.getY(), var1.getY()), Math.min(var0.getZ(), var1.getZ()), Math.max(var0.getX(), var1.getX()), Math.max(var0.getY(), var1.getY()), Math.max(var0.getZ(), var1.getZ()));
    }

    public static Stream<BlockPos> betweenClosedStream(BlockPos var0, BlockPos var1) {
        return StreamSupport.stream(BlockPos.betweenClosed(var0, var1).spliterator(), false);
    }

    public static Stream<BlockPos> betweenClosedStream(BoundingBox var0) {
        return BlockPos.betweenClosedStream(Math.min(var0.minX(), var0.maxX()), Math.min(var0.minY(), var0.maxY()), Math.min(var0.minZ(), var0.maxZ()), Math.max(var0.minX(), var0.maxX()), Math.max(var0.minY(), var0.maxY()), Math.max(var0.minZ(), var0.maxZ()));
    }

    public static Stream<BlockPos> betweenClosedStream(AABB var0) {
        return BlockPos.betweenClosedStream(Mth.floor(var0.minX), Mth.floor(var0.minY), Mth.floor(var0.minZ), Mth.floor(var0.maxX), Mth.floor(var0.maxY), Mth.floor(var0.maxZ));
    }

    public static Stream<BlockPos> betweenClosedStream(int var0, int var1, int var2, int var3, int var4, int var5) {
        return StreamSupport.stream(BlockPos.betweenClosed(var0, var1, var2, var3, var4, var5).spliterator(), false);
    }

    public static Iterable<BlockPos> betweenClosed(final int var0, final int var1, final int var2, int var3, int var4, int var5) {
        final int var6 = var3 - var0 + 1;
        final int var7 = var4 - var1 + 1;
        int var8 = var5 - var2 + 1;
        final int var9 = var6 * var7 * var8;
        return () -> new AbstractIterator<BlockPos>(){
            private final MutableBlockPos cursor = new MutableBlockPos();
            private int index;

            protected BlockPos computeNext() {
                if (this.index == var9) {
                    return (BlockPos)this.endOfData();
                }
                int var02 = this.index % var6;
                int var12 = this.index / var6;
                int var22 = var12 % var7;
                int var3 = var12 / var7;
                ++this.index;
                return this.cursor.set(var0 + var02, var1 + var22, var2 + var3);
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<MutableBlockPos> spiralAround(final BlockPos var0, final int var1, final Direction var2, final Direction var3) {
        Validate.validState((var2.getAxis() != var3.getAxis() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<MutableBlockPos>(){
            private final Direction[] directions;
            private final MutableBlockPos cursor;
            private final int legs;
            private int leg;
            private int legSize;
            private int legIndex;
            private int lastX;
            private int lastY;
            private int lastZ;
            {
                this.directions = new Direction[]{var2, var3, var2.getOpposite(), var3.getOpposite()};
                this.cursor = var0.mutable().move(var3);
                this.legs = 4 * var1;
                this.leg = -1;
                this.lastX = this.cursor.getX();
                this.lastY = this.cursor.getY();
                this.lastZ = this.cursor.getZ();
            }

            protected MutableBlockPos computeNext() {
                this.cursor.set(this.lastX, this.lastY, this.lastZ).move(this.directions[(this.leg + 4) % 4]);
                this.lastX = this.cursor.getX();
                this.lastY = this.cursor.getY();
                this.lastZ = this.cursor.getZ();
                if (this.legIndex >= this.legSize) {
                    if (this.leg >= this.legs) {
                        return (MutableBlockPos)this.endOfData();
                    }
                    ++this.leg;
                    this.legIndex = 0;
                    this.legSize = this.leg / 2 + 1;
                }
                ++this.legIndex;
                return this.cursor;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static int breadthFirstTraversal(BlockPos var0, int var1, int var22, BiConsumer<BlockPos, Consumer<BlockPos>> var3, Function<BlockPos, TraversalNodeStatus> var4) {
        ArrayDeque<Pair> var5 = new ArrayDeque<Pair>();
        LongOpenHashSet var6 = new LongOpenHashSet();
        var5.add(Pair.of((Object)var0, (Object)0));
        int var7 = 0;
        while (!var5.isEmpty()) {
            TraversalNodeStatus var13;
            Pair var8 = (Pair)var5.poll();
            BlockPos var9 = (BlockPos)var8.getLeft();
            int var10 = (Integer)var8.getRight();
            long var11 = var9.asLong();
            if (!var6.add(var11) || (var13 = var4.apply(var9)) == TraversalNodeStatus.SKIP) continue;
            if (var13 == TraversalNodeStatus.STOP) break;
            if (++var7 >= var22) {
                return var7;
            }
            if (var10 >= var1) continue;
            var3.accept(var9, var2 -> var5.add(Pair.of((Object)var2, (Object)(var10 + 1))));
        }
        return var7;
    }

    public static Iterable<BlockPos> betweenCornersInDirection(AABB var0, Vec3 var1) {
        Vec3 var2 = var0.getMinPosition();
        int var3 = Mth.floor(var2.x());
        int var4 = Mth.floor(var2.y());
        int var5 = Mth.floor(var2.z());
        Vec3 var6 = var0.getMaxPosition();
        int var7 = Mth.floor(var6.x());
        int var8 = Mth.floor(var6.y());
        int var9 = Mth.floor(var6.z());
        return BlockPos.betweenCornersInDirection(var3, var4, var5, var7, var8, var9, var1);
    }

    public static Iterable<BlockPos> betweenCornersInDirection(BlockPos var0, BlockPos var1, Vec3 var2) {
        return BlockPos.betweenCornersInDirection(var0.getX(), var0.getY(), var0.getZ(), var1.getX(), var1.getY(), var1.getZ(), var2);
    }

    public static Iterable<BlockPos> betweenCornersInDirection(int var0, int var1, int var2, int var3, int var4, int var5, Vec3 var6) {
        int var7 = Math.min(var0, var3);
        int var8 = Math.min(var1, var4);
        int var9 = Math.min(var2, var5);
        int var10 = Math.max(var0, var3);
        int var11 = Math.max(var1, var4);
        int var12 = Math.max(var2, var5);
        int var13 = var10 - var7;
        int var14 = var11 - var8;
        int var15 = var12 - var9;
        final int var16 = var6.x >= 0.0 ? var7 : var10;
        final int var17 = var6.y >= 0.0 ? var8 : var11;
        final int var18 = var6.z >= 0.0 ? var9 : var12;
        ImmutableList<Direction.Axis> var19 = Direction.axisStepOrder(var6);
        Direction.Axis var20 = (Direction.Axis)var19.get(0);
        Direction.Axis var21 = (Direction.Axis)var19.get(1);
        Direction.Axis var22 = (Direction.Axis)var19.get(2);
        final Direction var23 = var6.get(var20) >= 0.0 ? var20.getPositive() : var20.getNegative();
        final Direction var24 = var6.get(var21) >= 0.0 ? var21.getPositive() : var21.getNegative();
        final Direction var25 = var6.get(var22) >= 0.0 ? var22.getPositive() : var22.getNegative();
        final int var26 = var20.choose(var13, var14, var15);
        final int var27 = var21.choose(var13, var14, var15);
        final int var28 = var22.choose(var13, var14, var15);
        return () -> new AbstractIterator<BlockPos>(){
            private final MutableBlockPos cursor = new MutableBlockPos();
            private int firstIndex;
            private int secondIndex;
            private int thirdIndex;
            private boolean end;
            private final int firstDirX = var23.getStepX();
            private final int firstDirY = var23.getStepY();
            private final int firstDirZ = var23.getStepZ();
            private final int secondDirX = var24.getStepX();
            private final int secondDirY = var24.getStepY();
            private final int secondDirZ = var24.getStepZ();
            private final int thirdDirX = var25.getStepX();
            private final int thirdDirY = var25.getStepY();
            private final int thirdDirZ = var25.getStepZ();

            protected BlockPos computeNext() {
                if (this.end) {
                    return (BlockPos)this.endOfData();
                }
                this.cursor.set(var16 + this.firstDirX * this.firstIndex + this.secondDirX * this.secondIndex + this.thirdDirX * this.thirdIndex, var17 + this.firstDirY * this.firstIndex + this.secondDirY * this.secondIndex + this.thirdDirY * this.thirdIndex, var18 + this.firstDirZ * this.firstIndex + this.secondDirZ * this.secondIndex + this.thirdDirZ * this.thirdIndex);
                if (this.thirdIndex < var28) {
                    ++this.thirdIndex;
                } else if (this.secondIndex < var27) {
                    ++this.secondIndex;
                    this.thirdIndex = 0;
                } else if (this.firstIndex < var26) {
                    ++this.firstIndex;
                    this.thirdIndex = 0;
                    this.secondIndex = 0;
                } else {
                    this.end = true;
                }
                return this.cursor;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    @Override
    public /* synthetic */ Vec3i cross(Vec3i vec3i) {
        return this.cross(vec3i);
    }

    @Override
    public /* synthetic */ Vec3i relative(Direction.Axis axis, int n) {
        return this.relative(axis, n);
    }

    @Override
    public /* synthetic */ Vec3i relative(Direction direction, int n) {
        return this.relative(direction, n);
    }

    @Override
    public /* synthetic */ Vec3i relative(Direction direction) {
        return this.relative(direction);
    }

    @Override
    public /* synthetic */ Vec3i east(int n) {
        return this.east(n);
    }

    @Override
    public /* synthetic */ Vec3i east() {
        return this.east();
    }

    @Override
    public /* synthetic */ Vec3i west(int n) {
        return this.west(n);
    }

    @Override
    public /* synthetic */ Vec3i west() {
        return this.west();
    }

    @Override
    public /* synthetic */ Vec3i south(int n) {
        return this.south(n);
    }

    @Override
    public /* synthetic */ Vec3i south() {
        return this.south();
    }

    @Override
    public /* synthetic */ Vec3i north(int n) {
        return this.north(n);
    }

    @Override
    public /* synthetic */ Vec3i north() {
        return this.north();
    }

    @Override
    public /* synthetic */ Vec3i below(int n) {
        return this.below(n);
    }

    @Override
    public /* synthetic */ Vec3i below() {
        return this.below();
    }

    @Override
    public /* synthetic */ Vec3i above(int n) {
        return this.above(n);
    }

    @Override
    public /* synthetic */ Vec3i above() {
        return this.above();
    }

    @Override
    public /* synthetic */ Vec3i multiply(int n) {
        return this.multiply(n);
    }

    @Override
    public /* synthetic */ Vec3i subtract(Vec3i vec3i) {
        return this.subtract(vec3i);
    }

    @Override
    public /* synthetic */ Vec3i offset(Vec3i vec3i) {
        return this.offset(vec3i);
    }

    @Override
    public /* synthetic */ Vec3i offset(int n, int n2, int n3) {
        return this.offset(n, n2, n3);
    }

    public static class MutableBlockPos
    extends BlockPos {
        public MutableBlockPos() {
            this(0, 0, 0);
        }

        public MutableBlockPos(int var0, int var1, int var2) {
            super(var0, var1, var2);
        }

        public MutableBlockPos(double var0, double var2, double var4) {
            this(Mth.floor(var0), Mth.floor(var2), Mth.floor(var4));
        }

        @Override
        public BlockPos offset(int var0, int var1, int var2) {
            return super.offset(var0, var1, var2).immutable();
        }

        @Override
        public BlockPos multiply(int var0) {
            return super.multiply(var0).immutable();
        }

        @Override
        public BlockPos relative(Direction var0, int var1) {
            return super.relative(var0, var1).immutable();
        }

        @Override
        public BlockPos relative(Direction.Axis var0, int var1) {
            return super.relative(var0, var1).immutable();
        }

        @Override
        public BlockPos rotate(Rotation var0) {
            return super.rotate(var0).immutable();
        }

        public MutableBlockPos set(int var0, int var1, int var2) {
            this.setX(var0);
            this.setY(var1);
            this.setZ(var2);
            return this;
        }

        public MutableBlockPos set(double var0, double var2, double var4) {
            return this.set(Mth.floor(var0), Mth.floor(var2), Mth.floor(var4));
        }

        public MutableBlockPos set(Vec3i var0) {
            return this.set(var0.getX(), var0.getY(), var0.getZ());
        }

        public MutableBlockPos set(long var0) {
            return this.set(MutableBlockPos.getX(var0), MutableBlockPos.getY(var0), MutableBlockPos.getZ(var0));
        }

        public MutableBlockPos set(AxisCycle var0, int var1, int var2, int var3) {
            return this.set(var0.cycle(var1, var2, var3, Direction.Axis.X), var0.cycle(var1, var2, var3, Direction.Axis.Y), var0.cycle(var1, var2, var3, Direction.Axis.Z));
        }

        public MutableBlockPos setWithOffset(Vec3i var0, Direction var1) {
            return this.set(var0.getX() + var1.getStepX(), var0.getY() + var1.getStepY(), var0.getZ() + var1.getStepZ());
        }

        public MutableBlockPos setWithOffset(Vec3i var0, int var1, int var2, int var3) {
            return this.set(var0.getX() + var1, var0.getY() + var2, var0.getZ() + var3);
        }

        public MutableBlockPos setWithOffset(Vec3i var0, Vec3i var1) {
            return this.set(var0.getX() + var1.getX(), var0.getY() + var1.getY(), var0.getZ() + var1.getZ());
        }

        public MutableBlockPos move(Direction var0) {
            return this.move(var0, 1);
        }

        public MutableBlockPos move(Direction var0, int var1) {
            return this.set(this.getX() + var0.getStepX() * var1, this.getY() + var0.getStepY() * var1, this.getZ() + var0.getStepZ() * var1);
        }

        public MutableBlockPos move(int var0, int var1, int var2) {
            return this.set(this.getX() + var0, this.getY() + var1, this.getZ() + var2);
        }

        public MutableBlockPos move(Vec3i var0) {
            return this.set(this.getX() + var0.getX(), this.getY() + var0.getY(), this.getZ() + var0.getZ());
        }

        public MutableBlockPos clamp(Direction.Axis var0, int var1, int var2) {
            return switch (var0) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> this.set(Mth.clamp(this.getX(), var1, var2), this.getY(), this.getZ());
                case Direction.Axis.Y -> this.set(this.getX(), Mth.clamp(this.getY(), var1, var2), this.getZ());
                case Direction.Axis.Z -> this.set(this.getX(), this.getY(), Mth.clamp(this.getZ(), var1, var2));
            };
        }

        @Override
        public MutableBlockPos setX(int var0) {
            super.setX(var0);
            return this;
        }

        @Override
        public MutableBlockPos setY(int var0) {
            super.setY(var0);
            return this;
        }

        @Override
        public MutableBlockPos setZ(int var0) {
            super.setZ(var0);
            return this;
        }

        @Override
        public BlockPos immutable() {
            return new BlockPos(this);
        }

        @Override
        public /* synthetic */ Vec3i cross(Vec3i vec3i) {
            return super.cross(vec3i);
        }

        @Override
        public /* synthetic */ Vec3i relative(Direction.Axis axis, int n) {
            return this.relative(axis, n);
        }

        @Override
        public /* synthetic */ Vec3i relative(Direction direction, int n) {
            return this.relative(direction, n);
        }

        @Override
        public /* synthetic */ Vec3i relative(Direction direction) {
            return super.relative(direction);
        }

        @Override
        public /* synthetic */ Vec3i east(int n) {
            return super.east(n);
        }

        @Override
        public /* synthetic */ Vec3i east() {
            return super.east();
        }

        @Override
        public /* synthetic */ Vec3i west(int n) {
            return super.west(n);
        }

        @Override
        public /* synthetic */ Vec3i west() {
            return super.west();
        }

        @Override
        public /* synthetic */ Vec3i south(int n) {
            return super.south(n);
        }

        @Override
        public /* synthetic */ Vec3i south() {
            return super.south();
        }

        @Override
        public /* synthetic */ Vec3i north(int n) {
            return super.north(n);
        }

        @Override
        public /* synthetic */ Vec3i north() {
            return super.north();
        }

        @Override
        public /* synthetic */ Vec3i below(int n) {
            return super.below(n);
        }

        @Override
        public /* synthetic */ Vec3i below() {
            return super.below();
        }

        @Override
        public /* synthetic */ Vec3i above(int n) {
            return super.above(n);
        }

        @Override
        public /* synthetic */ Vec3i above() {
            return super.above();
        }

        @Override
        public /* synthetic */ Vec3i multiply(int n) {
            return this.multiply(n);
        }

        @Override
        public /* synthetic */ Vec3i subtract(Vec3i vec3i) {
            return super.subtract(vec3i);
        }

        @Override
        public /* synthetic */ Vec3i offset(Vec3i vec3i) {
            return super.offset(vec3i);
        }

        @Override
        public /* synthetic */ Vec3i offset(int n, int n2, int n3) {
            return this.offset(n, n2, n3);
        }

        @Override
        public /* synthetic */ Vec3i setZ(int n) {
            return this.setZ(n);
        }

        @Override
        public /* synthetic */ Vec3i setY(int n) {
            return this.setY(n);
        }

        @Override
        public /* synthetic */ Vec3i setX(int n) {
            return this.setX(n);
        }
    }

    public static enum TraversalNodeStatus {
        ACCEPT,
        SKIP,
        STOP;

    }
}

