/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import org.jspecify.annotations.Nullable;

public class DefaultedMappedRegistry<T>
extends MappedRegistry<T>
implements DefaultedRegistry<T> {
    private final Identifier defaultKey;
    private Holder.Reference<T> defaultValue;

    public DefaultedMappedRegistry(String var0, ResourceKey<? extends Registry<T>> var1, Lifecycle var2, boolean var3) {
        super(var1, var2, var3);
        this.defaultKey = Identifier.parse(var0);
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> var0, T var1, RegistrationInfo var2) {
        Holder.Reference<T> var3 = super.register(var0, var1, var2);
        if (this.defaultKey.equals(var0.identifier())) {
            this.defaultValue = var3;
        }
        return var3;
    }

    @Override
    public int getId(@Nullable T var0) {
        int var1 = super.getId(var0);
        return var1 == -1 ? super.getId(this.defaultValue.value()) : var1;
    }

    @Override
    public Identifier getKey(T var0) {
        Identifier var1 = super.getKey(var0);
        return var1 == null ? this.defaultKey : var1;
    }

    @Override
    public T getValue(@Nullable Identifier var0) {
        Object var1 = super.getValue(var0);
        return var1 == null ? this.defaultValue.value() : var1;
    }

    @Override
    public Optional<T> getOptional(@Nullable Identifier var0) {
        return Optional.ofNullable(super.getValue(var0));
    }

    @Override
    public Optional<Holder.Reference<T>> getAny() {
        return Optional.ofNullable(this.defaultValue);
    }

    @Override
    public T byId(int var0) {
        Object var1 = super.byId(var0);
        return var1 == null ? this.defaultValue.value() : var1;
    }

    @Override
    public Optional<Holder.Reference<T>> getRandom(RandomSource var0) {
        return super.getRandom(var0).or(() -> Optional.of(this.defaultValue));
    }

    @Override
    public Identifier getDefaultKey() {
        return this.defaultKey;
    }
}

