/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Util;

public class LayeredRegistryAccess<T> {
    private final List<T> keys;
    private final List<RegistryAccess.Frozen> values;
    private final RegistryAccess.Frozen composite;

    public LayeredRegistryAccess(List<T> var0) {
        this(var0, Util.make(() -> {
            Object[] var1 = new RegistryAccess.Frozen[var0.size()];
            Arrays.fill(var1, RegistryAccess.EMPTY);
            return Arrays.asList(var1);
        }));
    }

    private LayeredRegistryAccess(List<T> var0, List<RegistryAccess.Frozen> var1) {
        this.keys = List.copyOf(var0);
        this.values = List.copyOf(var1);
        this.composite = new RegistryAccess.ImmutableRegistryAccess(LayeredRegistryAccess.collectRegistries(var1.stream())).freeze();
    }

    private int getLayerIndexOrThrow(T var0) {
        int var1 = this.keys.indexOf(var0);
        if (var1 == -1) {
            throw new IllegalStateException("Can't find " + String.valueOf(var0) + " inside " + String.valueOf(this.keys));
        }
        return var1;
    }

    public RegistryAccess.Frozen getLayer(T var0) {
        int var1 = this.getLayerIndexOrThrow(var0);
        return this.values.get(var1);
    }

    public RegistryAccess.Frozen getAccessForLoading(T var0) {
        int var1 = this.getLayerIndexOrThrow(var0);
        return this.getCompositeAccessForLayers(0, var1);
    }

    public RegistryAccess.Frozen getAccessFrom(T var0) {
        int var1 = this.getLayerIndexOrThrow(var0);
        return this.getCompositeAccessForLayers(var1, this.values.size());
    }

    private RegistryAccess.Frozen getCompositeAccessForLayers(int var0, int var1) {
        return new RegistryAccess.ImmutableRegistryAccess(LayeredRegistryAccess.collectRegistries(this.values.subList(var0, var1).stream())).freeze();
    }

    public LayeredRegistryAccess<T> replaceFrom(T var0, RegistryAccess.Frozen ... var1) {
        return this.replaceFrom(var0, Arrays.asList(var1));
    }

    public LayeredRegistryAccess<T> replaceFrom(T var0, List<RegistryAccess.Frozen> var1) {
        int var2 = this.getLayerIndexOrThrow(var0);
        if (var1.size() > this.values.size() - var2) {
            throw new IllegalStateException("Too many values to replace");
        }
        ArrayList<RegistryAccess.Frozen> var3 = new ArrayList<RegistryAccess.Frozen>();
        for (int var4 = 0; var4 < var2; ++var4) {
            var3.add(this.values.get(var4));
        }
        var3.addAll(var1);
        while (var3.size() < this.values.size()) {
            var3.add(RegistryAccess.EMPTY);
        }
        return new LayeredRegistryAccess<T>(this.keys, var3);
    }

    public RegistryAccess.Frozen compositeAccess() {
        return this.composite;
    }

    private static Map<ResourceKey<? extends Registry<?>>, Registry<?>> collectRegistries(Stream<? extends RegistryAccess> var0) {
        HashMap var1 = new HashMap();
        var0.forEach(var12 -> var12.registries().forEach(var1 -> {
            if (var1.put(var1.key(), var1.value()) != null) {
                throw new IllegalStateException("Duplicated registry " + String.valueOf(var1.key()));
            }
        }));
        return var1;
    }
}

