/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;

public class MappedRegistry<T>
implements WritableRegistry<T> {
    private final ResourceKey<? extends Registry<T>> key;
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Reference2IntMap<T> toId = (Reference2IntMap)Util.make(new Reference2IntOpenHashMap(), var0 -> var0.defaultReturnValue(-1));
    private final Map<Identifier, Holder.Reference<T>> byLocation = new HashMap<Identifier, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle registryLifecycle;
    private final Map<TagKey<T>, HolderSet.Named<T>> frozenTags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    TagSet<T> allTags = TagSet.unbound();
    private boolean frozen;
    private @Nullable Map<T, Holder.Reference<T>> unregisteredIntrusiveHolders;

    @Override
    public Stream<HolderSet.Named<T>> listTags() {
        return this.getTags();
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> var0, Lifecycle var1) {
        this(var0, var1, false);
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> var02, Lifecycle var1, boolean var2) {
        this.key = var02;
        this.registryLifecycle = var1;
        if (var2) {
            this.unregisteredIntrusiveHolders = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.key) + " (" + String.valueOf(this.registryLifecycle) + ")]";
    }

    private void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void validateWrite(ResourceKey<T> var0) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(var0) + ")");
        }
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> var02, T var1, RegistrationInfo var2) {
        Holder.Reference var3;
        this.validateWrite(var02);
        Objects.requireNonNull(var02);
        Objects.requireNonNull(var1);
        if (this.byLocation.containsKey(var02.identifier())) {
            throw Util.pauseInIde(new IllegalStateException("Adding duplicate key '" + String.valueOf(var02) + "' to registry"));
        }
        if (this.byValue.containsKey(var1)) {
            throw Util.pauseInIde(new IllegalStateException("Adding duplicate value '" + String.valueOf(var1) + "' to registry"));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            var3 = this.unregisteredIntrusiveHolders.remove(var1);
            if (var3 == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(var02) + ":" + String.valueOf(var1)));
            }
            var3.bindKey(var02);
        } else {
            var3 = this.byKey.computeIfAbsent(var02, var0 -> Holder.Reference.createStandAlone(this, var0));
        }
        this.byKey.put(var02, var3);
        this.byLocation.put(var02.identifier(), var3);
        this.byValue.put(var1, var3);
        int var4 = this.byId.size();
        this.byId.add((Object)var3);
        this.toId.put(var1, var4);
        this.registrationInfos.put(var02, var2);
        this.registryLifecycle = this.registryLifecycle.add(var2.lifecycle());
        return var3;
    }

    @Override
    public @Nullable Identifier getKey(T var0) {
        Holder.Reference<T> var1 = this.byValue.get(var0);
        return var1 != null ? var1.key().identifier() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T var0) {
        return Optional.ofNullable(this.byValue.get(var0)).map(Holder.Reference::key);
    }

    @Override
    public int getId(@Nullable T var0) {
        return this.toId.getInt(var0);
    }

    @Override
    public @Nullable T getValue(@Nullable ResourceKey<T> var0) {
        return MappedRegistry.getValueFromNullable(this.byKey.get(var0));
    }

    @Override
    public @Nullable T byId(int var0) {
        if (var0 < 0 || var0 >= this.byId.size()) {
            return null;
        }
        return ((Holder.Reference)this.byId.get(var0)).value();
    }

    @Override
    public Optional<Holder.Reference<T>> get(int var0) {
        if (var0 < 0 || var0 >= this.byId.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder.Reference)this.byId.get(var0));
    }

    @Override
    public Optional<Holder.Reference<T>> get(Identifier var0) {
        return Optional.ofNullable(this.byLocation.get(var0));
    }

    @Override
    public Optional<Holder.Reference<T>> get(ResourceKey<T> var0) {
        return Optional.ofNullable(this.byKey.get(var0));
    }

    @Override
    public Optional<Holder.Reference<T>> getAny() {
        return this.byId.isEmpty() ? Optional.empty() : Optional.of((Holder.Reference)this.byId.getFirst());
    }

    @Override
    public Holder<T> wrapAsHolder(T var0) {
        Holder.Reference<T> var1 = this.byValue.get(var0);
        return var1 != null ? var1 : Holder.direct(var0);
    }

    Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> var02) {
        return this.byKey.computeIfAbsent(var02, var0 -> {
            if (this.unregisteredIntrusiveHolders != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)var0);
            return Holder.Reference.createStandAlone(this, var0);
        });
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> var0) {
        return Optional.ofNullable(this.registrationInfos.get(var0));
    }

    @Override
    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.byId.iterator(), Holder::value);
    }

    @Override
    public @Nullable T getValue(@Nullable Identifier var0) {
        Holder.Reference<T> var1 = this.byLocation.get(var0);
        return MappedRegistry.getValueFromNullable(var1);
    }

    private static <T> @Nullable T getValueFromNullable(@Nullable Holder.Reference<T> var0) {
        return var0 != null ? (T)var0.value() : null;
    }

    @Override
    public Set<Identifier> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Util.mapValuesLazy(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.Reference<T>> listElements() {
        return this.byId.stream();
    }

    @Override
    public Stream<HolderSet.Named<T>> getTags() {
        return this.allTags.getTags();
    }

    HolderSet.Named<T> getOrCreateTagForRegistration(TagKey<T> var0) {
        return this.frozenTags.computeIfAbsent(var0, this::createTag);
    }

    private HolderSet.Named<T> createTag(TagKey<T> var0) {
        return new HolderSet.Named<T>(this, var0);
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder.Reference<T>> getRandom(RandomSource var0) {
        return Util.getRandomSafe(this.byId, var0);
    }

    @Override
    public boolean containsKey(Identifier var0) {
        return this.byLocation.containsKey(var0);
    }

    @Override
    public boolean containsKey(ResourceKey<T> var0) {
        return this.byKey.containsKey(var0);
    }

    @Override
    public Registry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        this.byValue.forEach((? super K var0, ? super V var1) -> var1.bindValue(var0));
        List<Identifier> var02 = this.byKey.entrySet().stream().filter(var0 -> !((Holder.Reference)var0.getValue()).isBound()).map(var0 -> ((ResourceKey)var0.getKey()).identifier()).sorted().toList();
        if (!var02.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + String.valueOf(var02));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            if (!this.unregisteredIntrusiveHolders.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()));
            }
            this.unregisteredIntrusiveHolders = null;
        }
        if (this.allTags.isBound()) {
            throw new IllegalStateException("Tags already present before freezing");
        }
        List<Identifier> var12 = this.frozenTags.entrySet().stream().filter(var0 -> !((HolderSet.Named)var0.getValue()).isBound()).map(var0 -> ((TagKey)var0.getKey()).location()).sorted().toList();
        if (!var12.isEmpty()) {
            throw new IllegalStateException("Unbound tags in registry " + String.valueOf(this.key()) + ": " + String.valueOf(var12));
        }
        this.allTags = TagSet.fromMap(this.frozenTags);
        this.refreshTagsInHolders();
        return this;
    }

    @Override
    public Holder.Reference<T> createIntrusiveHolder(T var02) {
        if (this.unregisteredIntrusiveHolders == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return this.unregisteredIntrusiveHolders.computeIfAbsent(var02, var0 -> Holder.Reference.createIntrusive(this, var0));
    }

    @Override
    public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
        return this.allTags.get(var0);
    }

    private Holder.Reference<T> validateAndUnwrapTagElement(TagKey<T> var0, Holder<T> var1) {
        if (!var1.canSerializeIn(this)) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(var0) + " containing value " + String.valueOf(var1) + " from outside registry " + String.valueOf(this));
        }
        if (var1 instanceof Holder.Reference) {
            Holder.Reference var2 = (Holder.Reference)var1;
            return var2;
        }
        throw new IllegalStateException("Found direct holder " + String.valueOf(var1) + " value in tag " + String.valueOf(var0));
    }

    @Override
    public void bindTag(TagKey<T> var0, List<Holder<T>> var1) {
        this.validateWrite();
        this.getOrCreateTagForRegistration(var0).bind(var1);
    }

    void refreshTagsInHolders() {
        IdentityHashMap<Holder.Reference, List> var0 = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach(var1 -> var0.put((Holder.Reference)var1, new ArrayList()));
        this.allTags.forEach((? super TagKey<T> var1, ? super HolderSet.Named<T> var2) -> {
            for (Holder var4 : var2) {
                Holder.Reference var5 = this.validateAndUnwrapTagElement((TagKey<T>)var1, var4);
                ((List)var0.get(var5)).add(var1);
            }
        });
        var0.forEach(Holder.Reference::bindTags);
    }

    public void bindAllTagsToEmpty() {
        this.validateWrite();
        this.frozenTags.values().forEach(var0 -> var0.bind(List.of()));
    }

    @Override
    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> var0) {
                return Optional.of(this.getOrThrow(var0));
            }

            @Override
            public Holder.Reference<T> getOrThrow(ResourceKey<T> var0) {
                return MappedRegistry.this.getOrCreateHolderOrThrow(var0);
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                return Optional.of(this.getOrThrow(var0));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> var0) {
                return MappedRegistry.this.getOrCreateTagForRegistration(var0);
            }
        };
    }

    @Override
    public Registry.PendingTags<T> prepareTagReload(TagLoader.LoadResult<T> var0) {
        if (!this.frozen) {
            throw new IllegalStateException("Invalid method used for tag loading");
        }
        ImmutableMap.Builder var1 = ImmutableMap.builder();
        final HashMap var22 = new HashMap();
        var0.tags().forEach((? super K var2, ? super V var3) -> {
            HolderSet.Named<T> var4 = this.frozenTags.get(var2);
            if (var4 == null) {
                var4 = this.createTag((TagKey<T>)var2);
            }
            var1.put(var2, var4);
            var22.put(var2, List.copyOf(var3));
        });
        final ImmutableMap var32 = var1.build();
        final HolderLookup.RegistryLookup.Delegate var4 = new HolderLookup.RegistryLookup.Delegate<T>(){

            @Override
            public HolderLookup.RegistryLookup<T> parent() {
                return MappedRegistry.this;
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                return Optional.ofNullable((HolderSet.Named)var32.get(var0));
            }

            @Override
            public Stream<HolderSet.Named<T>> listTags() {
                return var32.values().stream();
            }
        };
        return new Registry.PendingTags<T>(){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return MappedRegistry.this.key();
            }

            @Override
            public int size() {
                return var22.size();
            }

            @Override
            public HolderLookup.RegistryLookup<T> lookup() {
                return var4;
            }

            @Override
            public void apply() {
                var32.forEach((var1, var2) -> {
                    List var3 = var22.getOrDefault(var1, List.of());
                    var2.bind(var3);
                });
                MappedRegistry.this.allTags = TagSet.fromMap(var32);
                MappedRegistry.this.refreshTagsInHolders();
            }
        };
    }

    static interface TagSet<T> {
        public static <T> TagSet<T> unbound() {
            return new TagSet<T>(){

                @Override
                public boolean isBound() {
                    return false;
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                    throw new IllegalStateException("Tags not bound, trying to access " + String.valueOf(var0));
                }

                @Override
                public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var0) {
                    throw new IllegalStateException("Tags not bound");
                }

                @Override
                public Stream<HolderSet.Named<T>> getTags() {
                    throw new IllegalStateException("Tags not bound");
                }
            };
        }

        public static <T> TagSet<T> fromMap(final Map<TagKey<T>, HolderSet.Named<T>> var0) {
            return new TagSet<T>(){

                @Override
                public boolean isBound() {
                    return true;
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> var02) {
                    return Optional.ofNullable((HolderSet.Named)var0.get(var02));
                }

                @Override
                public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var02) {
                    var0.forEach(var02);
                }

                @Override
                public Stream<HolderSet.Named<T>> getTags() {
                    return var0.values().stream();
                }
            };
        }

        public boolean isBound();

        public Optional<HolderSet.Named<T>> get(TagKey<T> var1);

        public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var1);

        public Stream<HolderSet.Named<T>> getTags();
    }
}

