/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IdMap;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import org.jspecify.annotations.Nullable;

public interface Registry<T>
extends Keyable,
HolderLookup.RegistryLookup<T>,
IdMap<T> {
    @Override
    public ResourceKey<? extends Registry<T>> key();

    default public Codec<T> byNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(Holder.Reference::value, var0 -> this.safeCastToReference(this.wrapAsHolder(var0)));
    }

    default public Codec<Holder<T>> holderByNameCodec() {
        return this.referenceHolderWithLifecycle().flatComapMap(var0 -> var0, this::safeCastToReference);
    }

    private Codec<Holder.Reference<T>> referenceHolderWithLifecycle() {
        Codec var02 = Identifier.CODEC.comapFlatMap(var0 -> this.get((Identifier)var0).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + String.valueOf(this.key()) + ": " + String.valueOf(var0))), var0 -> var0.key().identifier());
        return ExtraCodecs.overrideLifecycle(var02, var0 -> this.registrationInfo(var0.key()).map(RegistrationInfo::lifecycle).orElse(Lifecycle.experimental()));
    }

    private DataResult<Holder.Reference<T>> safeCastToReference(Holder<T> var0) {
        DataResult dataResult;
        if (var0 instanceof Holder.Reference) {
            Holder.Reference var1 = (Holder.Reference)var0;
            dataResult = DataResult.success((Object)var1);
        } else {
            dataResult = DataResult.error(() -> "Unregistered holder in " + String.valueOf(this.key()) + ": " + String.valueOf(var0));
        }
        return dataResult;
    }

    default public <U> Stream<U> keys(DynamicOps<U> var0) {
        return this.keySet().stream().map(var1 -> var0.createString(var1.toString()));
    }

    public @Nullable Identifier getKey(T var1);

    public Optional<ResourceKey<T>> getResourceKey(T var1);

    @Override
    public int getId(@Nullable T var1);

    public @Nullable T getValue(@Nullable ResourceKey<T> var1);

    public @Nullable T getValue(@Nullable Identifier var1);

    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> var1);

    default public Optional<T> getOptional(@Nullable Identifier var0) {
        return Optional.ofNullable(this.getValue(var0));
    }

    default public Optional<T> getOptional(@Nullable ResourceKey<T> var0) {
        return Optional.ofNullable(this.getValue(var0));
    }

    public Optional<Holder.Reference<T>> getAny();

    default public T getValueOrThrow(ResourceKey<T> var0) {
        T var1 = this.getValue(var0);
        if (var1 == null) {
            throw new IllegalStateException("Missing key in " + String.valueOf(this.key()) + ": " + String.valueOf(var0));
        }
        return var1;
    }

    public Set<Identifier> keySet();

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet();

    public Set<ResourceKey<T>> registryKeySet();

    public Optional<Holder.Reference<T>> getRandom(RandomSource var1);

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean containsKey(Identifier var1);

    public boolean containsKey(ResourceKey<T> var1);

    public static <T> T register(Registry<? super T> var0, String var1, T var2) {
        return Registry.register(var0, Identifier.parse(var1), var2);
    }

    public static <V, T extends V> T register(Registry<V> var0, Identifier var1, T var2) {
        return Registry.register(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public static <V, T extends V> T register(Registry<V> var0, ResourceKey<V> var1, T var2) {
        ((WritableRegistry)var0).register(var1, var2, RegistrationInfo.BUILT_IN);
        return var2;
    }

    public static <R, T extends R> Holder.Reference<T> registerForHolder(Registry<R> var0, ResourceKey<R> var1, T var2) {
        return ((WritableRegistry)var0).register(var1, var2, RegistrationInfo.BUILT_IN);
    }

    public static <R, T extends R> Holder.Reference<T> registerForHolder(Registry<R> var0, Identifier var1, T var2) {
        return Registry.registerForHolder(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public Registry<T> freeze();

    public Holder.Reference<T> createIntrusiveHolder(T var1);

    public Optional<Holder.Reference<T>> get(int var1);

    public Optional<Holder.Reference<T>> get(Identifier var1);

    public Holder<T> wrapAsHolder(T var1);

    default public Iterable<Holder<T>> getTagOrEmpty(TagKey<T> var0) {
        return (Iterable)DataFixUtils.orElse((Optional)this.get(var0), List.of());
    }

    public Stream<HolderSet.Named<T>> getTags();

    default public IdMap<Holder<T>> asHolderIdMap() {
        return new IdMap<Holder<T>>(){

            @Override
            public int getId(Holder<T> var0) {
                return Registry.this.getId(var0.value());
            }

            @Override
            public @Nullable Holder<T> byId(int var0) {
                return Registry.this.get(var0).orElse(null);
            }

            @Override
            public int size() {
                return Registry.this.size();
            }

            @Override
            public Iterator<Holder<T>> iterator() {
                return Registry.this.listElements().map(var0 -> var0).iterator();
            }

            @Override
            public /* synthetic */ @Nullable Object byId(int n) {
                return this.byId(n);
            }
        };
    }

    public PendingTags<T> prepareTagReload(TagLoader.LoadResult<T> var1);

    public static interface PendingTags<T> {
        public ResourceKey<? extends Registry<? extends T>> key();

        public HolderLookup.RegistryLookup<T> lookup();

        public void apply();

        public int size();
    }
}

