/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

public interface RegistryAccess
extends HolderLookup.Provider {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Frozen EMPTY = new ImmutableRegistryAccess(Map.of()).freeze();

    public <E> Optional<Registry<E>> lookup(ResourceKey<? extends Registry<? extends E>> var1);

    default public <E> Registry<E> lookupOrThrow(ResourceKey<? extends Registry<? extends E>> var0) {
        return this.lookup(var0).orElseThrow(() -> new IllegalStateException("Missing registry: " + String.valueOf(var0)));
    }

    public Stream<RegistryEntry<?>> registries();

    @Override
    default public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
        return this.registries().map(var0 -> var0.key);
    }

    public static Frozen fromRegistryOfRegistries(final Registry<? extends Registry<?>> var0) {
        return new Frozen(){

            public <T> Optional<Registry<T>> lookup(ResourceKey<? extends Registry<? extends T>> var02) {
                Registry var1 = var0;
                return var1.getOptional(var02);
            }

            @Override
            public Stream<RegistryEntry<?>> registries() {
                return var0.entrySet().stream().map(RegistryEntry::fromMapEntry);
            }

            @Override
            public Frozen freeze() {
                return this;
            }
        };
    }

    default public Frozen freeze() {
        class FrozenAccess
        extends ImmutableRegistryAccess
        implements Frozen {
            protected FrozenAccess(RegistryAccess var0, Stream var1) {
                super(var1);
            }
        }
        return new FrozenAccess(this, this.registries().map(RegistryEntry::freeze));
    }

    @Override
    default public /* synthetic */ HolderLookup.RegistryLookup lookupOrThrow(ResourceKey resourceKey) {
        return this.lookupOrThrow(resourceKey);
    }

    @Override
    default public /* synthetic */ HolderGetter lookupOrThrow(ResourceKey resourceKey) {
        return this.lookupOrThrow(resourceKey);
    }

    public static final class RegistryEntry<T>
    extends Record {
        final ResourceKey<? extends Registry<T>> key;
        private final Registry<T> value;

        public RegistryEntry(ResourceKey<? extends Registry<T>> var0, Registry<T> var1) {
            this.key = var0;
            this.value = var1;
        }

        private static <T, R extends Registry<? extends T>> RegistryEntry<T> fromMapEntry(Map.Entry<? extends ResourceKey<? extends Registry<?>>, R> var0) {
            return RegistryEntry.fromUntyped(var0.getKey(), (Registry)var0.getValue());
        }

        private static <T> RegistryEntry<T> fromUntyped(ResourceKey<? extends Registry<?>> var0, Registry<?> var1) {
            return new RegistryEntry(var0, var1);
        }

        private RegistryEntry<T> freeze() {
            return new RegistryEntry<T>(this.key, this.value.freeze());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryEntry.class, "key;value", "key", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryEntry.class, "key;value", "key", "value"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryEntry.class, "key;value", "key", "value"}, this, var0);
        }

        public ResourceKey<? extends Registry<T>> key() {
            return this.key;
        }

        public Registry<T> value() {
            return this.value;
        }
    }

    public static class ImmutableRegistryAccess
    implements RegistryAccess {
        private final Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> registries;

        public ImmutableRegistryAccess(List<? extends Registry<?>> var02) {
            this.registries = var02.stream().collect(Collectors.toUnmodifiableMap(Registry::key, var0 -> var0));
        }

        public ImmutableRegistryAccess(Map<? extends ResourceKey<? extends Registry<?>>, ? extends Registry<?>> var0) {
            this.registries = Map.copyOf(var0);
        }

        public ImmutableRegistryAccess(Stream<RegistryEntry<?>> var0) {
            this.registries = (Map)var0.collect(ImmutableMap.toImmutableMap(RegistryEntry::key, RegistryEntry::value));
        }

        @Override
        public <E> Optional<Registry<E>> lookup(ResourceKey<? extends Registry<? extends E>> var02) {
            return Optional.ofNullable(this.registries.get(var02)).map(var0 -> var0);
        }

        @Override
        public Stream<RegistryEntry<?>> registries() {
            return this.registries.entrySet().stream().map(RegistryEntry::fromMapEntry);
        }
    }

    public static interface Frozen
    extends RegistryAccess {
    }
}

