/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Cloner;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jspecify.annotations.Nullable;

public class RegistrySetBuilder {
    private final List<RegistryStub<?>> entries = new ArrayList();

    static <T> HolderGetter<T> wrapContextLookup(final HolderLookup.RegistryLookup<T> var0) {
        return new EmptyTagLookup<T>(var0){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> var02) {
                return var0.get(var02);
            }
        };
    }

    static <T> HolderLookup.RegistryLookup<T> lookupFromMap(final ResourceKey<? extends Registry<? extends T>> var0, final Lifecycle var1, HolderOwner<T> var2, final Map<ResourceKey<T>, Holder.Reference<T>> var3) {
        return new EmptyTagRegistryLookup<T>(var2){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return var0;
            }

            @Override
            public Lifecycle registryLifecycle() {
                return var1;
            }

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> var02) {
                return Optional.ofNullable((Holder.Reference)var3.get(var02));
            }

            @Override
            public Stream<Holder.Reference<T>> listElements() {
                return var3.values().stream();
            }
        };
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> var0, Lifecycle var1, RegistryBootstrap<T> var2) {
        this.entries.add(new RegistryStub<T>(var0, var1, var2));
        return this;
    }

    public <T> RegistrySetBuilder add(ResourceKey<? extends Registry<T>> var0, RegistryBootstrap<T> var1) {
        return this.add(var0, Lifecycle.stable(), var1);
    }

    private BuildState createState(RegistryAccess var0) {
        BuildState var12 = BuildState.create(var0, this.entries.stream().map(RegistryStub::key));
        this.entries.forEach(var1 -> var1.apply(var12));
        return var12;
    }

    private static HolderLookup.Provider buildProviderWithContext(UniversalOwner var0, RegistryAccess var12, Stream<HolderLookup.RegistryLookup<?>> var22) {
        record Entry<T>(HolderLookup.RegistryLookup<T> lookup, RegistryOps.RegistryInfo<T> opsInfo) {
            public static <T> Entry<T> createForContextRegistry(HolderLookup.RegistryLookup<T> var0) {
                return new Entry<T>(new EmptyTagLookupWrapper<T>(var0, var0), RegistryOps.RegistryInfo.fromRegistryLookup(var0));
            }

            public static <T> Entry<T> createForNewRegistry(UniversalOwner var0, HolderLookup.RegistryLookup<T> var1) {
                return new Entry(new EmptyTagLookupWrapper(var0.cast(), var1), new RegistryOps.RegistryInfo(var0.cast(), var1, var1.registryLifecycle()));
            }
        }
        final HashMap var3 = new HashMap();
        var12.registries().forEach(var1 -> var3.put(var1.key(), Entry.createForContextRegistry(var1.value())));
        var22.forEach(var2 -> var3.put(var2.key(), Entry.createForNewRegistry(var0, var2)));
        return new HolderLookup.Provider(){

            @Override
            public Stream<ResourceKey<? extends Registry<?>>> listRegistryKeys() {
                return var3.keySet().stream();
            }

            <T> Optional<Entry<T>> getEntry(ResourceKey<? extends Registry<? extends T>> var0) {
                return Optional.ofNullable((Entry)var3.get(var0));
            }

            public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(ResourceKey<? extends Registry<? extends T>> var0) {
                return this.getEntry(var0).map(Entry::lookup);
            }

            @Override
            public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> var0) {
                return RegistryOps.create(var0, new RegistryOps.RegistryInfoLookup(){

                    @Override
                    public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> var0) {
                        return this.getEntry(var0).map(Entry::opsInfo);
                    }
                });
            }
        };
    }

    public HolderLookup.Provider build(RegistryAccess var0) {
        BuildState var12 = this.createState(var0);
        Stream<HolderLookup.RegistryLookup<?>> var2 = this.entries.stream().map(var1 -> var1.collectRegisteredValues(var12).buildAsLookup(var0.owner));
        HolderLookup.Provider var3 = RegistrySetBuilder.buildProviderWithContext(var12.owner, var0, var2);
        var12.reportNotCollectedHolders();
        var12.reportUnclaimedRegisteredValues();
        var12.throwOnError();
        return var3;
    }

    private HolderLookup.Provider createLazyFullPatchedRegistries(RegistryAccess var0, HolderLookup.Provider var1, Cloner.Factory var2, Map<ResourceKey<? extends Registry<?>>, RegistryContents<?>> var3, HolderLookup.Provider var4) {
        UniversalOwner var52 = new UniversalOwner();
        MutableObject var6 = new MutableObject();
        List var7 = var3.keySet().stream().map(var5 -> this.createLazyFullPatchedRegistries(var52, var2, (ResourceKey)var5, var4, var1, (MutableObject<HolderLookup.Provider>)var6)).collect(Collectors.toUnmodifiableList());
        HolderLookup.Provider var8 = RegistrySetBuilder.buildProviderWithContext(var52, var0, var7.stream());
        var6.setValue((Object)var8);
        return var8;
    }

    private <T> HolderLookup.RegistryLookup<T> createLazyFullPatchedRegistries(HolderOwner<T> var0, Cloner.Factory var1, ResourceKey<? extends Registry<? extends T>> var2, HolderLookup.Provider var3, HolderLookup.Provider var4, MutableObject<HolderLookup.Provider> var52) {
        Cloner var6 = var1.cloner(var2);
        if (var6 == null) {
            throw new NullPointerException("No cloner for " + String.valueOf(var2.identifier()));
        }
        HashMap var7 = new HashMap();
        HolderGetter var8 = var3.lookupOrThrow(var2);
        var8.listElements().forEach(var5 -> {
            ResourceKey var6 = var5.key();
            LazyHolder var7 = new LazyHolder(var0, var6);
            var7.supplier = () -> var6.clone(var5.value(), var3, (HolderLookup.Provider)var52.get());
            var7.put(var6, var7);
        });
        HolderGetter var9 = var4.lookupOrThrow(var2);
        var9.listElements().forEach(var5 -> {
            ResourceKey var62 = var5.key();
            var7.computeIfAbsent(var62, var6 -> {
                LazyHolder var7 = new LazyHolder(var0, var62);
                var7.supplier = () -> var6.clone(var5.value(), var4, (HolderLookup.Provider)var52.get());
                return var7;
            });
        });
        Lifecycle var10 = var8.registryLifecycle().add(var9.registryLifecycle());
        return RegistrySetBuilder.lookupFromMap(var2, var10, var0, var7);
    }

    public PatchedRegistries buildPatch(RegistryAccess var0, HolderLookup.Provider var12, Cloner.Factory var2) {
        BuildState var3 = this.createState(var0);
        HashMap var4 = new HashMap();
        this.entries.stream().map(var1 -> var1.collectRegisteredValues(var3)).forEach(var1 -> var4.put((ResourceKey<Registry<?>>)var1.key, (RegistryContents<?>)var1));
        Set var5 = var0.listRegistryKeys().collect(Collectors.toUnmodifiableSet());
        var12.listRegistryKeys().filter(var1 -> !var5.contains(var1)).forEach(var1 -> var4.putIfAbsent((ResourceKey<Registry<?>>)var1, new RegistryContents(var1, Lifecycle.stable(), Map.of())));
        Stream<HolderLookup.RegistryLookup<?>> var6 = var4.values().stream().map(var1 -> var1.buildAsLookup(var0.owner));
        HolderLookup.Provider var7 = RegistrySetBuilder.buildProviderWithContext(var3.owner, var0, var6);
        var3.reportUnclaimedRegisteredValues();
        var3.throwOnError();
        HolderLookup.Provider var8 = this.createLazyFullPatchedRegistries(var0, var12, var2, var4, var7);
        return new PatchedRegistries(var8, var7);
    }

    record RegistryStub<T>(ResourceKey<? extends Registry<T>> key, Lifecycle lifecycle, RegistryBootstrap<T> bootstrap) {
        void apply(BuildState var0) {
            this.bootstrap.run(var0.bootstrapContext());
        }

        public RegistryContents<T> collectRegisteredValues(BuildState var0) {
            HashMap var1 = new HashMap();
            Iterator<Map.Entry<ResourceKey<?>, RegisteredValue<?>>> var2 = var0.registeredValues.entrySet().iterator();
            while (var2.hasNext()) {
                Map.Entry<ResourceKey<?>, RegisteredValue<?>> var3 = var2.next();
                ResourceKey<?> var4 = var3.getKey();
                if (!var4.isFor(this.key)) continue;
                ResourceKey<?> var5 = var4;
                RegisteredValue<?> var6 = var3.getValue();
                Holder.Reference<Object> var7 = var0.lookup.holders.remove(var4);
                var1.put(var5, new ValueAndHolder(var6, Optional.ofNullable(var7)));
                var2.remove();
            }
            return new RegistryContents(this.key, this.lifecycle, var1);
        }
    }

    @FunctionalInterface
    public static interface RegistryBootstrap<T> {
        public void run(BootstrapContext<T> var1);
    }

    static final class BuildState
    extends Record {
        final UniversalOwner owner;
        final UniversalLookup lookup;
        final Map<Identifier, HolderGetter<?>> registries;
        final Map<ResourceKey<?>, RegisteredValue<?>> registeredValues;
        final List<RuntimeException> errors;

        private BuildState(UniversalOwner var0, UniversalLookup var1, Map<Identifier, HolderGetter<?>> var2, Map<ResourceKey<?>, RegisteredValue<?>> var3, List<RuntimeException> var4) {
            this.owner = var0;
            this.lookup = var1;
            this.registries = var2;
            this.registeredValues = var3;
            this.errors = var4;
        }

        public static BuildState create(RegistryAccess var0, Stream<ResourceKey<? extends Registry<?>>> var12) {
            UniversalOwner var22 = new UniversalOwner();
            ArrayList<RuntimeException> var3 = new ArrayList<RuntimeException>();
            UniversalLookup var4 = new UniversalLookup(var22);
            ImmutableMap.Builder var5 = ImmutableMap.builder();
            var0.registries().forEach(var1 -> var5.put((Object)var1.key().identifier(), RegistrySetBuilder.wrapContextLookup(var1.value())));
            var12.forEach(var2 -> var5.put((Object)var2.identifier(), (Object)var4));
            return new BuildState(var22, var4, (Map<Identifier, HolderGetter<?>>)var5.build(), new HashMap(), (List<RuntimeException>)var3);
        }

        public <T> BootstrapContext<T> bootstrapContext() {
            return new BootstrapContext<T>(){

                @Override
                public Holder.Reference<T> register(ResourceKey<T> var0, T var1, Lifecycle var2) {
                    RegisteredValue var3 = registeredValues.put(var0, new RegisteredValue(var1, var2));
                    if (var3 != null) {
                        errors.add(new IllegalStateException("Duplicate registration for " + String.valueOf(var0) + ", new=" + String.valueOf(var1) + ", old=" + String.valueOf(var3.value)));
                    }
                    return lookup.getOrCreate(var0);
                }

                @Override
                public <S> HolderGetter<S> lookup(ResourceKey<? extends Registry<? extends S>> var0) {
                    return registries.getOrDefault(var0.identifier(), lookup);
                }
            };
        }

        public void reportUnclaimedRegisteredValues() {
            this.registeredValues.forEach((var0, var1) -> this.errors.add(new IllegalStateException("Orpaned value " + String.valueOf(var1.value) + " for key " + String.valueOf(var0))));
        }

        public void reportNotCollectedHolders() {
            for (ResourceKey<Object> var1 : this.lookup.holders.keySet()) {
                this.errors.add(new IllegalStateException("Unreferenced key: " + String.valueOf(var1)));
            }
        }

        public void throwOnError() {
            if (!this.errors.isEmpty()) {
                IllegalStateException var0 = new IllegalStateException("Errors during registry creation");
                for (RuntimeException var2 : this.errors) {
                    var0.addSuppressed(var2);
                }
                throw var0;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BuildState.class, "owner;lookup;registries;registeredValues;errors", "owner", "lookup", "registries", "registeredValues", "errors"}, this, var0);
        }

        public UniversalOwner owner() {
            return this.owner;
        }

        public UniversalLookup lookup() {
            return this.lookup;
        }

        public Map<Identifier, HolderGetter<?>> registries() {
            return this.registries;
        }

        public Map<ResourceKey<?>, RegisteredValue<?>> registeredValues() {
            return this.registeredValues;
        }

        public List<RuntimeException> errors() {
            return this.errors;
        }
    }

    static class UniversalOwner
    implements HolderOwner<Object> {
        UniversalOwner() {
        }

        public <T> HolderOwner<T> cast() {
            return this;
        }
    }

    public record PatchedRegistries(HolderLookup.Provider full, HolderLookup.Provider patches) {
    }

    static final class RegistryContents<T>
    extends Record {
        final ResourceKey<? extends Registry<? extends T>> key;
        private final Lifecycle lifecycle;
        private final Map<ResourceKey<T>, ValueAndHolder<T>> values;

        RegistryContents(ResourceKey<? extends Registry<? extends T>> var0, Lifecycle var1, Map<ResourceKey<T>, ValueAndHolder<T>> var2) {
            this.key = var0;
            this.lifecycle = var1;
            this.values = var2;
        }

        public HolderLookup.RegistryLookup<T> buildAsLookup(UniversalOwner var0) {
            Map var12 = this.values.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, var1 -> {
                ValueAndHolder var2 = (ValueAndHolder)var1.getValue();
                Holder.Reference var3 = var2.holder().orElseGet(() -> Holder.Reference.createStandAlone(var0.cast(), (ResourceKey)var1.getKey()));
                var3.bindValue(var2.value().value());
                return var3;
            }));
            return RegistrySetBuilder.lookupFromMap(this.key, this.lifecycle, var0.cast(), var12);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryContents.class, "key;lifecycle;values", "key", "lifecycle", "values"}, this, var0);
        }

        public ResourceKey<? extends Registry<? extends T>> key() {
            return this.key;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }

        public Map<ResourceKey<T>, ValueAndHolder<T>> values() {
            return this.values;
        }
    }

    static class LazyHolder<T>
    extends Holder.Reference<T> {
        @Nullable Supplier<T> supplier;

        protected LazyHolder(HolderOwner<T> var0, @Nullable ResourceKey<T> var1) {
            super(Holder.Reference.Type.STAND_ALONE, var0, var1, null);
        }

        @Override
        protected void bindValue(T var0) {
            super.bindValue(var0);
            this.supplier = null;
        }

        @Override
        public T value() {
            if (this.supplier != null) {
                this.bindValue(this.supplier.get());
            }
            return super.value();
        }
    }

    record ValueAndHolder<T>(RegisteredValue<T> value, Optional<Holder.Reference<T>> holder) {
    }

    static final class RegisteredValue<T>
    extends Record {
        final T value;
        private final Lifecycle lifecycle;

        RegisteredValue(T var0, Lifecycle var1) {
            this.value = var0;
            this.lifecycle = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "value", "lifecycle"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegisteredValue.class, "value;lifecycle", "value", "lifecycle"}, this, var0);
        }

        public T value() {
            return this.value;
        }

        public Lifecycle lifecycle() {
            return this.lifecycle;
        }
    }

    static class UniversalLookup
    extends EmptyTagLookup<Object> {
        final Map<ResourceKey<Object>, Holder.Reference<Object>> holders = new HashMap<ResourceKey<Object>, Holder.Reference<Object>>();

        public UniversalLookup(HolderOwner<Object> var0) {
            super(var0);
        }

        @Override
        public Optional<Holder.Reference<Object>> get(ResourceKey<Object> var0) {
            return Optional.of(this.getOrCreate(var0));
        }

        <T> Holder.Reference<T> getOrCreate(ResourceKey<T> var02) {
            return this.holders.computeIfAbsent(var02, var0 -> Holder.Reference.createStandAlone(this.owner, var0));
        }
    }

    static class EmptyTagLookupWrapper<T>
    extends EmptyTagRegistryLookup<T>
    implements HolderLookup.RegistryLookup.Delegate<T> {
        private final HolderLookup.RegistryLookup<T> parent;

        EmptyTagLookupWrapper(HolderOwner<T> var0, HolderLookup.RegistryLookup<T> var1) {
            super(var0);
            this.parent = var1;
        }

        @Override
        public HolderLookup.RegistryLookup<T> parent() {
            return this.parent;
        }
    }

    static abstract class EmptyTagRegistryLookup<T>
    extends EmptyTagLookup<T>
    implements HolderLookup.RegistryLookup<T> {
        protected EmptyTagRegistryLookup(HolderOwner<T> var0) {
            super(var0);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            throw new UnsupportedOperationException("Tags are not available in datagen");
        }
    }

    static abstract class EmptyTagLookup<T>
    implements HolderGetter<T> {
        protected final HolderOwner<T> owner;

        protected EmptyTagLookup(HolderOwner<T> var0) {
            this.owner = var0;
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
            return Optional.of(HolderSet.emptyNamed(this.owner, var0));
        }
    }
}

