/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.stream.IntStream;
import javax.annotation.concurrent.Immutable;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import org.joml.Vector3i;

@Immutable
public class Vec3i
implements Comparable<Vec3i> {
    public static final Codec<Vec3i> CODEC = Codec.INT_STREAM.comapFlatMap(var02 -> Util.fixedSize(var02, 3).map(var0 -> new Vec3i(var0[0], var0[1], var0[2])), var0 -> IntStream.of(var0.getX(), var0.getY(), var0.getZ()));
    public static final StreamCodec<ByteBuf, Vec3i> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, Vec3i::getX, ByteBufCodecs.VAR_INT, Vec3i::getY, ByteBufCodecs.VAR_INT, Vec3i::getZ, Vec3i::new);
    public static final Vec3i ZERO = new Vec3i(0, 0, 0);
    private int x;
    private int y;
    private int z;

    public static Codec<Vec3i> offsetCodec(int var0) {
        return CODEC.validate(var1 -> {
            if (Math.abs(var1.getX()) < var0 && Math.abs(var1.getY()) < var0 && Math.abs(var1.getZ()) < var0) {
                return DataResult.success((Object)var1);
            }
            return DataResult.error(() -> "Position out of range, expected at most " + var0 + ": " + String.valueOf(var1));
        });
    }

    public Vec3i(int var0, int var1, int var2) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof Vec3i)) {
            return false;
        }
        Vec3i var1 = (Vec3i)var0;
        return this.getX() == var1.getX() && this.getY() == var1.getY() && this.getZ() == var1.getZ();
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    @Override
    public int compareTo(Vec3i var0) {
        if (this.getY() == var0.getY()) {
            if (this.getZ() == var0.getZ()) {
                return this.getX() - var0.getX();
            }
            return this.getZ() - var0.getZ();
        }
        return this.getY() - var0.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    protected Vec3i setX(int var0) {
        this.x = var0;
        return this;
    }

    protected Vec3i setY(int var0) {
        this.y = var0;
        return this;
    }

    protected Vec3i setZ(int var0) {
        this.z = var0;
        return this;
    }

    public Vec3i offset(int var0, int var1, int var2) {
        if (var0 == 0 && var1 == 0 && var2 == 0) {
            return this;
        }
        return new Vec3i(this.getX() + var0, this.getY() + var1, this.getZ() + var2);
    }

    public Vec3i offset(Vec3i var0) {
        return this.offset(var0.getX(), var0.getY(), var0.getZ());
    }

    public Vec3i subtract(Vec3i var0) {
        return this.offset(-var0.getX(), -var0.getY(), -var0.getZ());
    }

    public Vec3i multiply(int var0) {
        if (var0 == 1) {
            return this;
        }
        if (var0 == 0) {
            return ZERO;
        }
        return new Vec3i(this.getX() * var0, this.getY() * var0, this.getZ() * var0);
    }

    public Vec3i multiply(int var0, int var1, int var2) {
        return new Vec3i(this.getX() * var0, this.getY() * var1, this.getZ() * var2);
    }

    public Vec3i above() {
        return this.above(1);
    }

    public Vec3i above(int var0) {
        return this.relative(Direction.UP, var0);
    }

    public Vec3i below() {
        return this.below(1);
    }

    public Vec3i below(int var0) {
        return this.relative(Direction.DOWN, var0);
    }

    public Vec3i north() {
        return this.north(1);
    }

    public Vec3i north(int var0) {
        return this.relative(Direction.NORTH, var0);
    }

    public Vec3i south() {
        return this.south(1);
    }

    public Vec3i south(int var0) {
        return this.relative(Direction.SOUTH, var0);
    }

    public Vec3i west() {
        return this.west(1);
    }

    public Vec3i west(int var0) {
        return this.relative(Direction.WEST, var0);
    }

    public Vec3i east() {
        return this.east(1);
    }

    public Vec3i east(int var0) {
        return this.relative(Direction.EAST, var0);
    }

    public Vec3i relative(Direction var0) {
        return this.relative(var0, 1);
    }

    public Vec3i relative(Direction var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        return new Vec3i(this.getX() + var0.getStepX() * var1, this.getY() + var0.getStepY() * var1, this.getZ() + var0.getStepZ() * var1);
    }

    public Vec3i relative(Direction.Axis var0, int var1) {
        if (var1 == 0) {
            return this;
        }
        int var2 = var0 == Direction.Axis.X ? var1 : 0;
        int var3 = var0 == Direction.Axis.Y ? var1 : 0;
        int var4 = var0 == Direction.Axis.Z ? var1 : 0;
        return new Vec3i(this.getX() + var2, this.getY() + var3, this.getZ() + var4);
    }

    public Vec3i cross(Vec3i var0) {
        return new Vec3i(this.getY() * var0.getZ() - this.getZ() * var0.getY(), this.getZ() * var0.getX() - this.getX() * var0.getZ(), this.getX() * var0.getY() - this.getY() * var0.getX());
    }

    public boolean closerThan(Vec3i var0, double var1) {
        return this.distSqr(var0) < Mth.square(var1);
    }

    public boolean closerToCenterThan(Position var0, double var1) {
        return this.distToCenterSqr(var0) < Mth.square(var1);
    }

    public double distSqr(Vec3i var0) {
        return this.distToLowCornerSqr(var0.getX(), var0.getY(), var0.getZ());
    }

    public double distToCenterSqr(Position var0) {
        return this.distToCenterSqr(var0.x(), var0.y(), var0.z());
    }

    public double distToCenterSqr(double var0, double var2, double var4) {
        double var6 = (double)this.getX() + 0.5 - var0;
        double var8 = (double)this.getY() + 0.5 - var2;
        double var10 = (double)this.getZ() + 0.5 - var4;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public double distToLowCornerSqr(double var0, double var2, double var4) {
        double var6 = (double)this.getX() - var0;
        double var8 = (double)this.getY() - var2;
        double var10 = (double)this.getZ() - var4;
        return var6 * var6 + var8 * var8 + var10 * var10;
    }

    public int distManhattan(Vec3i var0) {
        float var1 = Math.abs(var0.getX() - this.getX());
        float var2 = Math.abs(var0.getY() - this.getY());
        float var3 = Math.abs(var0.getZ() - this.getZ());
        return (int)(var1 + var2 + var3);
    }

    public int distChessboard(Vec3i var0) {
        int var1 = Math.abs(this.getX() - var0.getX());
        int var2 = Math.abs(this.getY() - var0.getY());
        int var3 = Math.abs(this.getZ() - var0.getZ());
        return Math.max(Math.max(var1, var2), var3);
    }

    public int get(Direction.Axis var0) {
        return var0.choose(this.x, this.y, this.z);
    }

    public Vector3i toMutable() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("z", this.getZ()).toString();
    }

    public String toShortString() {
        return this.getX() + ", " + this.getY() + ", " + this.getZ();
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((Vec3i)object);
    }
}

