/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class DataComponentExactPredicate
implements Predicate<DataComponentGetter> {
    public static final Codec<DataComponentExactPredicate> CODEC = DataComponentType.VALUE_MAP_CODEC.xmap(var0 -> new DataComponentExactPredicate(var0.entrySet().stream().map(TypedDataComponent::fromEntryUnchecked).collect(Collectors.toList())), var02 -> var02.expectedComponents.stream().filter(var0 -> !var0.type().isTransient()).collect(Collectors.toMap(TypedDataComponent::type, TypedDataComponent::value)));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentExactPredicate> STREAM_CODEC = TypedDataComponent.STREAM_CODEC.apply(ByteBufCodecs.list()).map(DataComponentExactPredicate::new, var0 -> var0.expectedComponents);
    public static final DataComponentExactPredicate EMPTY = new DataComponentExactPredicate(List.of());
    private final List<TypedDataComponent<?>> expectedComponents;

    DataComponentExactPredicate(List<TypedDataComponent<?>> var0) {
        this.expectedComponents = var0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> DataComponentExactPredicate expect(DataComponentType<T> var0, T var1) {
        return new DataComponentExactPredicate(List.of(new TypedDataComponent<T>(var0, var1)));
    }

    public static DataComponentExactPredicate allOf(DataComponentMap var0) {
        return new DataComponentExactPredicate((List<TypedDataComponent<?>>)ImmutableList.copyOf((Iterable)var0));
    }

    public static DataComponentExactPredicate someOf(DataComponentMap var0, DataComponentType<?> ... var1) {
        Builder var2 = new Builder();
        for (DataComponentType<?> var6 : var1) {
            TypedDataComponent<?> var7 = var0.getTyped(var6);
            if (var7 == null) continue;
            var2.expect(var7);
        }
        return var2.build();
    }

    public boolean isEmpty() {
        return this.expectedComponents.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (!(var0 instanceof DataComponentExactPredicate)) return false;
        DataComponentExactPredicate var1 = (DataComponentExactPredicate)var0;
        if (!this.expectedComponents.equals(var1.expectedComponents)) return false;
        return true;
    }

    public int hashCode() {
        return this.expectedComponents.hashCode();
    }

    public String toString() {
        return this.expectedComponents.toString();
    }

    @Override
    public boolean test(DataComponentGetter var0) {
        for (TypedDataComponent<?> var2 : this.expectedComponents) {
            Object var3 = var0.get(var2.type());
            if (Objects.equals(var2.value(), var3)) continue;
            return false;
        }
        return true;
    }

    public boolean alwaysMatches() {
        return this.expectedComponents.isEmpty();
    }

    public DataComponentPatch asPatch() {
        DataComponentPatch.Builder var0 = DataComponentPatch.builder();
        for (TypedDataComponent<?> var2 : this.expectedComponents) {
            var0.set(var2);
        }
        return var0.build();
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((DataComponentGetter)object);
    }

    public static class Builder {
        private final List<TypedDataComponent<?>> expectedComponents = new ArrayList();

        Builder() {
        }

        public <T> Builder expect(TypedDataComponent<T> var0) {
            return this.expect(var0.type(), var0.value());
        }

        public <T> Builder expect(DataComponentType<? super T> var0, T var1) {
            for (TypedDataComponent<?> var3 : this.expectedComponents) {
                if (var3.type() != var0) continue;
                throw new IllegalArgumentException("Predicate already has component of type: '" + String.valueOf(var0) + "'");
            }
            this.expectedComponents.add(new TypedDataComponent<T>(var0, var1));
            return this;
        }

        public DataComponentExactPredicate build() {
            return new DataComponentExactPredicate(List.copyOf(this.expectedComponents));
        }
    }
}

