/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.EncoderCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.minecraft.world.LockCode;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.cow.CowVariant;
import net.minecraft.world.entity.animal.cow.MushroomCow;
import net.minecraft.world.entity.animal.equine.Llama;
import net.minecraft.world.entity.animal.equine.Variant;
import net.minecraft.world.entity.animal.feline.CatVariant;
import net.minecraft.world.entity.animal.fish.Salmon;
import net.minecraft.world.entity.animal.fish.TropicalFish;
import net.minecraft.world.entity.animal.fox.Fox;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.parrot.Parrot;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.entity.animal.rabbit.Rabbit;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.painting.PaintingVariant;
import net.minecraft.world.entity.npc.villager.VillagerType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.OminousBottleAmplifier;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.SwingAnimation;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseEffects;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.saveddata.maps.MapId;

public class DataComponents {
    static final EncoderCache ENCODER_CACHE = new EncoderCache(512);
    public static final DataComponentType<CustomData> CUSTOM_DATA = DataComponents.register("custom_data", var0 -> var0.persistent(CustomData.CODEC));
    public static final DataComponentType<Integer> MAX_STACK_SIZE = DataComponents.register("max_stack_size", var0 -> var0.persistent(ExtraCodecs.intRange(1, 99)).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> MAX_DAMAGE = DataComponents.register("max_damage", var0 -> var0.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> DAMAGE = DataComponents.register("damage", var0 -> var0.persistent(ExtraCodecs.NON_NEGATIVE_INT).ignoreSwapAnimation().networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Unit> UNBREAKABLE = DataComponents.register("unbreakable", var0 -> var0.persistent(Unit.CODEC).networkSynchronized(Unit.STREAM_CODEC));
    public static final DataComponentType<UseEffects> USE_EFFECTS = DataComponents.register("use_effects", var0 -> var0.persistent(UseEffects.CODEC).networkSynchronized(UseEffects.STREAM_CODEC));
    public static final DataComponentType<Component> CUSTOM_NAME = DataComponents.register("custom_name", var0 -> var0.persistent(ComponentSerialization.CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Float> MINIMUM_ATTACK_CHARGE = DataComponents.register("minimum_attack_charge", var0 -> var0.persistent(ExtraCodecs.floatRange(0.0f, 1.0f)).networkSynchronized(ByteBufCodecs.FLOAT));
    public static final DataComponentType<EitherHolder<DamageType>> DAMAGE_TYPE = DataComponents.register("damage_type", var0 -> var0.persistent(EitherHolder.codec(Registries.DAMAGE_TYPE, DamageType.CODEC)).networkSynchronized(EitherHolder.streamCodec(Registries.DAMAGE_TYPE, DamageType.STREAM_CODEC)));
    public static final DataComponentType<Component> ITEM_NAME = DataComponents.register("item_name", var0 -> var0.persistent(ComponentSerialization.CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Identifier> ITEM_MODEL = DataComponents.register("item_model", var0 -> var0.persistent(Identifier.CODEC).networkSynchronized(Identifier.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemLore> LORE = DataComponents.register("lore", var0 -> var0.persistent(ItemLore.CODEC).networkSynchronized(ItemLore.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Rarity> RARITY = DataComponents.register("rarity", var0 -> var0.persistent(Rarity.CODEC).networkSynchronized(Rarity.STREAM_CODEC));
    public static final DataComponentType<ItemEnchantments> ENCHANTMENTS = DataComponents.register("enchantments", var0 -> var0.persistent(ItemEnchantments.CODEC).networkSynchronized(ItemEnchantments.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<AdventureModePredicate> CAN_PLACE_ON = DataComponents.register("can_place_on", var0 -> var0.persistent(AdventureModePredicate.CODEC).networkSynchronized(AdventureModePredicate.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<AdventureModePredicate> CAN_BREAK = DataComponents.register("can_break", var0 -> var0.persistent(AdventureModePredicate.CODEC).networkSynchronized(AdventureModePredicate.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemAttributeModifiers> ATTRIBUTE_MODIFIERS = DataComponents.register("attribute_modifiers", var0 -> var0.persistent(ItemAttributeModifiers.CODEC).networkSynchronized(ItemAttributeModifiers.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<CustomModelData> CUSTOM_MODEL_DATA = DataComponents.register("custom_model_data", var0 -> var0.persistent(CustomModelData.CODEC).networkSynchronized(CustomModelData.STREAM_CODEC));
    public static final DataComponentType<TooltipDisplay> TOOLTIP_DISPLAY = DataComponents.register("tooltip_display", var0 -> var0.persistent(TooltipDisplay.CODEC).networkSynchronized(TooltipDisplay.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Integer> REPAIR_COST = DataComponents.register("repair_cost", var0 -> var0.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Unit> CREATIVE_SLOT_LOCK = DataComponents.register("creative_slot_lock", var0 -> var0.networkSynchronized(Unit.STREAM_CODEC));
    public static final DataComponentType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = DataComponents.register("enchantment_glint_override", var0 -> var0.persistent(Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<Unit> INTANGIBLE_PROJECTILE = DataComponents.register("intangible_projectile", var0 -> var0.persistent(Unit.CODEC));
    public static final DataComponentType<FoodProperties> FOOD = DataComponents.register("food", var0 -> var0.persistent(FoodProperties.DIRECT_CODEC).networkSynchronized(FoodProperties.DIRECT_STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Consumable> CONSUMABLE = DataComponents.register("consumable", var0 -> var0.persistent(Consumable.CODEC).networkSynchronized(Consumable.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<UseRemainder> USE_REMAINDER = DataComponents.register("use_remainder", var0 -> var0.persistent(UseRemainder.CODEC).networkSynchronized(UseRemainder.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<UseCooldown> USE_COOLDOWN = DataComponents.register("use_cooldown", var0 -> var0.persistent(UseCooldown.CODEC).networkSynchronized(UseCooldown.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DamageResistant> DAMAGE_RESISTANT = DataComponents.register("damage_resistant", var0 -> var0.persistent(DamageResistant.CODEC).networkSynchronized(DamageResistant.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Tool> TOOL = DataComponents.register("tool", var0 -> var0.persistent(Tool.CODEC).networkSynchronized(Tool.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Weapon> WEAPON = DataComponents.register("weapon", var0 -> var0.persistent(Weapon.CODEC).networkSynchronized(Weapon.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<AttackRange> ATTACK_RANGE = DataComponents.register("attack_range", var0 -> var0.persistent(AttackRange.CODEC).networkSynchronized(AttackRange.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Enchantable> ENCHANTABLE = DataComponents.register("enchantable", var0 -> var0.persistent(Enchantable.CODEC).networkSynchronized(Enchantable.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Equippable> EQUIPPABLE = DataComponents.register("equippable", var0 -> var0.persistent(Equippable.CODEC).networkSynchronized(Equippable.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Repairable> REPAIRABLE = DataComponents.register("repairable", var0 -> var0.persistent(Repairable.CODEC).networkSynchronized(Repairable.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Unit> GLIDER = DataComponents.register("glider", var0 -> var0.persistent(Unit.CODEC).networkSynchronized(Unit.STREAM_CODEC));
    public static final DataComponentType<Identifier> TOOLTIP_STYLE = DataComponents.register("tooltip_style", var0 -> var0.persistent(Identifier.CODEC).networkSynchronized(Identifier.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DeathProtection> DEATH_PROTECTION = DataComponents.register("death_protection", var0 -> var0.persistent(DeathProtection.CODEC).networkSynchronized(DeathProtection.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<BlocksAttacks> BLOCKS_ATTACKS = DataComponents.register("blocks_attacks", var0 -> var0.persistent(BlocksAttacks.CODEC).networkSynchronized(BlocksAttacks.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<PiercingWeapon> PIERCING_WEAPON = DataComponents.register("piercing_weapon", var0 -> var0.persistent(PiercingWeapon.CODEC).networkSynchronized(PiercingWeapon.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<KineticWeapon> KINETIC_WEAPON = DataComponents.register("kinetic_weapon", var0 -> var0.persistent(KineticWeapon.CODEC).networkSynchronized(KineticWeapon.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<SwingAnimation> SWING_ANIMATION = DataComponents.register("swing_animation", var0 -> var0.persistent(SwingAnimation.CODEC).networkSynchronized(SwingAnimation.STREAM_CODEC));
    public static final DataComponentType<ItemEnchantments> STORED_ENCHANTMENTS = DataComponents.register("stored_enchantments", var0 -> var0.persistent(ItemEnchantments.CODEC).networkSynchronized(ItemEnchantments.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DyedItemColor> DYED_COLOR = DataComponents.register("dyed_color", var0 -> var0.persistent(DyedItemColor.CODEC).networkSynchronized(DyedItemColor.STREAM_CODEC));
    public static final DataComponentType<MapItemColor> MAP_COLOR = DataComponents.register("map_color", var0 -> var0.persistent(MapItemColor.CODEC).networkSynchronized(MapItemColor.STREAM_CODEC));
    public static final DataComponentType<MapId> MAP_ID = DataComponents.register("map_id", var0 -> var0.persistent(MapId.CODEC).networkSynchronized(MapId.STREAM_CODEC));
    public static final DataComponentType<MapDecorations> MAP_DECORATIONS = DataComponents.register("map_decorations", var0 -> var0.persistent(MapDecorations.CODEC).cacheEncoding());
    public static final DataComponentType<MapPostProcessing> MAP_POST_PROCESSING = DataComponents.register("map_post_processing", var0 -> var0.networkSynchronized(MapPostProcessing.STREAM_CODEC));
    public static final DataComponentType<ChargedProjectiles> CHARGED_PROJECTILES = DataComponents.register("charged_projectiles", var0 -> var0.persistent(ChargedProjectiles.CODEC).networkSynchronized(ChargedProjectiles.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<BundleContents> BUNDLE_CONTENTS = DataComponents.register("bundle_contents", var0 -> var0.persistent(BundleContents.CODEC).networkSynchronized(BundleContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<PotionContents> POTION_CONTENTS = DataComponents.register("potion_contents", var0 -> var0.persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Float> POTION_DURATION_SCALE = DataComponents.register("potion_duration_scale", var0 -> var0.persistent(ExtraCodecs.NON_NEGATIVE_FLOAT).networkSynchronized(ByteBufCodecs.FLOAT).cacheEncoding());
    public static final DataComponentType<SuspiciousStewEffects> SUSPICIOUS_STEW_EFFECTS = DataComponents.register("suspicious_stew_effects", var0 -> var0.persistent(SuspiciousStewEffects.CODEC).networkSynchronized(SuspiciousStewEffects.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<WritableBookContent> WRITABLE_BOOK_CONTENT = DataComponents.register("writable_book_content", var0 -> var0.persistent(WritableBookContent.CODEC).networkSynchronized(WritableBookContent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<WrittenBookContent> WRITTEN_BOOK_CONTENT = DataComponents.register("written_book_content", var0 -> var0.persistent(WrittenBookContent.CODEC).networkSynchronized(WrittenBookContent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ArmorTrim> TRIM = DataComponents.register("trim", var0 -> var0.persistent(ArmorTrim.CODEC).networkSynchronized(ArmorTrim.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DebugStickState> DEBUG_STICK_STATE = DataComponents.register("debug_stick_state", var0 -> var0.persistent(DebugStickState.CODEC).cacheEncoding());
    public static final DataComponentType<TypedEntityData<EntityType<?>>> ENTITY_DATA = DataComponents.register("entity_data", var0 -> var0.persistent(TypedEntityData.codec(EntityType.CODEC)).networkSynchronized(TypedEntityData.streamCodec(EntityType.STREAM_CODEC)));
    public static final DataComponentType<CustomData> BUCKET_ENTITY_DATA = DataComponents.register("bucket_entity_data", var0 -> var0.persistent(CustomData.CODEC).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<TypedEntityData<BlockEntityType<?>>> BLOCK_ENTITY_DATA = DataComponents.register("block_entity_data", var0 -> var0.persistent(TypedEntityData.codec(BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec())).networkSynchronized(TypedEntityData.streamCodec(ByteBufCodecs.registry(Registries.BLOCK_ENTITY_TYPE))));
    public static final DataComponentType<InstrumentComponent> INSTRUMENT = DataComponents.register("instrument", var0 -> var0.persistent(InstrumentComponent.CODEC).networkSynchronized(InstrumentComponent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ProvidesTrimMaterial> PROVIDES_TRIM_MATERIAL = DataComponents.register("provides_trim_material", var0 -> var0.persistent(ProvidesTrimMaterial.CODEC).networkSynchronized(ProvidesTrimMaterial.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<OminousBottleAmplifier> OMINOUS_BOTTLE_AMPLIFIER = DataComponents.register("ominous_bottle_amplifier", var0 -> var0.persistent(OminousBottleAmplifier.CODEC).networkSynchronized(OminousBottleAmplifier.STREAM_CODEC));
    public static final DataComponentType<JukeboxPlayable> JUKEBOX_PLAYABLE = DataComponents.register("jukebox_playable", var0 -> var0.persistent(JukeboxPlayable.CODEC).networkSynchronized(JukeboxPlayable.STREAM_CODEC));
    public static final DataComponentType<TagKey<BannerPattern>> PROVIDES_BANNER_PATTERNS = DataComponents.register("provides_banner_patterns", var0 -> var0.persistent(TagKey.hashedCodec(Registries.BANNER_PATTERN)).networkSynchronized(TagKey.streamCodec(Registries.BANNER_PATTERN)).cacheEncoding());
    public static final DataComponentType<List<ResourceKey<Recipe<?>>>> RECIPES = DataComponents.register("recipes", var0 -> var0.persistent(Recipe.KEY_CODEC.listOf()).cacheEncoding());
    public static final DataComponentType<LodestoneTracker> LODESTONE_TRACKER = DataComponents.register("lodestone_tracker", var0 -> var0.persistent(LodestoneTracker.CODEC).networkSynchronized(LodestoneTracker.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<FireworkExplosion> FIREWORK_EXPLOSION = DataComponents.register("firework_explosion", var0 -> var0.persistent(FireworkExplosion.CODEC).networkSynchronized(FireworkExplosion.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Fireworks> FIREWORKS = DataComponents.register("fireworks", var0 -> var0.persistent(Fireworks.CODEC).networkSynchronized(Fireworks.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ResolvableProfile> PROFILE = DataComponents.register("profile", var0 -> var0.persistent(ResolvableProfile.CODEC).networkSynchronized(ResolvableProfile.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Identifier> NOTE_BLOCK_SOUND = DataComponents.register("note_block_sound", var0 -> var0.persistent(Identifier.CODEC).networkSynchronized(Identifier.STREAM_CODEC));
    public static final DataComponentType<BannerPatternLayers> BANNER_PATTERNS = DataComponents.register("banner_patterns", var0 -> var0.persistent(BannerPatternLayers.CODEC).networkSynchronized(BannerPatternLayers.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DyeColor> BASE_COLOR = DataComponents.register("base_color", var0 -> var0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<PotDecorations> POT_DECORATIONS = DataComponents.register("pot_decorations", var0 -> var0.persistent(PotDecorations.CODEC).networkSynchronized(PotDecorations.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemContainerContents> CONTAINER = DataComponents.register("container", var0 -> var0.persistent(ItemContainerContents.CODEC).networkSynchronized(ItemContainerContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<BlockItemStateProperties> BLOCK_STATE = DataComponents.register("block_state", var0 -> var0.persistent(BlockItemStateProperties.CODEC).networkSynchronized(BlockItemStateProperties.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Bees> BEES = DataComponents.register("bees", var0 -> var0.persistent(Bees.CODEC).networkSynchronized(Bees.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<LockCode> LOCK = DataComponents.register("lock", var0 -> var0.persistent(LockCode.CODEC));
    public static final DataComponentType<SeededContainerLoot> CONTAINER_LOOT = DataComponents.register("container_loot", var0 -> var0.persistent(SeededContainerLoot.CODEC));
    public static final DataComponentType<Holder<SoundEvent>> BREAK_SOUND = DataComponents.register("break_sound", var0 -> var0.persistent(SoundEvent.CODEC).networkSynchronized(SoundEvent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Holder<VillagerType>> VILLAGER_VARIANT = DataComponents.register("villager/variant", var0 -> var0.persistent(VillagerType.CODEC).networkSynchronized(VillagerType.STREAM_CODEC));
    public static final DataComponentType<Holder<WolfVariant>> WOLF_VARIANT = DataComponents.register("wolf/variant", var0 -> var0.persistent(WolfVariant.CODEC).networkSynchronized(WolfVariant.STREAM_CODEC));
    public static final DataComponentType<Holder<WolfSoundVariant>> WOLF_SOUND_VARIANT = DataComponents.register("wolf/sound_variant", var0 -> var0.persistent(WolfSoundVariant.CODEC).networkSynchronized(WolfSoundVariant.STREAM_CODEC));
    public static final DataComponentType<DyeColor> WOLF_COLLAR = DataComponents.register("wolf/collar", var0 -> var0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<Fox.Variant> FOX_VARIANT = DataComponents.register("fox/variant", var0 -> var0.persistent(Fox.Variant.CODEC).networkSynchronized(Fox.Variant.STREAM_CODEC));
    public static final DataComponentType<Salmon.Variant> SALMON_SIZE = DataComponents.register("salmon/size", var0 -> var0.persistent(Salmon.Variant.CODEC).networkSynchronized(Salmon.Variant.STREAM_CODEC));
    public static final DataComponentType<Parrot.Variant> PARROT_VARIANT = DataComponents.register("parrot/variant", var0 -> var0.persistent(Parrot.Variant.CODEC).networkSynchronized(Parrot.Variant.STREAM_CODEC));
    public static final DataComponentType<TropicalFish.Pattern> TROPICAL_FISH_PATTERN = DataComponents.register("tropical_fish/pattern", var0 -> var0.persistent(TropicalFish.Pattern.CODEC).networkSynchronized(TropicalFish.Pattern.STREAM_CODEC));
    public static final DataComponentType<DyeColor> TROPICAL_FISH_BASE_COLOR = DataComponents.register("tropical_fish/base_color", var0 -> var0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<DyeColor> TROPICAL_FISH_PATTERN_COLOR = DataComponents.register("tropical_fish/pattern_color", var0 -> var0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<MushroomCow.Variant> MOOSHROOM_VARIANT = DataComponents.register("mooshroom/variant", var0 -> var0.persistent(MushroomCow.Variant.CODEC).networkSynchronized(MushroomCow.Variant.STREAM_CODEC));
    public static final DataComponentType<Rabbit.Variant> RABBIT_VARIANT = DataComponents.register("rabbit/variant", var0 -> var0.persistent(Rabbit.Variant.CODEC).networkSynchronized(Rabbit.Variant.STREAM_CODEC));
    public static final DataComponentType<Holder<PigVariant>> PIG_VARIANT = DataComponents.register("pig/variant", var0 -> var0.persistent(PigVariant.CODEC).networkSynchronized(PigVariant.STREAM_CODEC));
    public static final DataComponentType<Holder<CowVariant>> COW_VARIANT = DataComponents.register("cow/variant", var0 -> var0.persistent(CowVariant.CODEC).networkSynchronized(CowVariant.STREAM_CODEC));
    public static final DataComponentType<EitherHolder<ChickenVariant>> CHICKEN_VARIANT = DataComponents.register("chicken/variant", var0 -> var0.persistent(EitherHolder.codec(Registries.CHICKEN_VARIANT, ChickenVariant.CODEC)).networkSynchronized(EitherHolder.streamCodec(Registries.CHICKEN_VARIANT, ChickenVariant.STREAM_CODEC)));
    public static final DataComponentType<EitherHolder<ZombieNautilusVariant>> ZOMBIE_NAUTILUS_VARIANT = DataComponents.register("zombie_nautilus/variant", var0 -> var0.persistent(EitherHolder.codec(Registries.ZOMBIE_NAUTILUS_VARIANT, ZombieNautilusVariant.CODEC)).networkSynchronized(EitherHolder.streamCodec(Registries.ZOMBIE_NAUTILUS_VARIANT, ZombieNautilusVariant.STREAM_CODEC)));
    public static final DataComponentType<Holder<FrogVariant>> FROG_VARIANT = DataComponents.register("frog/variant", var0 -> var0.persistent(FrogVariant.CODEC).networkSynchronized(FrogVariant.STREAM_CODEC));
    public static final DataComponentType<Variant> HORSE_VARIANT = DataComponents.register("horse/variant", var0 -> var0.persistent(Variant.CODEC).networkSynchronized(Variant.STREAM_CODEC));
    public static final DataComponentType<Holder<PaintingVariant>> PAINTING_VARIANT = DataComponents.register("painting/variant", var0 -> var0.persistent(PaintingVariant.CODEC).networkSynchronized(PaintingVariant.STREAM_CODEC));
    public static final DataComponentType<Llama.Variant> LLAMA_VARIANT = DataComponents.register("llama/variant", var0 -> var0.persistent(Llama.Variant.CODEC).networkSynchronized(Llama.Variant.STREAM_CODEC));
    public static final DataComponentType<Axolotl.Variant> AXOLOTL_VARIANT = DataComponents.register("axolotl/variant", var0 -> var0.persistent(Axolotl.Variant.CODEC).networkSynchronized(Axolotl.Variant.STREAM_CODEC));
    public static final DataComponentType<Holder<CatVariant>> CAT_VARIANT = DataComponents.register("cat/variant", var0 -> var0.persistent(CatVariant.CODEC).networkSynchronized(CatVariant.STREAM_CODEC));
    public static final DataComponentType<DyeColor> CAT_COLLAR = DataComponents.register("cat/collar", var0 -> var0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<DyeColor> SHEEP_COLOR = DataComponents.register("sheep/color", var0 -> var0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentType<DyeColor> SHULKER_COLOR = DataComponents.register("shulker/color", var0 -> var0.persistent(DyeColor.CODEC).networkSynchronized(DyeColor.STREAM_CODEC));
    public static final DataComponentMap COMMON_ITEM_COMPONENTS = DataComponentMap.builder().set(MAX_STACK_SIZE, 64).set(LORE, ItemLore.EMPTY).set(ENCHANTMENTS, ItemEnchantments.EMPTY).set(REPAIR_COST, 0).set(USE_EFFECTS, UseEffects.DEFAULT).set(ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY).set(RARITY, Rarity.COMMON).set(BREAK_SOUND, SoundEvents.ITEM_BREAK).set(TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT).set(SWING_ANIMATION, SwingAnimation.DEFAULT).build();

    public static DataComponentType<?> bootstrap(Registry<DataComponentType<?>> var0) {
        return CUSTOM_DATA;
    }

    private static <T> DataComponentType<T> register(String var0, UnaryOperator<DataComponentType.Builder<T>> var1) {
        return Registry.register(BuiltInRegistries.DATA_COMPONENT_TYPE, var0, ((DataComponentType.Builder)var1.apply(DataComponentType.builder())).build());
    }
}

