/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.predicates.AnyValue;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface DataComponentPredicate {
    public static final Codec<Map<Type<?>, DataComponentPredicate>> CODEC = Codec.dispatchedMap(Type.CODEC, Type::codec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Single<?>> SINGLE_STREAM_CODEC = Type.STREAM_CODEC.dispatch(Single::type, Type::singleStreamCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<Type<?>, DataComponentPredicate>> STREAM_CODEC = SINGLE_STREAM_CODEC.apply(ByteBufCodecs.list(64)).map(var0 -> var0.stream().collect(Collectors.toMap(Single::type, Single::predicate)), var0 -> var0.entrySet().stream().map(Single::fromEntry).toList());

    public static MapCodec<Single<?>> singleCodec(String var0) {
        return Type.CODEC.dispatchMap(var0, Single::type, Type::wrappedCodec);
    }

    public boolean matches(DataComponentGetter var1);

    public static interface Type<T extends DataComponentPredicate> {
        public static final Codec<Type<?>> CODEC = Codec.either(BuiltInRegistries.DATA_COMPONENT_PREDICATE_TYPE.byNameCodec(), BuiltInRegistries.DATA_COMPONENT_TYPE.byNameCodec()).xmap(Type::copyOrCreateType, Type::unpackType);
        public static final StreamCodec<RegistryFriendlyByteBuf, Type<?>> STREAM_CODEC = ByteBufCodecs.either(ByteBufCodecs.registry(Registries.DATA_COMPONENT_PREDICATE_TYPE), ByteBufCodecs.registry(Registries.DATA_COMPONENT_TYPE)).map(Type::copyOrCreateType, Type::unpackType);

        private static <T extends Type<?>> Either<T, DataComponentType<?>> unpackType(T var0) {
            Either either;
            if (var0 instanceof AnyValueType) {
                AnyValueType var1 = (AnyValueType)var0;
                either = Either.right(var1.componentType());
            } else {
                either = Either.left(var0);
            }
            return either;
        }

        private static Type<?> copyOrCreateType(Either<Type<?>, DataComponentType<?>> var02) {
            return (Type)var02.map(var0 -> var0, AnyValueType::create);
        }

        public Codec<T> codec();

        public MapCodec<Single<T>> wrappedCodec();

        public StreamCodec<RegistryFriendlyByteBuf, Single<T>> singleStreamCodec();
    }

    public record Single<T extends DataComponentPredicate>(Type<T> type, T predicate) {
        static <T extends DataComponentPredicate> MapCodec<Single<T>> wrapCodec(Type<T> var0, Codec<T> var1) {
            return RecordCodecBuilder.mapCodec(var2 -> var2.group((App)var1.fieldOf("value").forGetter(Single::predicate)).apply((Applicative)var2, var1 -> new Single<DataComponentPredicate>(var0, (DataComponentPredicate)var1)));
        }

        private static <T extends DataComponentPredicate> Single<T> fromEntry(Map.Entry<Type<?>, T> var0) {
            return new Single<DataComponentPredicate>(var0.getKey(), (DataComponentPredicate)var0.getValue());
        }
    }

    public static final class AnyValueType
    extends TypeBase<AnyValue> {
        private final AnyValue predicate;

        public AnyValueType(AnyValue var0) {
            super(MapCodec.unitCodec((Object)var0));
            this.predicate = var0;
        }

        public AnyValue predicate() {
            return this.predicate;
        }

        public DataComponentType<?> componentType() {
            return this.predicate.type();
        }

        public static AnyValueType create(DataComponentType<?> var0) {
            return new AnyValueType(new AnyValue(var0));
        }
    }

    public static final class ConcreteType<T extends DataComponentPredicate>
    extends TypeBase<T> {
        public ConcreteType(Codec<T> var0) {
            super(var0);
        }
    }

    public static abstract class TypeBase<T extends DataComponentPredicate>
    implements Type<T> {
        private final Codec<T> codec;
        private final MapCodec<Single<T>> wrappedCodec;
        private final StreamCodec<RegistryFriendlyByteBuf, Single<T>> singleStreamCodec;

        public TypeBase(Codec<T> var02) {
            this.codec = var02;
            this.wrappedCodec = Single.wrapCodec(this, var02);
            this.singleStreamCodec = ByteBufCodecs.fromCodecWithRegistries(var02).map(var0 -> new Single<DataComponentPredicate>(this, (DataComponentPredicate)var0), Single::predicate);
        }

        @Override
        public Codec<T> codec() {
            return this.codec;
        }

        @Override
        public MapCodec<Single<T>> wrappedCodec() {
            return this.wrappedCodec;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Single<T>> singleStreamCodec() {
            return this.singleStreamCodec;
        }
    }
}

