/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPos;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ShearsDispenseItemBehavior
extends OptionalDispenseItemBehavior {
    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack eventStack;
        DispenseItemBehavior idispensebehavior;
        ServerLevel worldserver = sourceblock.level();
        CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
        if (!DispenserBlock.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return itemstack;
        }
        if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != DispenseItemBehavior.NOOP && idispensebehavior != this) {
            idispensebehavior.dispense(sourceblock, eventStack);
            return itemstack;
        }
        if (!worldserver.isClientSide()) {
            BlockPos blockposition = sourceblock.pos().relative(sourceblock.state().getValue(DispenserBlock.FACING));
            this.setSuccess(ShearsDispenseItemBehavior.tryShearBeehive(worldserver, itemstack, blockposition) || ShearsDispenseItemBehavior.tryShearEntity(worldserver, blockposition, itemstack, bukkitBlock, craftItem));
            if (this.isSuccess()) {
                itemstack.hurtAndBreak(1, worldserver, null, item -> {});
            }
        }
        return itemstack;
    }

    private static boolean tryShearBeehive(ServerLevel worldserver, net.minecraft.world.item.ItemStack itemstack, BlockPos blockposition) {
        int i;
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        if (iblockdata.is(BlockTags.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BeehiveBlock.HONEY_LEVEL) && blockbase_blockdata.getBlock() instanceof BeehiveBlock) && (i = iblockdata.getValue(BeehiveBlock.HONEY_LEVEL).intValue()) >= 5) {
            worldserver.playSound((Entity)null, blockposition, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            BeehiveBlock.dropHoneycomb(worldserver, itemstack, iblockdata, worldserver.getBlockEntity(blockposition), null, blockposition);
            ((BeehiveBlock)iblockdata.getBlock()).releaseBeesAndResetHoneyLevel(worldserver, iblockdata, blockposition, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
            worldserver.gameEvent((Entity)null, GameEvent.SHEAR, blockposition);
            return true;
        }
        return false;
    }

    private static boolean tryShearEntity(ServerLevel worldserver, BlockPos blockposition, net.minecraft.world.item.ItemStack itemstack, Block bukkitBlock, CraftItemStack craftItem) {
        for (Entity entity : worldserver.getEntitiesOfClass(Entity.class, new AABB(blockposition), EntitySelector.NO_SPECTATORS)) {
            Shearable ishearable;
            if (entity.shearOffAllLeashConnections(null)) {
                return true;
            }
            if (!(entity instanceof Shearable) || !(ishearable = (Shearable)((Object)entity)).readyForShearing() || CraftEventFactory.callBlockShearEntityEvent(entity, bukkitBlock, craftItem).isCancelled()) continue;
            ishearable.shear(worldserver, SoundSource.BLOCKS, itemstack);
            worldserver.gameEvent((Entity)null, GameEvent.SHEAR, blockposition);
            return true;
        }
        return false;
    }
}

