/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.nio.file.Path;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;

public class PackOutput {
    private final Path outputFolder;

    public PackOutput(Path var0) {
        this.outputFolder = var0;
    }

    public Path getOutputFolder() {
        return this.outputFolder;
    }

    public Path getOutputFolder(Target var0) {
        return this.getOutputFolder().resolve(var0.directory);
    }

    public PathProvider createPathProvider(Target var0, String var1) {
        return new PathProvider(this, var0, var1);
    }

    public PathProvider createRegistryElementsPathProvider(ResourceKey<? extends Registry<?>> var0) {
        return this.createPathProvider(Target.DATA_PACK, Registries.elementsDirPath(var0));
    }

    public PathProvider createRegistryTagsPathProvider(ResourceKey<? extends Registry<?>> var0) {
        return this.createPathProvider(Target.DATA_PACK, Registries.tagsDirPath(var0));
    }

    public static enum Target {
        DATA_PACK("data"),
        RESOURCE_PACK("assets"),
        REPORTS("reports");

        final String directory;

        private Target(String var2) {
            this.directory = var2;
        }
    }

    public static class PathProvider {
        private final Path root;
        private final String kind;

        PathProvider(PackOutput var0, Target var1, String var2) {
            this.root = var0.getOutputFolder(var1);
            this.kind = var2;
        }

        public Path file(Identifier var0, String var1) {
            return this.root.resolve(var0.getNamespace()).resolve(this.kind).resolve(var0.getPath() + "." + var1);
        }

        public Path json(Identifier var0) {
            return this.root.resolve(var0.getNamespace()).resolve(this.kind).resolve(var0.getPath() + ".json");
        }

        public Path json(ResourceKey<?> var0) {
            return this.root.resolve(var0.identifier().getNamespace()).resolve(this.kind).resolve(var0.identifier().getPath() + ".json");
        }
    }
}

