/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;

public class GameTestBatchFactory {
    private static final int MAX_TESTS_PER_BATCH = 50;
    public static final TestDecorator DIRECT = (var0, var1) -> Stream.of(new GameTestInfo(var0, Rotation.NONE, var1, RetryOptions.noRetries()));

    public static List<GameTestBatch> divideIntoBatches(Collection<Holder.Reference<GameTestInstance>> var02, TestDecorator var1, ServerLevel var22) {
        Map<Holder, List<GameTestInfo>> var3 = var02.stream().flatMap(var2 -> var1.decorate((Holder.Reference<GameTestInstance>)var2, var22)).collect(Collectors.groupingBy(var0 -> var0.getTest().batch()));
        return var3.entrySet().stream().flatMap(var0 -> {
            Holder var12 = (Holder)var0.getKey();
            List var22 = (List)var0.getValue();
            return Streams.mapWithIndex(Lists.partition((List)var22, (int)50).stream(), (var1, var2) -> GameTestBatchFactory.toGameTestBatch(var1, var12, (int)var2));
        }).toList();
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo() {
        return GameTestBatchFactory.fromGameTestInfo(50);
    }

    public static GameTestRunner.GameTestBatcher fromGameTestInfo(int var0) {
        return var1 -> {
            Map<Holder, List<GameTestInfo>> var2 = var1.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(var0 -> var0.getTest().batch()));
            return var2.entrySet().stream().flatMap(var12 -> {
                Holder var22 = (Holder)var12.getKey();
                List var3 = (List)var12.getValue();
                return Streams.mapWithIndex(Lists.partition((List)var3, (int)var0).stream(), (var1, var2) -> GameTestBatchFactory.toGameTestBatch(List.copyOf(var1), var22, (int)var2));
            }).toList();
        };
    }

    public static GameTestBatch toGameTestBatch(Collection<GameTestInfo> var0, Holder<TestEnvironmentDefinition> var1, int var2) {
        return new GameTestBatch(var2, var0, var1);
    }

    @FunctionalInterface
    public static interface TestDecorator {
        public Stream<GameTestInfo> decorate(Holder.Reference<GameTestInstance> var1, ServerLevel var2);
    }
}

