/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestEvent;
import net.minecraft.gametest.framework.GameTestException;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.network.chat.Component;

public class GameTestSequence {
    final GameTestInfo parent;
    private final List<GameTestEvent> events = Lists.newArrayList();
    private int lastTick;

    GameTestSequence(GameTestInfo var0) {
        this.parent = var0;
        this.lastTick = var0.getTick();
    }

    public GameTestSequence thenWaitUntil(Runnable var0) {
        this.events.add(GameTestEvent.create(var0));
        return this;
    }

    public GameTestSequence thenWaitUntil(long var0, Runnable var2) {
        this.events.add(GameTestEvent.create(var0, var2));
        return this;
    }

    public GameTestSequence thenIdle(int var0) {
        return this.thenExecuteAfter(var0, () -> {});
    }

    public GameTestSequence thenExecute(Runnable var0) {
        this.events.add(GameTestEvent.create(() -> this.executeWithoutFail(var0)));
        return this;
    }

    public GameTestSequence thenExecuteAfter(int var0, Runnable var1) {
        this.events.add(GameTestEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + var0) {
                throw new GameTestAssertException(Component.translatable("test.error.sequence.not_completed"), this.parent.getTick());
            }
            this.executeWithoutFail(var1);
        }));
        return this;
    }

    public GameTestSequence thenExecuteFor(int var0, Runnable var1) {
        this.events.add(GameTestEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + var0) {
                this.executeWithoutFail(var1);
                throw new GameTestAssertException(Component.translatable("test.error.sequence.not_completed"), this.parent.getTick());
            }
        }));
        return this;
    }

    public void thenSucceed() {
        this.events.add(GameTestEvent.create(this.parent::succeed));
    }

    public void thenFail(Supplier<GameTestException> var0) {
        this.events.add(GameTestEvent.create(() -> this.parent.fail((GameTestException)var0.get())));
    }

    public Condition thenTrigger() {
        Condition var0 = new Condition();
        this.events.add(GameTestEvent.create(() -> var0.trigger(this.parent.getTick())));
        return var0;
    }

    public void tickAndContinue(int var0) {
        try {
            this.tick(var0);
        }
        catch (GameTestAssertException gameTestAssertException) {
            // empty catch block
        }
    }

    public void tickAndFailIfNotComplete(int var0) {
        try {
            this.tick(var0);
        }
        catch (GameTestAssertException var1) {
            this.parent.fail(var1);
        }
    }

    private void executeWithoutFail(Runnable var0) {
        try {
            var0.run();
        }
        catch (GameTestAssertException var1) {
            this.parent.fail(var1);
        }
    }

    private void tick(int var0) {
        Iterator<GameTestEvent> var1 = this.events.iterator();
        while (var1.hasNext()) {
            GameTestEvent var2 = var1.next();
            var2.assertion.run();
            var1.remove();
            int var3 = var0 - this.lastTick;
            int var4 = this.lastTick;
            this.lastTick = var0;
            if (var2.expectedDelay == null || var2.expectedDelay == (long)var3) continue;
            this.parent.fail(new GameTestAssertException(Component.translatable("test.error.sequence.invalid_tick", (long)var4 + var2.expectedDelay), var0));
            break;
        }
    }

    public class Condition {
        private static final int NOT_TRIGGERED = -1;
        private int triggerTime = -1;

        void trigger(int var0) {
            if (this.triggerTime != -1) {
                throw new IllegalStateException("Condition already triggered at " + this.triggerTime);
            }
            this.triggerTime = var0;
        }

        public void assertTriggeredThisTick() {
            int var0 = GameTestSequence.this.parent.getTick();
            if (this.triggerTime != var0) {
                if (this.triggerTime == -1) {
                    throw new GameTestAssertException(Component.translatable("test.error.sequence.condition_not_triggered"), var0);
                }
                throw new GameTestAssertException(Component.translatable("test.error.sequence.condition_already_triggered", this.triggerTime), var0);
            }
        }
    }
}

