/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public final class LongArrayTag
implements CollectionTag {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final TagType<LongArrayTag> TYPE = new TagType.VariableSize<LongArrayTag>(){

        @Override
        public LongArrayTag load(DataInput var0, NbtAccounter var1) throws IOException {
            return new LongArrayTag(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static long[] readAccounted(DataInput var0, NbtAccounter var1) throws IOException {
            var1.accountBytes(24L);
            int var2 = var0.readInt();
            var1.accountBytes(8L, var2);
            long[] var3 = new long[var2];
            for (int var4 = 0; var4 < var2; ++var4) {
                var3[var4] = var0.readLong();
            }
            return var3;
        }

        @Override
        public void skip(DataInput var0, NbtAccounter var1) throws IOException {
            var0.skipBytes(var0.readInt() * 8);
        }

        @Override
        public String getName() {
            return "LONG[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Long_Array";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private long[] data;

    public LongArrayTag(long[] var0) {
        this.data = var0;
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeInt(this.data.length);
        for (long var4 : this.data) {
            var0.writeLong(var4);
        }
    }

    @Override
    public int sizeInBytes() {
        return 24 + 8 * this.data.length;
    }

    @Override
    public byte getId() {
        return 12;
    }

    public TagType<LongArrayTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitLongArray(this);
        return var0.build();
    }

    @Override
    public LongArrayTag copy() {
        long[] var0 = new long[this.data.length];
        System.arraycopy(this.data, 0, var0, 0, this.data.length);
        return new LongArrayTag(var0);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof LongArrayTag && Arrays.equals(this.data, ((LongArrayTag)var0).data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitLongArray(this);
    }

    public long[] getAsLongArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public LongTag get(int var0) {
        return LongTag.valueOf(this.data[var0]);
    }

    @Override
    public boolean setTag(int var0, Tag var1) {
        if (var1 instanceof NumericTag) {
            NumericTag var2 = (NumericTag)var1;
            this.data[var0] = var2.longValue();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int var0, Tag var1) {
        if (var1 instanceof NumericTag) {
            NumericTag var2 = (NumericTag)var1;
            this.data = ArrayUtils.add((long[])this.data, (int)var0, (long)var2.longValue());
            return true;
        }
        return false;
    }

    @Override
    public LongTag remove(int var0) {
        long var1 = this.data[var0];
        this.data = ArrayUtils.remove((long[])this.data, (int)var0);
        return LongTag.valueOf(var1);
    }

    @Override
    public void clear() {
        this.data = new long[0];
    }

    @Override
    public Optional<long[]> asLongArray() {
        return Optional.of(this.data);
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag get(int n) {
        return this.get(n);
    }

    @Override
    public /* synthetic */ Tag remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

