/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public record ShortTag(short value) implements NumericTag
{
    private static final int SELF_SIZE_IN_BYTES = 10;
    public static final TagType<ShortTag> TYPE = new TagType.StaticSize<ShortTag>(){

        @Override
        public ShortTag load(DataInput var0, NbtAccounter var1) throws IOException {
            return ShortTag.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.ValueResult parse(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static short readAccounted(DataInput var0, NbtAccounter var1) throws IOException {
            var1.accountBytes(10L);
            return var0.readShort();
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public String getName() {
            return "SHORT";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Short";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };

    public static ShortTag valueOf(short var0) {
        if (var0 >= -128 && var0 <= 1024) {
            return Cache.cache[var0 - -128];
        }
        return new ShortTag(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeShort(this.value);
    }

    @Override
    public int sizeInBytes() {
        return 10;
    }

    @Override
    public byte getId() {
        return 2;
    }

    public TagType<ShortTag> getType() {
        return TYPE;
    }

    @Override
    public ShortTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitShort(this);
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public Number box() {
        return this.value;
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor var0) {
        return var0.visit(this.value);
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitShort(this);
        return var0.build();
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    static class Cache {
        private static final int HIGH = 1024;
        private static final int LOW = -128;
        static final ShortTag[] cache = new ShortTag[1153];

        private Cache() {
        }

        static {
            for (int var0 = 0; var0 < cache.length; ++var0) {
                Cache.cache[var0] = new ShortTag((short)(-128 + var0));
            }
        }
    }
}

