/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.visitors.CollectToTag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.FieldTree;

public class CollectFields
extends CollectToTag {
    private int fieldsToGetCount;
    private final Set<TagType<?>> wantedTypes;
    private final Deque<FieldTree> stack = new ArrayDeque<FieldTree>();

    public CollectFields(FieldSelector ... var0) {
        this.fieldsToGetCount = var0.length;
        ImmutableSet.Builder var1 = ImmutableSet.builder();
        FieldTree var2 = FieldTree.createRoot();
        for (FieldSelector var6 : var0) {
            var2.addEntry(var6);
            var1.add(var6.type());
        }
        this.stack.push(var2);
        var1.add(CompoundTag.TYPE);
        this.wantedTypes = var1.build();
    }

    @Override
    public StreamTagVisitor.ValueResult visitRootEntry(TagType<?> var0) {
        if (var0 != CompoundTag.TYPE) {
            return StreamTagVisitor.ValueResult.HALT;
        }
        return super.visitRootEntry(var0);
    }

    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> var0) {
        FieldTree var1 = this.stack.element();
        if (this.depth() > var1.depth()) {
            return super.visitEntry(var0);
        }
        if (this.fieldsToGetCount <= 0) {
            return StreamTagVisitor.EntryResult.BREAK;
        }
        if (!this.wantedTypes.contains(var0)) {
            return StreamTagVisitor.EntryResult.SKIP;
        }
        return super.visitEntry(var0);
    }

    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> var0, String var1) {
        FieldTree var3;
        FieldTree var2 = this.stack.element();
        if (this.depth() > var2.depth()) {
            return super.visitEntry(var0, var1);
        }
        if (var2.selectedFields().remove(var1, var0)) {
            --this.fieldsToGetCount;
            return super.visitEntry(var0, var1);
        }
        if (var0 == CompoundTag.TYPE && (var3 = var2.fieldsToRecurse().get(var1)) != null) {
            this.stack.push(var3);
            return super.visitEntry(var0, var1);
        }
        return StreamTagVisitor.EntryResult.SKIP;
    }

    @Override
    public StreamTagVisitor.ValueResult visitContainerEnd() {
        if (this.depth() == this.stack.element().depth()) {
            this.stack.pop();
        }
        return super.visitContainerEnd();
    }

    public int getMissingFieldCount() {
        return this.fieldsToGetCount;
    }
}

