/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import net.minecraft.SharedConstants;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.CipherDecoder;
import net.minecraft.network.CipherEncoder;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.CompressionDecoder;
import net.minecraft.network.CompressionEncoder;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.LocalFrameDecoder;
import net.minecraft.network.LocalFrameEncoder;
import net.minecraft.network.MonitoredLocalFrameDecoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipPacketException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.Varint21FrameDecoder;
import net.minecraft.network.Varint21LengthFieldPrepender;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.ServerHandshakePacketListener;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.status.ClientStatusPacketListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.network.EventLoopGroupHolder;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Connection
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float AVERAGE_PACKETS_SMOOTHING = 0.75f;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker ROOT_MARKER = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker PACKET_MARKER = Util.make(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), marker -> marker.add(ROOT_MARKER));
    public static final Marker PACKET_RECEIVED_MARKER = Util.make(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), marker -> marker.add(PACKET_MARKER));
    public static final Marker PACKET_SENT_MARKER = Util.make(MarkerFactory.getMarker((String)"PACKET_SENT"), marker -> marker.add(PACKET_MARKER));
    private static final ProtocolInfo<ServerHandshakePacketListener> INITIAL_PROTOCOL = HandshakeProtocols.SERVERBOUND;
    private final PacketFlow receiving;
    private volatile boolean sendLoginDisconnect = true;
    private final Queue<Consumer<Connection>> pendingActions = Queues.newConcurrentLinkedQueue();
    public Channel channel;
    public SocketAddress address;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    private volatile @Nullable PacketListener disconnectListener;
    private volatile @Nullable PacketListener packetListener;
    private @Nullable DisconnectionDetails disconnectionDetails;
    private boolean encrypted;
    private boolean disconnectionHandled;
    private int receivedPackets;
    private int sentPackets;
    private float averageReceivedPackets;
    private float averageSentPackets;
    private int tickCount;
    private boolean handlingFault;
    private volatile @Nullable DisconnectionDetails delayedDisconnect;
    @Nullable BandwidthDebugMonitor bandwidthDebugMonitor;
    public String hostname = "";

    public Connection(PacketFlow enumprotocoldirection) {
        this.receiving = enumprotocoldirection;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.channel = channelhandlercontext.channel();
        this.address = this.channel.remoteAddress();
        this.preparing = false;
        if (this.delayedDisconnect != null) {
            this.disconnect(this.delayedDisconnect);
        }
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.disconnect(Component.translatable("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        if (throwable instanceof SkipPacketException) {
            LOGGER.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.handlingFault;
            this.handlingFault = true;
            if (this.channel.isOpen()) {
                if (throwable instanceof TimeoutException) {
                    LOGGER.debug("Timeout", throwable);
                    this.disconnect(Component.translatable("disconnect.timeout"));
                } else {
                    MutableComponent ichatbasecomponent = Component.translatable("disconnect.genericReason", "Internal Exception: " + String.valueOf(throwable));
                    PacketListener packetlistener = this.packetListener;
                    DisconnectionDetails disconnectiondetails = packetlistener != null ? packetlistener.createDisconnectionInfo(ichatbasecomponent, throwable) : new DisconnectionDetails(ichatbasecomponent);
                    if (flag) {
                        LOGGER.debug("Failed to sent packet", throwable);
                        if (this.getSending() == PacketFlow.CLIENTBOUND) {
                            Packet packet = (Packet)((Object)(this.sendLoginDisconnect ? new ClientboundLoginDisconnectPacket(ichatbasecomponent) : new ClientboundDisconnectPacket(ichatbasecomponent)));
                            this.send(packet, PacketSendListener.thenRun(() -> this.disconnect(disconnectiondetails)));
                        } else {
                            this.disconnect(disconnectiondetails);
                        }
                        this.setReadOnly();
                    } else {
                        LOGGER.debug("Double fault", throwable);
                        this.disconnect(disconnectiondetails);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            throwable.printStackTrace();
        }
    }

    protected void channelRead0(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.channel.isOpen()) {
            PacketListener packetlistener = this.packetListener;
            if (packetlistener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (packetlistener.shouldHandleMessage(packet)) {
                try {
                    Connection.genericsFtw(packet, packetlistener);
                }
                catch (RunningOnDifferentThreadException runningOnDifferentThreadException) {
                }
                catch (RejectedExecutionException rejectedexecutionexception) {
                    this.disconnect(Component.translatable("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException classcastexception) {
                    LOGGER.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                    this.disconnect(Component.translatable("multiplayer.disconnect.invalid_packet"));
                }
                ++this.receivedPackets;
            }
        }
    }

    private static <T extends PacketListener> void genericsFtw(Packet<T> packet, PacketListener packetlistener) {
        packet.handle(packetlistener);
    }

    private void validateListener(ProtocolInfo<?> protocolinfo, PacketListener packetlistener) {
        Objects.requireNonNull(packetlistener, "packetListener");
        PacketFlow enumprotocoldirection = packetlistener.flow();
        if (enumprotocoldirection != this.receiving) {
            String s = String.valueOf((Object)this.receiving);
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + s + ", but listener is " + String.valueOf((Object)enumprotocoldirection));
        }
        ConnectionProtocol enumprotocol = packetlistener.protocol();
        if (protocolinfo.id() != enumprotocol) {
            String s1 = String.valueOf((Object)enumprotocol);
            throw new IllegalStateException("Listener protocol (" + s1 + ") does not match requested one " + String.valueOf(protocolinfo));
        }
    }

    private static void syncAfterConfigurationChange(ChannelFuture channelfuture) {
        try {
            channelfuture.syncUninterruptibly();
        }
        catch (Exception exception) {
            if (exception instanceof ClosedChannelException) {
                LOGGER.info("Connection closed during protocol change");
            }
            throw exception;
        }
    }

    public <T extends PacketListener> void setupInboundProtocol(ProtocolInfo<T> protocolinfo, T t0) {
        this.validateListener(protocolinfo, t0);
        if (protocolinfo.flow() != this.getReceiving()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)protocolinfo.id()));
        }
        this.packetListener = t0;
        this.disconnectListener = null;
        UnconfiguredPipelineHandler.InboundConfigurationTask unconfiguredpipelinehandler_b = UnconfiguredPipelineHandler.setupInboundProtocol(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.bundlerInfo();
        if (bundlerinfo != null) {
            PacketBundlePacker packetbundlepacker = new PacketBundlePacker(bundlerinfo);
            unconfiguredpipelinehandler_b = unconfiguredpipelinehandler_b.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("decoder", "bundler", (ChannelHandler)packetbundlepacker));
        }
        Connection.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)unconfiguredpipelinehandler_b));
    }

    public void setupOutboundProtocol(ProtocolInfo<?> protocolinfo) {
        if (protocolinfo.flow() != this.getSending()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)protocolinfo.id()));
        }
        UnconfiguredPipelineHandler.OutboundConfigurationTask unconfiguredpipelinehandler_d = UnconfiguredPipelineHandler.setupOutboundProtocol(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.bundlerInfo();
        if (bundlerinfo != null) {
            PacketBundleUnpacker packetbundleunpacker = new PacketBundleUnpacker(bundlerinfo);
            unconfiguredpipelinehandler_d = unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)packetbundleunpacker));
        }
        boolean flag = protocolinfo.id() == ConnectionProtocol.LOGIN;
        Connection.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> {
            this.sendLoginDisconnect = flag;
        })));
    }

    public void setListenerForServerboundHandshake(PacketListener packetlistener) {
        if (this.packetListener != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.receiving != PacketFlow.SERVERBOUND || packetlistener.flow() != PacketFlow.SERVERBOUND || packetlistener.protocol() != INITIAL_PROTOCOL.id()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.packetListener = packetlistener;
    }

    public void initiateServerboundStatusConnection(String s, int i, ClientStatusPacketListener packetstatusoutlistener) {
        this.initiateServerboundConnection(s, i, StatusProtocols.SERVERBOUND, StatusProtocols.CLIENTBOUND, packetstatusoutlistener, ClientIntent.STATUS);
    }

    public void initiateServerboundPlayConnection(String s, int i, ClientLoginPacketListener packetloginoutlistener) {
        this.initiateServerboundConnection(s, i, LoginProtocols.SERVERBOUND, LoginProtocols.CLIENTBOUND, packetloginoutlistener, ClientIntent.LOGIN);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundPlayConnection(String s, int i, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, boolean flag) {
        this.initiateServerboundConnection(s, i, protocolinfo, protocolinfo1, c0, flag ? ClientIntent.TRANSFER : ClientIntent.LOGIN);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundConnection(String s, int i, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, ClientIntent clientintent) {
        if (protocolinfo.id() != protocolinfo1.id()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.disconnectListener = c0;
        this.runOnceConnected(networkmanager -> {
            this.setupInboundProtocol(protocolinfo1, c0);
            networkmanager.sendPacket(new ClientIntentionPacket(SharedConstants.getCurrentVersion().protocolVersion(), s, i, clientintent), null, true);
            this.setupOutboundProtocol(protocolinfo);
        });
    }

    public void send(Packet<?> packet) {
        this.send(packet, null);
    }

    public void send(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener) {
        this.send(packet, channelfuturelistener, true);
    }

    public void send(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener, boolean flag) {
        if (this.isConnected()) {
            this.flushQueue();
            this.sendPacket(packet, channelfuturelistener, flag);
        } else {
            this.pendingActions.add(networkmanager -> networkmanager.sendPacket(packet, channelfuturelistener, flag));
        }
    }

    public void runOnceConnected(Consumer<Connection> consumer) {
        if (this.isConnected()) {
            this.flushQueue();
            consumer.accept(this);
        } else {
            this.pendingActions.add(consumer);
        }
    }

    private void sendPacket(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener, boolean flag) {
        ++this.sentPackets;
        if (this.channel.eventLoop().inEventLoop()) {
            this.doSendPacket(packet, channelfuturelistener, flag);
        } else {
            this.channel.eventLoop().execute(() -> this.doSendPacket(packet, channelfuturelistener, flag));
        }
    }

    private void doSendPacket(Packet<?> packet, @Nullable ChannelFutureListener channelfuturelistener, boolean flag) {
        if (channelfuturelistener != null) {
            ChannelFuture channelfuture = flag ? this.channel.writeAndFlush(packet) : this.channel.write(packet);
            channelfuture.addListener((GenericFutureListener)channelfuturelistener);
        } else if (flag) {
            this.channel.writeAndFlush(packet, this.channel.voidPromise());
        } else {
            this.channel.write(packet, this.channel.voidPromise());
        }
    }

    public void flushChannel() {
        if (this.isConnected()) {
            this.flush();
        } else {
            this.pendingActions.add(Connection::flush);
        }
    }

    private void flush() {
        if (this.channel.eventLoop().inEventLoop()) {
            this.channel.flush();
        } else {
            this.channel.eventLoop().execute(() -> this.channel.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushQueue() {
        if (this.channel != null && this.channel.isOpen()) {
            Queue<Consumer<Connection>> queue = this.pendingActions;
            synchronized (queue) {
                Consumer<Connection> consumer;
                while ((consumer = this.pendingActions.poll()) != null) {
                    consumer.accept(this);
                }
            }
        }
    }

    public void tick() {
        this.flushQueue();
        PacketListener packetlistener = this.packetListener;
        if (packetlistener instanceof TickablePacketListener) {
            TickablePacketListener tickablepacketlistener = (TickablePacketListener)packetlistener;
            tickablepacketlistener.tick();
        }
        if (!this.isConnected() && !this.disconnectionHandled) {
            this.handleDisconnection();
        }
        if (this.channel != null) {
            this.channel.flush();
        }
        if (this.tickCount++ % 20 == 0) {
            this.tickSecond();
        }
        if (this.bandwidthDebugMonitor != null) {
            this.bandwidthDebugMonitor.tick();
        }
    }

    protected void tickSecond() {
        this.averageSentPackets = Mth.lerp(0.75f, this.sentPackets, this.averageSentPackets);
        this.averageReceivedPackets = Mth.lerp(0.75f, this.receivedPackets, this.averageReceivedPackets);
        this.sentPackets = 0;
        this.receivedPackets = 0;
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public String getLoggableAddress(boolean flag) {
        return this.address == null ? "local" : (flag ? this.address.toString() : "IP hidden");
    }

    public void disconnect(Component ichatbasecomponent) {
        this.disconnect(new DisconnectionDetails(ichatbasecomponent));
    }

    public void disconnect(DisconnectionDetails disconnectiondetails) {
        this.preparing = false;
        if (this.channel == null) {
            this.delayedDisconnect = disconnectiondetails;
        }
        if (this.isConnected()) {
            this.channel.close();
            this.disconnectionDetails = disconnectiondetails;
        }
    }

    public boolean isMemoryConnection() {
        return this.channel instanceof LocalChannel || this.channel instanceof LocalServerChannel;
    }

    public PacketFlow getReceiving() {
        return this.receiving;
    }

    public PacketFlow getSending() {
        return this.receiving.getOpposite();
    }

    public static Connection connectToServer(InetSocketAddress inetsocketaddress, EventLoopGroupHolder eventloopgroupholder, @Nullable LocalSampleLogger localsamplelogger) {
        Connection networkmanager = new Connection(PacketFlow.CLIENTBOUND);
        if (localsamplelogger != null) {
            networkmanager.setBandwidthLogger(localsamplelogger);
        }
        ChannelFuture channelfuture = Connection.connect(inetsocketaddress, eventloopgroupholder, networkmanager);
        channelfuture.syncUninterruptibly();
        return networkmanager;
    }

    public static ChannelFuture connect(InetSocketAddress inetsocketaddress, EventLoopGroupHolder eventloopgroupholder, final Connection networkmanager) {
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventloopgroupholder.eventLoopGroup())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                Connection.configureSerialization(channelpipeline, PacketFlow.CLIENTBOUND, false, networkmanager.bandwidthDebugMonitor);
                networkmanager.configurePacketHandler(channelpipeline);
            }
        })).channel(eventloopgroupholder.channelCls())).connect(inetsocketaddress.getAddress(), inetsocketaddress.getPort());
    }

    private static String outboundHandlerName(boolean flag) {
        return flag ? "encoder" : "outbound_config";
    }

    private static String inboundHandlerName(boolean flag) {
        return flag ? "decoder" : "inbound_config";
    }

    public void configurePacketHandler(ChannelPipeline channelpipeline) {
        channelpipeline.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext channelhandlercontext, Object object, ChannelPromise channelpromise) throws Exception {
                super.write(channelhandlercontext, object, channelpromise);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void configureSerialization(ChannelPipeline channelpipeline, PacketFlow enumprotocoldirection, boolean flag, @Nullable BandwidthDebugMonitor bandwidthdebugmonitor) {
        PacketFlow enumprotocoldirection1 = enumprotocoldirection.getOpposite();
        boolean flag1 = enumprotocoldirection == PacketFlow.SERVERBOUND;
        boolean flag2 = enumprotocoldirection1 == PacketFlow.SERVERBOUND;
        channelpipeline.addLast("splitter", (ChannelHandler)Connection.createFrameDecoder(bandwidthdebugmonitor, flag)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(Connection.inboundHandlerName(flag1), flag1 ? new PacketDecoder<ServerHandshakePacketListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.Inbound()).addLast("prepender", (ChannelHandler)Connection.createFrameEncoder(flag)).addLast(Connection.outboundHandlerName(flag2), flag2 ? new PacketEncoder<ServerHandshakePacketListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.Outbound());
    }

    private static ChannelOutboundHandler createFrameEncoder(boolean flag) {
        return flag ? new LocalFrameEncoder() : new Varint21LengthFieldPrepender();
    }

    private static ChannelInboundHandler createFrameDecoder(@Nullable BandwidthDebugMonitor bandwidthdebugmonitor, boolean flag) {
        return !flag ? new Varint21FrameDecoder(bandwidthdebugmonitor) : (bandwidthdebugmonitor != null ? new MonitoredLocalFrameDecoder(bandwidthdebugmonitor) : new LocalFrameDecoder());
    }

    public static void configureInMemoryPipeline(ChannelPipeline channelpipeline, PacketFlow enumprotocoldirection) {
        Connection.configureSerialization(channelpipeline, enumprotocoldirection, true, null);
    }

    public static Connection connectToLocalServer(SocketAddress socketaddress) {
        final Connection networkmanager = new Connection(PacketFlow.CLIENTBOUND);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(EventLoopGroupHolder.local().eventLoopGroup())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline channelpipeline = channel.pipeline();
                Connection.configureInMemoryPipeline(channelpipeline, PacketFlow.CLIENTBOUND);
                networkmanager.configurePacketHandler(channelpipeline);
            }
        })).channel(EventLoopGroupHolder.local().channelCls())).connect(socketaddress).syncUninterruptibly();
        return networkmanager;
    }

    public void setEncryptionKey(Cipher cipher, Cipher cipher1) {
        this.encrypted = true;
        this.channel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new CipherDecoder(cipher));
        this.channel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new CipherEncoder(cipher1));
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen();
    }

    public boolean isConnecting() {
        return this.channel == null;
    }

    public @Nullable PacketListener getPacketListener() {
        return this.packetListener;
    }

    public @Nullable DisconnectionDetails getDisconnectionDetails() {
        return this.disconnectionDetails;
    }

    public void setReadOnly() {
        if (this.channel != null) {
            this.channel.config().setAutoRead(false);
        }
    }

    public void setupCompression(int i, boolean flag) {
        if (i >= 0) {
            ChannelHandler channelhandler = this.channel.pipeline().get("decompress");
            if (channelhandler instanceof CompressionDecoder) {
                CompressionDecoder packetdecompressor = (CompressionDecoder)channelhandler;
                packetdecompressor.setThreshold(i, flag);
            } else {
                this.channel.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new CompressionDecoder(i, flag));
            }
            channelhandler = this.channel.pipeline().get("compress");
            if (channelhandler instanceof CompressionEncoder) {
                CompressionEncoder packetcompressor = (CompressionEncoder)channelhandler;
                packetcompressor.setThreshold(i);
            } else {
                this.channel.pipeline().addAfter("prepender", "compress", (ChannelHandler)new CompressionEncoder(i));
            }
        } else {
            if (this.channel.pipeline().get("decompress") instanceof CompressionDecoder) {
                this.channel.pipeline().remove("decompress");
            }
            if (this.channel.pipeline().get("compress") instanceof CompressionEncoder) {
                this.channel.pipeline().remove("compress");
            }
        }
    }

    public void handleDisconnection() {
        if (this.channel != null && !this.channel.isOpen()) {
            if (this.disconnectionHandled) {
                LOGGER.warn("handleDisconnection() called twice");
            } else {
                PacketListener packetlistener1;
                this.disconnectionHandled = true;
                PacketListener packetlistener = this.getPacketListener();
                PacketListener packetListener = packetlistener1 = packetlistener != null ? packetlistener : this.disconnectListener;
                if (packetlistener1 != null) {
                    DisconnectionDetails disconnectiondetails = Objects.requireNonNullElseGet(this.getDisconnectionDetails(), () -> new DisconnectionDetails(Component.translatable("multiplayer.disconnect.generic")));
                    packetlistener1.onDisconnect(disconnectiondetails);
                }
                this.pendingActions.clear();
            }
        }
    }

    public float getAverageReceivedPackets() {
        return this.averageReceivedPackets;
    }

    public float getAverageSentPackets() {
        return this.averageSentPackets;
    }

    public void setBandwidthLogger(LocalSampleLogger localsamplelogger) {
        this.bandwidthDebugMonitor = new BandwidthDebugMonitor(localsamplelogger);
    }
}

