/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ObjectContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;

public class ComponentSerialization {
    public static final Codec<Component> CODEC = Codec.recursive((String)"Component", ComponentSerialization::createCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> OPTIONAL_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> TRUSTED_STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistriesTrusted(CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> TRUSTED_OPTIONAL_STREAM_CODEC = TRUSTED_STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<ByteBuf, Component> TRUSTED_CONTEXT_FREE_STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC);

    public static Codec<Component> flatRestrictedCodec(final int var0) {
        return new Codec<Component>(){

            public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> var02, T var1) {
                return CODEC.decode(var02, var1).flatMap(var2 -> {
                    if (this.isTooLarge(var02, (Component)var2.getFirst())) {
                        return DataResult.error(() -> "Component was too large: greater than max size " + var0);
                    }
                    return DataResult.success((Object)var2);
                });
            }

            public <T> DataResult<T> encode(Component var02, DynamicOps<T> var1, T var2) {
                return CODEC.encodeStart(var1, (Object)var02);
            }

            private <T> boolean isTooLarge(DynamicOps<T> var02, Component var1) {
                DataResult var2 = CODEC.encodeStart(1.asJsonOps(var02), (Object)var1);
                return var2.isSuccess() && GsonHelper.encodesLongerThan((JsonElement)var2.getOrThrow(), var0);
            }

            private static <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> var02) {
                if (var02 instanceof RegistryOps) {
                    RegistryOps var1 = (RegistryOps)var02;
                    return var1.withParent(JsonOps.INSTANCE);
                }
                return JsonOps.INSTANCE;
            }

            public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                return this.encode((Component)object, dynamicOps, object2);
            }
        };
    }

    private static MutableComponent createFromList(List<Component> var0) {
        MutableComponent var1 = var0.get(0).copy();
        for (int var2 = 1; var2 < var0.size(); ++var2) {
            var1.append(var0.get(var2));
        }
        return var1;
    }

    public static <T> MapCodec<T> createLegacyComponentMatcher(ExtraCodecs.LateBoundIdMapper<String, MapCodec<? extends T>> var02, Function<T, MapCodec<? extends T>> var1, String var2) {
        FuzzyCodec<? extends T> var3 = new FuzzyCodec<T>(var02.values(), var1);
        MapCodec var4 = var02.codec((Codec<String>)Codec.STRING).dispatchMap(var2, var1, var0 -> var0);
        StrictEither<? extends T> var5 = new StrictEither<T>(var2, var4, var3);
        return ExtraCodecs.orCompressed(var5, var4);
    }

    private static Codec<Component> createCodec(Codec<Component> var03) {
        ExtraCodecs.LateBoundIdMapper var1 = new ExtraCodecs.LateBoundIdMapper();
        ComponentSerialization.bootstrap(var1);
        MapCodec<ComponentContents> var22 = ComponentSerialization.createLegacyComponentMatcher(var1, ComponentContents::codec, "type");
        Codec var3 = RecordCodecBuilder.create(var2 -> var2.group((App)var22.forGetter(Component::getContents), (App)ExtraCodecs.nonEmptyList(var03.listOf()).optionalFieldOf("extra", List.of()).forGetter(Component::getSiblings), (App)Style.Serializer.MAP_CODEC.forGetter(Component::getStyle)).apply((Applicative)var2, MutableComponent::new));
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.nonEmptyList(var03.listOf())), (Codec)var3).xmap(var02 -> (Component)var02.map(var0 -> (Component)var0.map(Component::literal, ComponentSerialization::createFromList), var0 -> var0), var0 -> {
            String var1 = var0.tryCollapseToString();
            return var1 != null ? Either.left((Object)Either.left((Object)var1)) : Either.right((Object)var0);
        });
    }

    private static void bootstrap(ExtraCodecs.LateBoundIdMapper<String, MapCodec<? extends ComponentContents>> var0) {
        var0.put("text", PlainTextContents.MAP_CODEC);
        var0.put("translatable", TranslatableContents.MAP_CODEC);
        var0.put("keybind", KeybindContents.MAP_CODEC);
        var0.put("score", ScoreContents.MAP_CODEC);
        var0.put("selector", SelectorContents.MAP_CODEC);
        var0.put("nbt", NbtContents.MAP_CODEC);
        var0.put("object", ObjectContents.MAP_CODEC);
    }

    static class FuzzyCodec<T>
    extends MapCodec<T> {
        private final Collection<MapCodec<? extends T>> codecs;
        private final Function<T, ? extends MapEncoder<? extends T>> encoderGetter;

        public FuzzyCodec(Collection<MapCodec<? extends T>> var0, Function<T, ? extends MapEncoder<? extends T>> var1) {
            this.codecs = var0;
            this.encoderGetter = var1;
        }

        public <S> DataResult<T> decode(DynamicOps<S> var0, MapLike<S> var1) {
            for (MapDecoder mapDecoder : this.codecs) {
                DataResult var4 = mapDecoder.decode(var0, var1);
                if (!var4.result().isPresent()) continue;
                return var4;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T var0, DynamicOps<S> var1, RecordBuilder<S> var2) {
            MapEncoder<? extends T> var3 = this.encoderGetter.apply(var0);
            return var3.encode(var0, var1, var2);
        }

        public <S> Stream<S> keys(DynamicOps<S> var0) {
            return this.codecs.stream().flatMap(var1 -> var1.keys(var0)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + String.valueOf(this.codecs) + "]";
        }
    }

    static class StrictEither<T>
    extends MapCodec<T> {
        private final String typeFieldName;
        private final MapCodec<T> typed;
        private final MapCodec<T> fuzzy;

        public StrictEither(String var0, MapCodec<T> var1, MapCodec<T> var2) {
            this.typeFieldName = var0;
            this.typed = var1;
            this.fuzzy = var2;
        }

        public <O> DataResult<T> decode(DynamicOps<O> var0, MapLike<O> var1) {
            if (var1.get(this.typeFieldName) != null) {
                return this.typed.decode(var0, var1);
            }
            return this.fuzzy.decode(var0, var1);
        }

        public <O> RecordBuilder<O> encode(T var0, DynamicOps<O> var1, RecordBuilder<O> var2) {
            return this.fuzzy.encode(var0, var1, var2);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> var0) {
            return Stream.concat(this.typed.keys(var0), this.fuzzy.keys(var0)).distinct();
        }
    }
}

