/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;
import org.jspecify.annotations.Nullable;

public record MessageSignature(byte[] bytes) {
    public static final Codec<MessageSignature> CODEC = ExtraCodecs.BASE64_STRING.xmap(MessageSignature::new, MessageSignature::bytes);
    public static final int BYTES = 256;

    public MessageSignature {
        Preconditions.checkState((var0.length == 256 ? 1 : 0) != 0, (Object)"Invalid message signature size");
    }

    public static MessageSignature read(FriendlyByteBuf var0) {
        byte[] var1 = new byte[256];
        var0.readBytes(var1);
        return new MessageSignature(var1);
    }

    public static void write(FriendlyByteBuf var0, MessageSignature var1) {
        var0.writeBytes(var1.bytes);
    }

    public boolean verify(SignatureValidator var0, SignatureUpdater var1) {
        return var0.validate(var1, this.bytes);
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.bytes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object var0) {
        if (this == var0) return true;
        if (!(var0 instanceof MessageSignature)) return false;
        MessageSignature var1 = (MessageSignature)var0;
        if (!Arrays.equals(this.bytes, var1.bytes)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    public static String describe(@Nullable MessageSignature var0) {
        if (var0 == null) {
            return "<no signature>";
        }
        return var0.toString();
    }

    public Packed pack(MessageSignatureCache var0) {
        int var1 = var0.pack(this);
        return var1 != -1 ? new Packed(var1) : new Packed(this);
    }

    public int checksum() {
        return Arrays.hashCode(this.bytes);
    }

    public record Packed(int id, @Nullable MessageSignature fullSignature) {
        public static final int FULL_SIGNATURE = -1;

        public Packed(MessageSignature var0) {
            this(-1, var0);
        }

        public Packed(int var0) {
            this(var0, null);
        }

        public static Packed read(FriendlyByteBuf var0) {
            int var1 = var0.readVarInt() - 1;
            if (var1 == -1) {
                return new Packed(MessageSignature.read(var0));
            }
            return new Packed(var1);
        }

        public static void write(FriendlyByteBuf var0, Packed var1) {
            var0.writeVarInt(var1.id() + 1);
            if (var1.fullSignature() != null) {
                MessageSignature.write(var0, var1.fullSignature());
            }
        }

        public Optional<MessageSignature> unpack(MessageSignatureCache var0) {
            if (this.fullSignature != null) {
                return Optional.of(this.fullSignature);
            }
            return Optional.ofNullable(var0.unpack(this.id));
        }
    }
}

