/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jspecify.annotations.Nullable;

public final class MutableComponent
implements Component {
    private final ComponentContents contents;
    private final List<Component> siblings;
    private Style style;
    private FormattedCharSequence visualOrderText = FormattedCharSequence.EMPTY;
    private @Nullable Language decomposedWith;

    MutableComponent(ComponentContents var0, List<Component> var1, Style var2) {
        this.contents = var0;
        this.siblings = var1;
        this.style = var2;
    }

    public static MutableComponent create(ComponentContents var0) {
        return new MutableComponent(var0, Lists.newArrayList(), Style.EMPTY);
    }

    @Override
    public ComponentContents getContents() {
        return this.contents;
    }

    @Override
    public List<Component> getSiblings() {
        return this.siblings;
    }

    public MutableComponent setStyle(Style var0) {
        this.style = var0;
        return this;
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    public MutableComponent append(String var0) {
        if (var0.isEmpty()) {
            return this;
        }
        return this.append(Component.literal(var0));
    }

    public MutableComponent append(Component var0) {
        this.siblings.add(var0);
        return this;
    }

    public MutableComponent withStyle(UnaryOperator<Style> var0) {
        this.setStyle((Style)var0.apply(this.getStyle()));
        return this;
    }

    public MutableComponent withStyle(Style var0) {
        this.setStyle(var0.applyTo(this.getStyle()));
        return this;
    }

    public MutableComponent withStyle(ChatFormatting ... var0) {
        this.setStyle(this.getStyle().applyFormats(var0));
        return this;
    }

    public MutableComponent withStyle(ChatFormatting var0) {
        this.setStyle(this.getStyle().applyFormat(var0));
        return this;
    }

    public MutableComponent withColor(int var0) {
        this.setStyle(this.getStyle().withColor(var0));
        return this;
    }

    public MutableComponent withoutShadow() {
        this.setStyle(this.getStyle().withoutShadow());
        return this;
    }

    @Override
    public FormattedCharSequence getVisualOrderText() {
        Language var0 = Language.getInstance();
        if (this.decomposedWith != var0) {
            this.visualOrderText = var0.getVisualOrder(this);
            this.decomposedWith = var0;
        }
        return this.visualOrderText;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof MutableComponent)) return false;
        MutableComponent var1 = (MutableComponent)var0;
        if (!this.contents.equals(var1.contents)) return false;
        if (!this.style.equals(var1.style)) return false;
        if (!this.siblings.equals(var1.siblings)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = 1;
        var0 = 31 * var0 + this.contents.hashCode();
        var0 = 31 * var0 + this.style.hashCode();
        var0 = 31 * var0 + this.siblings.hashCode();
        return var0;
    }

    public String toString() {
        boolean var2;
        StringBuilder var0 = new StringBuilder(this.contents.toString());
        boolean var1 = !this.style.isEmpty();
        boolean bl = var2 = !this.siblings.isEmpty();
        if (var1 || var2) {
            var0.append('[');
            if (var1) {
                var0.append("style=");
                var0.append(this.style);
            }
            if (var1 && var2) {
                var0.append(", ");
            }
            if (var2) {
                var0.append("siblings=");
                var0.append(this.siblings);
            }
            var0.append(']');
        }
        return var0.toString();
    }
}

