/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.NbtPredicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;

public record EntityDataSource(String selectorPattern, @Nullable EntitySelector compiledSelector) implements DataSource
{
    public static final MapCodec<EntityDataSource> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("entity").forGetter(EntityDataSource::selectorPattern)).apply((Applicative)var0, EntityDataSource::new));

    public EntityDataSource(String var0) {
        this(var0, EntityDataSource.compileSelector(var0));
    }

    private static @Nullable EntitySelector compileSelector(String var0) {
        try {
            EntitySelectorParser var1 = new EntitySelectorParser(new StringReader(var0), true);
            return var1.parse();
        }
        catch (CommandSyntaxException var1) {
            return null;
        }
    }

    @Override
    public Stream<CompoundTag> getData(CommandSourceStack var0) throws CommandSyntaxException {
        if (this.compiledSelector != null) {
            List<? extends Entity> var1 = this.compiledSelector.findEntities(var0);
            return var1.stream().map(NbtPredicate::getEntityTagToCompare);
        }
        return Stream.empty();
    }

    public MapCodec<EntityDataSource> codec() {
        return MAP_CODEC;
    }

    @Override
    public String toString() {
        return "entity=" + this.selectorPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof EntityDataSource)) return false;
        EntityDataSource var1 = (EntityDataSource)var0;
        if (!this.selectorPattern.equals(var1.selectorPattern)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.selectorPattern.hashCode();
    }
}

