/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.List;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jspecify.annotations.Nullable;

public class ClientboundLightUpdatePacketData {
    private static final StreamCodec<ByteBuf, byte[]> DATA_LAYER_STREAM_CODEC = ByteBufCodecs.byteArray(2048);
    private final BitSet skyYMask;
    private final BitSet blockYMask;
    private final BitSet emptySkyYMask;
    private final BitSet emptyBlockYMask;
    private final List<byte[]> skyUpdates;
    private final List<byte[]> blockUpdates;

    public ClientboundLightUpdatePacketData(ChunkPos var0, LevelLightEngine var1, @Nullable BitSet var2, @Nullable BitSet var3) {
        this.skyYMask = new BitSet();
        this.blockYMask = new BitSet();
        this.emptySkyYMask = new BitSet();
        this.emptyBlockYMask = new BitSet();
        this.skyUpdates = Lists.newArrayList();
        this.blockUpdates = Lists.newArrayList();
        for (int var4 = 0; var4 < var1.getLightSectionCount(); ++var4) {
            if (var2 == null || var2.get(var4)) {
                this.prepareSectionData(var0, var1, LightLayer.SKY, var4, this.skyYMask, this.emptySkyYMask, this.skyUpdates);
            }
            if (var3 != null && !var3.get(var4)) continue;
            this.prepareSectionData(var0, var1, LightLayer.BLOCK, var4, this.blockYMask, this.emptyBlockYMask, this.blockUpdates);
        }
    }

    public ClientboundLightUpdatePacketData(FriendlyByteBuf var0, int var1, int var2) {
        this.skyYMask = var0.readBitSet();
        this.blockYMask = var0.readBitSet();
        this.emptySkyYMask = var0.readBitSet();
        this.emptyBlockYMask = var0.readBitSet();
        this.skyUpdates = var0.readList(DATA_LAYER_STREAM_CODEC);
        this.blockUpdates = var0.readList(DATA_LAYER_STREAM_CODEC);
    }

    public void write(FriendlyByteBuf var0) {
        var0.writeBitSet(this.skyYMask);
        var0.writeBitSet(this.blockYMask);
        var0.writeBitSet(this.emptySkyYMask);
        var0.writeBitSet(this.emptyBlockYMask);
        var0.writeCollection(this.skyUpdates, DATA_LAYER_STREAM_CODEC);
        var0.writeCollection(this.blockUpdates, DATA_LAYER_STREAM_CODEC);
    }

    private void prepareSectionData(ChunkPos var0, LevelLightEngine var1, LightLayer var2, int var3, BitSet var4, BitSet var5, List<byte[]> var6) {
        DataLayer var7 = var1.getLayerListener(var2).getDataLayerData(SectionPos.of(var0, var1.getMinLightSection() + var3));
        if (var7 != null) {
            if (var7.isEmpty()) {
                var5.set(var3);
            } else {
                var4.set(var3);
                var6.add(var7.copy().getData());
            }
        }
    }

    public BitSet getSkyYMask() {
        return this.skyYMask;
    }

    public BitSet getEmptySkyYMask() {
        return this.emptySkyYMask;
    }

    public List<byte[]> getSkyUpdates() {
        return this.skyUpdates;
    }

    public BitSet getBlockYMask() {
        return this.blockYMask;
    }

    public BitSet getEmptyBlockYMask() {
        return this.emptyBlockYMask;
    }

    public List<byte[]> getBlockUpdates() {
        return this.blockUpdates;
    }
}

