/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import org.jspecify.annotations.Nullable;

public record ClientboundPlayerChatPacket(int globalIndex, UUID sender, int index, @Nullable MessageSignature signature, SignedMessageBody.Packed body, @Nullable Component unsignedContent, FilterMask filterMask, ChatType.Bound chatType) implements Packet<ClientGamePacketListener>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundPlayerChatPacket> STREAM_CODEC = Packet.codec(ClientboundPlayerChatPacket::write, ClientboundPlayerChatPacket::new);

    private ClientboundPlayerChatPacket(RegistryFriendlyByteBuf var0) {
        this(var0.readVarInt(), var0.readUUID(), var0.readVarInt(), var0.readNullable(MessageSignature::read), new SignedMessageBody.Packed(var0), FriendlyByteBuf.readNullable(var0, ComponentSerialization.TRUSTED_STREAM_CODEC), FilterMask.read(var0), (ChatType.Bound)ChatType.Bound.STREAM_CODEC.decode(var0));
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.globalIndex);
        var0.writeUUID(this.sender);
        var0.writeVarInt(this.index);
        var0.writeNullable(this.signature, MessageSignature::write);
        this.body.write(var0);
        FriendlyByteBuf.writeNullable(var0, this.unsignedContent, ComponentSerialization.TRUSTED_STREAM_CODEC);
        FilterMask.write(var0, this.filterMask);
        ChatType.Bound.STREAM_CODEC.encode(var0, this.chatType);
    }

    @Override
    public PacketType<ClientboundPlayerChatPacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_CHAT;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handlePlayerChat(this);
    }

    @Override
    public boolean isSkippable() {
        return true;
    }
}

