/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class ClientboundPlayerLookAtPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundPlayerLookAtPacket> STREAM_CODEC = Packet.codec(ClientboundPlayerLookAtPacket::write, ClientboundPlayerLookAtPacket::new);
    private final double x;
    private final double y;
    private final double z;
    private final int entity;
    private final EntityAnchorArgument.Anchor fromAnchor;
    private final EntityAnchorArgument.Anchor toAnchor;
    private final boolean atEntity;

    public ClientboundPlayerLookAtPacket(EntityAnchorArgument.Anchor var0, double var1, double var3, double var5) {
        this.fromAnchor = var0;
        this.x = var1;
        this.y = var3;
        this.z = var5;
        this.entity = 0;
        this.atEntity = false;
        this.toAnchor = null;
    }

    public ClientboundPlayerLookAtPacket(EntityAnchorArgument.Anchor var0, Entity var1, EntityAnchorArgument.Anchor var2) {
        this.fromAnchor = var0;
        this.entity = var1.getId();
        this.toAnchor = var2;
        Vec3 var3 = var2.apply(var1);
        this.x = var3.x;
        this.y = var3.y;
        this.z = var3.z;
        this.atEntity = true;
    }

    private ClientboundPlayerLookAtPacket(FriendlyByteBuf var0) {
        this.fromAnchor = var0.readEnum(EntityAnchorArgument.Anchor.class);
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.atEntity = var0.readBoolean();
        if (this.atEntity) {
            this.entity = var0.readVarInt();
            this.toAnchor = var0.readEnum(EntityAnchorArgument.Anchor.class);
        } else {
            this.entity = 0;
            this.toAnchor = null;
        }
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeEnum(this.fromAnchor);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeBoolean(this.atEntity);
        if (this.atEntity) {
            var0.writeVarInt(this.entity);
            var0.writeEnum(this.toAnchor);
        }
    }

    @Override
    public PacketType<ClientboundPlayerLookAtPacket> type() {
        return GamePacketTypes.CLIENTBOUND_PLAYER_LOOK_AT;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleLookAt(this);
    }

    public EntityAnchorArgument.Anchor getFromAnchor() {
        return this.fromAnchor;
    }

    public @Nullable Vec3 getPosition(Level var0) {
        if (this.atEntity) {
            Entity var1 = var0.getEntity(this.entity);
            if (var1 == null) {
                return new Vec3(this.x, this.y, this.z);
            }
            return this.toAnchor.apply(var1);
        }
        return new Vec3(this.x, this.y, this.z);
    }
}

