/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class ClientboundSectionBlocksUpdatePacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundSectionBlocksUpdatePacket> STREAM_CODEC = Packet.codec(ClientboundSectionBlocksUpdatePacket::write, ClientboundSectionBlocksUpdatePacket::new);
    private static final int POS_IN_SECTION_BITS = 12;
    private final SectionPos sectionPos;
    private final short[] positions;
    private final BlockState[] states;

    public ClientboundSectionBlocksUpdatePacket(SectionPos sectionposition, ShortSet shortset, LevelChunkSection chunksection) {
        this.sectionPos = sectionposition;
        int i = shortset.size();
        this.positions = new short[i];
        this.states = new BlockState[i];
        int j = 0;
        ShortIterator shortiterator = shortset.iterator();
        while (shortiterator.hasNext()) {
            short short0;
            this.positions[j] = short0 = shortiterator.next().shortValue();
            this.states[j] = chunksection != null ? chunksection.getBlockState(SectionPos.sectionRelativeX(short0), SectionPos.sectionRelativeY(short0), SectionPos.sectionRelativeZ(short0)) : Blocks.AIR.defaultBlockState();
            ++j;
        }
    }

    public ClientboundSectionBlocksUpdatePacket(SectionPos sectionposition, ShortSet shortset, BlockState[] states) {
        this.sectionPos = sectionposition;
        this.positions = shortset.toShortArray();
        this.states = states;
    }

    private ClientboundSectionBlocksUpdatePacket(FriendlyByteBuf packetdataserializer) {
        this.sectionPos = (SectionPos)SectionPos.STREAM_CODEC.decode(packetdataserializer);
        int i = packetdataserializer.readVarInt();
        this.positions = new short[i];
        this.states = new BlockState[i];
        for (int j = 0; j < i; ++j) {
            long k = packetdataserializer.readVarLong();
            this.positions[j] = (short)(k & 0xFFFL);
            this.states[j] = Block.BLOCK_STATE_REGISTRY.byId((int)(k >>> 12));
        }
    }

    private void write(FriendlyByteBuf packetdataserializer) {
        SectionPos.STREAM_CODEC.encode(packetdataserializer, this.sectionPos);
        packetdataserializer.writeVarInt(this.positions.length);
        for (int i = 0; i < this.positions.length; ++i) {
            packetdataserializer.writeVarLong((long)Block.getId(this.states[i]) << 12 | (long)this.positions[i]);
        }
    }

    @Override
    public PacketType<ClientboundSectionBlocksUpdatePacket> type() {
        return GamePacketTypes.CLIENTBOUND_SECTION_BLOCKS_UPDATE;
    }

    @Override
    public void handle(ClientGamePacketListener packetlistenerplayout) {
        packetlistenerplayout.handleChunkBlocksUpdate(this);
    }

    public void runUpdates(BiConsumer<BlockPos, BlockState> biconsumer) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (int i = 0; i < this.positions.length; ++i) {
            short short0 = this.positions[i];
            blockposition_mutableblockposition.set(this.sectionPos.relativeToBlockX(short0), this.sectionPos.relativeToBlockY(short0), this.sectionPos.relativeToBlockZ(short0));
            biconsumer.accept(blockposition_mutableblockposition, this.states[i]);
        }
    }
}

