/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundSource;
import org.jspecify.annotations.Nullable;

public class ClientboundStopSoundPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundStopSoundPacket> STREAM_CODEC = Packet.codec(ClientboundStopSoundPacket::write, ClientboundStopSoundPacket::new);
    private static final int HAS_SOURCE = 1;
    private static final int HAS_SOUND = 2;
    private final @Nullable Identifier name;
    private final @Nullable SoundSource source;

    public ClientboundStopSoundPacket(@Nullable Identifier var0, @Nullable SoundSource var1) {
        this.name = var0;
        this.source = var1;
    }

    private ClientboundStopSoundPacket(FriendlyByteBuf var0) {
        byte var1 = var0.readByte();
        this.source = (var1 & 1) > 0 ? var0.readEnum(SoundSource.class) : null;
        this.name = (var1 & 2) > 0 ? var0.readIdentifier() : null;
    }

    private void write(FriendlyByteBuf var0) {
        if (this.source != null) {
            if (this.name != null) {
                var0.writeByte(3);
                var0.writeEnum(this.source);
                var0.writeIdentifier(this.name);
            } else {
                var0.writeByte(1);
                var0.writeEnum(this.source);
            }
        } else if (this.name != null) {
            var0.writeByte(2);
            var0.writeIdentifier(this.name);
        } else {
            var0.writeByte(0);
        }
    }

    @Override
    public PacketType<ClientboundStopSoundPacket> type() {
        return GamePacketTypes.CLIENTBOUND_STOP_SOUND;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleStopSoundEvent(this);
    }

    public @Nullable Identifier getName() {
        return this.name;
    }

    public @Nullable SoundSource getSource() {
        return this.source;
    }
}

