/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.time.Instant;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public record ServerboundChatCommandSignedPacket(String command, Instant timeStamp, long salt, ArgumentSignatures argumentSignatures, LastSeenMessages.Update lastSeenMessages) implements Packet<ServerGamePacketListener>
{
    public static final StreamCodec<FriendlyByteBuf, ServerboundChatCommandSignedPacket> STREAM_CODEC = Packet.codec(ServerboundChatCommandSignedPacket::write, ServerboundChatCommandSignedPacket::new);

    private ServerboundChatCommandSignedPacket(FriendlyByteBuf var0) {
        this(var0.readUtf(), var0.readInstant(), var0.readLong(), new ArgumentSignatures(var0), new LastSeenMessages.Update(var0));
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeUtf(this.command);
        var0.writeInstant(this.timeStamp);
        var0.writeLong(this.salt);
        this.argumentSignatures.write(var0);
        this.lastSeenMessages.write(var0);
    }

    @Override
    public PacketType<ServerboundChatCommandSignedPacket> type() {
        return GamePacketTypes.SERVERBOUND_CHAT_COMMAND_SIGNED;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleSignedChatCommand(this);
    }
}

