/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.world.phys.Vec3;

public abstract class ServerboundMovePlayerPacket
implements Packet<ServerGamePacketListener> {
    private static final int FLAG_ON_GROUND = 1;
    private static final int FLAG_HORIZONTAL_COLLISION = 2;
    public final double x;
    public final double y;
    public final double z;
    public final float yRot;
    public final float xRot;
    protected final boolean onGround;
    protected final boolean horizontalCollision;
    public final boolean hasPos;
    public final boolean hasRot;

    static int packFlags(boolean var0, boolean var1) {
        int var2 = 0;
        if (var0) {
            var2 |= 1;
        }
        if (var1) {
            var2 |= 2;
        }
        return var2;
    }

    static boolean unpackOnGround(int var0) {
        return (var0 & 1) != 0;
    }

    static boolean unpackHorizontalCollision(int var0) {
        return (var0 & 2) != 0;
    }

    protected ServerboundMovePlayerPacket(double var0, double var2, double var4, float var6, float var7, boolean var8, boolean var9, boolean var10, boolean var11) {
        this.x = var0;
        this.y = var2;
        this.z = var4;
        this.yRot = var6;
        this.xRot = var7;
        this.onGround = var8;
        this.horizontalCollision = var9;
        this.hasPos = var10;
        this.hasRot = var11;
    }

    @Override
    public abstract PacketType<? extends ServerboundMovePlayerPacket> type();

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleMovePlayer(this);
    }

    public double getX(double var0) {
        return this.hasPos ? this.x : var0;
    }

    public double getY(double var0) {
        return this.hasPos ? this.y : var0;
    }

    public double getZ(double var0) {
        return this.hasPos ? this.z : var0;
    }

    public float getYRot(float var0) {
        return this.hasRot ? this.yRot : var0;
    }

    public float getXRot(float var0) {
        return this.hasRot ? this.xRot : var0;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean horizontalCollision() {
        return this.horizontalCollision;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public static class StatusOnly
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, StatusOnly> STREAM_CODEC = Packet.codec(StatusOnly::write, StatusOnly::read);

        public StatusOnly(boolean var0, boolean var1) {
            super(0.0, 0.0, 0.0, 0.0f, 0.0f, var0, var1, false, false);
        }

        private static StatusOnly read(FriendlyByteBuf var0) {
            short var1 = var0.readUnsignedByte();
            boolean var2 = ServerboundMovePlayerPacket.unpackOnGround(var1);
            boolean var3 = ServerboundMovePlayerPacket.unpackHorizontalCollision(var1);
            return new StatusOnly(var2, var3);
        }

        private void write(FriendlyByteBuf var0) {
            var0.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<StatusOnly> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_STATUS_ONLY;
        }
    }

    public static class Rot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Rot> STREAM_CODEC = Packet.codec(Rot::write, Rot::read);

        public Rot(float var0, float var1, boolean var2, boolean var3) {
            super(0.0, 0.0, 0.0, var0, var1, var2, var3, false, true);
        }

        private static Rot read(FriendlyByteBuf var0) {
            float var1 = var0.readFloat();
            float var2 = var0.readFloat();
            short var3 = var0.readUnsignedByte();
            boolean var4 = ServerboundMovePlayerPacket.unpackOnGround(var3);
            boolean var5 = ServerboundMovePlayerPacket.unpackHorizontalCollision(var3);
            return new Rot(var1, var2, var4, var5);
        }

        private void write(FriendlyByteBuf var0) {
            var0.writeFloat(this.yRot);
            var0.writeFloat(this.xRot);
            var0.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<Rot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_ROT;
        }
    }

    public static class Pos
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Pos> STREAM_CODEC = Packet.codec(Pos::write, Pos::read);

        public Pos(Vec3 var0, boolean var1, boolean var2) {
            super(var0.x, var0.y, var0.z, 0.0f, 0.0f, var1, var2, true, false);
        }

        public Pos(double var0, double var2, double var4, boolean var6, boolean var7) {
            super(var0, var2, var4, 0.0f, 0.0f, var6, var7, true, false);
        }

        private static Pos read(FriendlyByteBuf var0) {
            double var1 = var0.readDouble();
            double var3 = var0.readDouble();
            double var5 = var0.readDouble();
            short var7 = var0.readUnsignedByte();
            boolean var8 = ServerboundMovePlayerPacket.unpackOnGround(var7);
            boolean var9 = ServerboundMovePlayerPacket.unpackHorizontalCollision(var7);
            return new Pos(var1, var3, var5, var8, var9);
        }

        private void write(FriendlyByteBuf var0) {
            var0.writeDouble(this.x);
            var0.writeDouble(this.y);
            var0.writeDouble(this.z);
            var0.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<Pos> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS;
        }
    }

    public static class PosRot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, PosRot> STREAM_CODEC = Packet.codec(PosRot::write, PosRot::read);

        public PosRot(Vec3 var0, float var1, float var2, boolean var3, boolean var4) {
            super(var0.x, var0.y, var0.z, var1, var2, var3, var4, true, true);
        }

        public PosRot(double var0, double var2, double var4, float var6, float var7, boolean var8, boolean var9) {
            super(var0, var2, var4, var6, var7, var8, var9, true, true);
        }

        private static PosRot read(FriendlyByteBuf var0) {
            double var1 = var0.readDouble();
            double var3 = var0.readDouble();
            double var5 = var0.readDouble();
            float var7 = var0.readFloat();
            float var8 = var0.readFloat();
            short var9 = var0.readUnsignedByte();
            boolean var10 = ServerboundMovePlayerPacket.unpackOnGround(var9);
            boolean var11 = ServerboundMovePlayerPacket.unpackHorizontalCollision(var9);
            return new PosRot(var1, var3, var5, var7, var8, var10, var11);
        }

        private void write(FriendlyByteBuf var0) {
            var0.writeDouble(this.x);
            var0.writeDouble(this.y);
            var0.writeDouble(this.z);
            var0.writeFloat(this.yRot);
            var0.writeFloat(this.xRot);
            var0.writeByte(ServerboundMovePlayerPacket.packFlags(this.onGround, this.horizontalCollision));
        }

        @Override
        public PacketType<PosRot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS_ROT;
        }
    }
}

