/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.minecart.MinecartCommandBlock;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class ServerboundSetCommandMinecartPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundSetCommandMinecartPacket> STREAM_CODEC = Packet.codec(ServerboundSetCommandMinecartPacket::write, ServerboundSetCommandMinecartPacket::new);
    private final int entity;
    private final String command;
    private final boolean trackOutput;

    public ServerboundSetCommandMinecartPacket(int var0, String var1, boolean var2) {
        this.entity = var0;
        this.command = var1;
        this.trackOutput = var2;
    }

    private ServerboundSetCommandMinecartPacket(FriendlyByteBuf var0) {
        this.entity = var0.readVarInt();
        this.command = var0.readUtf();
        this.trackOutput = var0.readBoolean();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeVarInt(this.entity);
        var0.writeUtf(this.command);
        var0.writeBoolean(this.trackOutput);
    }

    @Override
    public PacketType<ServerboundSetCommandMinecartPacket> type() {
        return GamePacketTypes.SERVERBOUND_SET_COMMAND_MINECART;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleSetCommandMinecart(this);
    }

    public @Nullable BaseCommandBlock getCommandBlock(Level var0) {
        Entity var1 = var0.getEntity(this.entity);
        if (var1 instanceof MinecartCommandBlock) {
            return ((MinecartCommandBlock)var1).getCommandBlock();
        }
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }
}

