/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;

public class ServerboundSetJigsawBlockPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundSetJigsawBlockPacket> STREAM_CODEC = Packet.codec(ServerboundSetJigsawBlockPacket::write, ServerboundSetJigsawBlockPacket::new);
    private final BlockPos pos;
    private final Identifier name;
    private final Identifier target;
    private final Identifier pool;
    private final String finalState;
    private final JigsawBlockEntity.JointType joint;
    private final int selectionPriority;
    private final int placementPriority;

    public ServerboundSetJigsawBlockPacket(BlockPos var0, Identifier var1, Identifier var2, Identifier var3, String var4, JigsawBlockEntity.JointType var5, int var6, int var7) {
        this.pos = var0;
        this.name = var1;
        this.target = var2;
        this.pool = var3;
        this.finalState = var4;
        this.joint = var5;
        this.selectionPriority = var6;
        this.placementPriority = var7;
    }

    private ServerboundSetJigsawBlockPacket(FriendlyByteBuf var0) {
        this.pos = var0.readBlockPos();
        this.name = var0.readIdentifier();
        this.target = var0.readIdentifier();
        this.pool = var0.readIdentifier();
        this.finalState = var0.readUtf();
        this.joint = JigsawBlockEntity.JointType.CODEC.byName(var0.readUtf(), JigsawBlockEntity.JointType.ALIGNED);
        this.selectionPriority = var0.readVarInt();
        this.placementPriority = var0.readVarInt();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeBlockPos(this.pos);
        var0.writeIdentifier(this.name);
        var0.writeIdentifier(this.target);
        var0.writeIdentifier(this.pool);
        var0.writeUtf(this.finalState);
        var0.writeUtf(this.joint.getSerializedName());
        var0.writeVarInt(this.selectionPriority);
        var0.writeVarInt(this.placementPriority);
    }

    @Override
    public PacketType<ServerboundSetJigsawBlockPacket> type() {
        return GamePacketTypes.SERVERBOUND_SET_JIGSAW_BLOCK;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleSetJigsawBlock(this);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Identifier getName() {
        return this.name;
    }

    public Identifier getTarget() {
        return this.target;
    }

    public Identifier getPool() {
        return this.pool;
    }

    public String getFinalState() {
        return this.finalState;
    }

    public JigsawBlockEntity.JointType getJoint() {
        return this.joint;
    }

    public int getSelectionPriority() {
        return this.selectionPriority;
    }

    public int getPlacementPriority() {
        return this.placementPriority;
    }
}

