/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public class ServerboundSignUpdatePacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundSignUpdatePacket> STREAM_CODEC = Packet.codec(ServerboundSignUpdatePacket::write, ServerboundSignUpdatePacket::new);
    private static final int MAX_STRING_LENGTH = 384;
    private final BlockPos pos;
    private final String[] lines;
    private final boolean isFrontText;

    public ServerboundSignUpdatePacket(BlockPos var0, boolean var1, String var2, String var3, String var4, String var5) {
        this.pos = var0;
        this.isFrontText = var1;
        this.lines = new String[]{var2, var3, var4, var5};
    }

    private ServerboundSignUpdatePacket(FriendlyByteBuf var0) {
        this.pos = var0.readBlockPos();
        this.isFrontText = var0.readBoolean();
        this.lines = new String[4];
        for (int var1 = 0; var1 < 4; ++var1) {
            this.lines[var1] = var0.readUtf(384);
        }
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeBlockPos(this.pos);
        var0.writeBoolean(this.isFrontText);
        for (int var1 = 0; var1 < 4; ++var1) {
            var0.writeUtf(this.lines[var1]);
        }
    }

    @Override
    public PacketType<ServerboundSignUpdatePacket> type() {
        return GamePacketTypes.SERVERBOUND_SIGN_UPDATE;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleSignUpdate(this);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isFrontText() {
        return this.isFrontText;
    }

    public String[] getLines() {
        return this.lines;
    }
}

