/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.login.ClientLoginPacketListener;
import net.minecraft.network.protocol.login.LoginPacketTypes;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryPayload;
import net.minecraft.resources.Identifier;

public record ClientboundCustomQueryPacket(int transactionId, CustomQueryPayload payload) implements Packet<ClientLoginPacketListener>
{
    public static final StreamCodec<FriendlyByteBuf, ClientboundCustomQueryPacket> STREAM_CODEC = Packet.codec(ClientboundCustomQueryPacket::write, ClientboundCustomQueryPacket::new);
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    private ClientboundCustomQueryPacket(FriendlyByteBuf var0) {
        this(var0.readVarInt(), ClientboundCustomQueryPacket.readPayload(var0.readIdentifier(), var0));
    }

    private static CustomQueryPayload readPayload(Identifier var0, FriendlyByteBuf var1) {
        return ClientboundCustomQueryPacket.readUnknownPayload(var0, var1);
    }

    private static DiscardedQueryPayload readUnknownPayload(Identifier var0, FriendlyByteBuf var1) {
        int var2 = var1.readableBytes();
        if (var2 < 0 || var2 > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        var1.skipBytes(var2);
        return new DiscardedQueryPayload(var0);
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeVarInt(this.transactionId);
        var0.writeIdentifier(this.payload.id());
        this.payload.write(var0);
    }

    @Override
    public PacketType<ClientboundCustomQueryPacket> type() {
        return LoginPacketTypes.CLIENTBOUND_CUSTOM_QUERY;
    }

    @Override
    public void handle(ClientLoginPacketListener var0) {
        var0.handleCustomQuery(this);
    }
}

