/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.function.UnaryOperator;
import net.minecraft.IdentifierException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jspecify.annotations.Nullable;

public final class Identifier
implements Comparable<Identifier> {
    public static final Codec<Identifier> CODEC = Codec.STRING.comapFlatMap(Identifier::read, Identifier::toString).stable();
    public static final StreamCodec<ByteBuf, Identifier> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Identifier::parse, Identifier::toString);
    public static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("argument.id.invalid"));
    public static final char NAMESPACE_SEPARATOR = ':';
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String REALMS_NAMESPACE = "realms";
    private final String namespace;
    private final String path;

    private Identifier(String var0, String var1) {
        assert (Identifier.isValidNamespace(var0));
        assert (Identifier.isValidPath(var1));
        this.namespace = var0;
        this.path = var1;
    }

    private static Identifier createUntrusted(String var0, String var1) {
        return new Identifier(Identifier.assertValidNamespace(var0, var1), Identifier.assertValidPath(var0, var1));
    }

    public static Identifier fromNamespaceAndPath(String var0, String var1) {
        return Identifier.createUntrusted(var0, var1);
    }

    public static Identifier parse(String var0) {
        return Identifier.bySeparator(var0, ':');
    }

    public static Identifier withDefaultNamespace(String var0) {
        return new Identifier(DEFAULT_NAMESPACE, Identifier.assertValidPath(DEFAULT_NAMESPACE, var0));
    }

    public static @Nullable Identifier tryParse(String var0) {
        return Identifier.tryBySeparator(var0, ':');
    }

    public static @Nullable Identifier tryBuild(String var0, String var1) {
        if (Identifier.isValidNamespace(var0) && Identifier.isValidPath(var1)) {
            return new Identifier(var0, var1);
        }
        return null;
    }

    public static Identifier bySeparator(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return Identifier.createUntrusted(var4, var3);
            }
            return Identifier.withDefaultNamespace(var3);
        }
        return Identifier.withDefaultNamespace(var0);
    }

    public static @Nullable Identifier tryBySeparator(String var0, char var1) {
        int var2 = var0.indexOf(var1);
        if (var2 >= 0) {
            String var3 = var0.substring(var2 + 1);
            if (!Identifier.isValidPath(var3)) {
                return null;
            }
            if (var2 != 0) {
                String var4 = var0.substring(0, var2);
                return Identifier.isValidNamespace(var4) ? new Identifier(var4, var3) : null;
            }
            return new Identifier(DEFAULT_NAMESPACE, var3);
        }
        return Identifier.isValidPath(var0) ? new Identifier(DEFAULT_NAMESPACE, var0) : null;
    }

    public static DataResult<Identifier> read(String var0) {
        try {
            return DataResult.success((Object)Identifier.parse(var0));
        }
        catch (IdentifierException var1) {
            return DataResult.error(() -> "Not a valid resource location: " + var0 + " " + var1.getMessage());
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Identifier withPath(String var0) {
        return new Identifier(this.namespace, Identifier.assertValidPath(this.namespace, var0));
    }

    public Identifier withPath(UnaryOperator<String> var0) {
        return this.withPath((String)var0.apply(this.path));
    }

    public Identifier withPrefix(String var0) {
        return this.withPath(var0 + this.path);
    }

    public Identifier withSuffix(String var0) {
        return this.withPath(this.path + var0);
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof Identifier) {
            Identifier var1 = (Identifier)var0;
            return this.namespace.equals(var1.namespace) && this.path.equals(var1.path);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(Identifier var0) {
        int var1 = this.path.compareTo(var0.path);
        if (var1 == 0) {
            var1 = this.namespace.compareTo(var0.namespace);
        }
        return var1;
    }

    public String toDebugFileName() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String toLanguageKey() {
        return this.namespace + "." + this.path;
    }

    public String toShortLanguageKey() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toLanguageKey();
    }

    public String toShortString() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toString();
    }

    public String toLanguageKey(String var0) {
        return var0 + "." + this.toLanguageKey();
    }

    public String toLanguageKey(String var0, String var1) {
        return var0 + "." + this.toLanguageKey() + "." + var1;
    }

    private static String readGreedy(StringReader var0) {
        int var1 = var0.getCursor();
        while (var0.canRead() && Identifier.isAllowedInIdentifier(var0.peek())) {
            var0.skip();
        }
        return var0.getString().substring(var1, var0.getCursor());
    }

    public static Identifier read(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = Identifier.readGreedy(var0);
        try {
            return Identifier.parse(var2);
        }
        catch (IdentifierException var3) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static Identifier readNonEmpty(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        String var2 = Identifier.readGreedy(var0);
        if (var2.isEmpty()) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
        try {
            return Identifier.parse(var2);
        }
        catch (IdentifierException var3) {
            var0.setCursor(var1);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
        }
    }

    public static boolean isAllowedInIdentifier(char var0) {
        return var0 >= '0' && var0 <= '9' || var0 >= 'a' && var0 <= 'z' || var0 == '_' || var0 == ':' || var0 == '/' || var0 == '.' || var0 == '-';
    }

    public static boolean isValidPath(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (Identifier.validPathChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (Identifier.validNamespaceChar(var0.charAt(var1))) continue;
            return false;
        }
        return true;
    }

    private static String assertValidNamespace(String var0, String var1) {
        if (!Identifier.isValidNamespace(var0)) {
            throw new IdentifierException("Non [a-z0-9_.-] character in namespace of location: " + var0 + ":" + var1);
        }
        return var0;
    }

    public static boolean validPathChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '/' || var0 == '.';
    }

    private static boolean validNamespaceChar(char var0) {
        return var0 == '_' || var0 == '-' || var0 >= 'a' && var0 <= 'z' || var0 >= '0' && var0 <= '9' || var0 == '.';
    }

    private static String assertValidPath(String var0, String var1) {
        if (!Identifier.isValidPath(var1)) {
            throw new IdentifierException("Non [a-z0-9/._-] character in path of location: " + var0 + ":" + var1);
        }
        return var1;
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((Identifier)object);
    }
}

