/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.StrictJsonParser;
import net.minecraft.util.Util;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.cow.CowVariant;
import net.minecraft.world.entity.animal.feline.CatVariant;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.pig.PigVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.decoration.painting.PaintingVariant;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.timeline.Timeline;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Comparator<ResourceKey<?>> ERROR_KEY_COMPARATOR = Comparator.comparing(ResourceKey::registry).thenComparing(ResourceKey::identifier);
    private static final RegistrationInfo NETWORK_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> REGISTRATION_INFO_CACHE = Util.memoize(var02 -> {
        Lifecycle var1 = var02.map(KnownPack::isVanilla).map(var0 -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)var02, var1);
    });
    public static final List<RegistryData<?>> WORLDGEN_REGISTRIES = List.of(new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.DIRECT_CODEC), new RegistryData<Biome>(Registries.BIOME, Biome.DIRECT_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_CARVER, ConfiguredWorldCarver.DIRECT_CODEC), new RegistryData(Registries.CONFIGURED_FEATURE, ConfiguredFeature.DIRECT_CODEC), new RegistryData<PlacedFeature>(Registries.PLACED_FEATURE, PlacedFeature.DIRECT_CODEC), new RegistryData<Structure>(Registries.STRUCTURE, Structure.DIRECT_CODEC), new RegistryData<StructureSet>(Registries.STRUCTURE_SET, StructureSet.DIRECT_CODEC), new RegistryData<StructureProcessorList>(Registries.PROCESSOR_LIST, StructureProcessorType.DIRECT_CODEC), new RegistryData<StructureTemplatePool>(Registries.TEMPLATE_POOL, StructureTemplatePool.DIRECT_CODEC), new RegistryData<NoiseGeneratorSettings>(Registries.NOISE_SETTINGS, NoiseGeneratorSettings.DIRECT_CODEC), new RegistryData<NormalNoise.NoiseParameters>(Registries.NOISE, NormalNoise.NoiseParameters.DIRECT_CODEC), new RegistryData<DensityFunction>(Registries.DENSITY_FUNCTION, DensityFunction.DIRECT_CODEC), new RegistryData<WorldPreset>(Registries.WORLD_PRESET, WorldPreset.DIRECT_CODEC), new RegistryData<FlatLevelGeneratorPreset>(Registries.FLAT_LEVEL_GENERATOR_PRESET, FlatLevelGeneratorPreset.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<TrialSpawnerConfig>(Registries.TRIAL_SPAWNER_CONFIG, TrialSpawnerConfig.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.DIRECT_CODEC, true), new RegistryData<WolfSoundVariant>(Registries.WOLF_SOUND_VARIANT, WolfSoundVariant.DIRECT_CODEC, true), new RegistryData<PigVariant>(Registries.PIG_VARIANT, PigVariant.DIRECT_CODEC, true), new RegistryData<FrogVariant>(Registries.FROG_VARIANT, FrogVariant.DIRECT_CODEC, true), new RegistryData<CatVariant>(Registries.CAT_VARIANT, CatVariant.DIRECT_CODEC, true), new RegistryData<CowVariant>(Registries.COW_VARIANT, CowVariant.DIRECT_CODEC, true), new RegistryData<ChickenVariant>(Registries.CHICKEN_VARIANT, ChickenVariant.DIRECT_CODEC, true), new RegistryData<ZombieNautilusVariant>(Registries.ZOMBIE_NAUTILUS_VARIANT, ZombieNautilusVariant.DIRECT_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<MultiNoiseBiomeSourceParameterList>(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterList.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<EnchantmentProvider>(Registries.ENCHANTMENT_PROVIDER, EnchantmentProvider.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new RegistryData<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC), new RegistryData<TestEnvironmentDefinition>(Registries.TEST_ENVIRONMENT, TestEnvironmentDefinition.DIRECT_CODEC), new RegistryData<GameTestInstance>(Registries.TEST_INSTANCE, GameTestInstance.DIRECT_CODEC), new RegistryData<Dialog>(Registries.DIALOG, Dialog.DIRECT_CODEC), new RegistryData<Timeline>(Registries.TIMELINE, Timeline.DIRECT_CODEC));
    public static final List<RegistryData<?>> DIMENSION_REGISTRIES = List.of(new RegistryData<LevelStem>(Registries.LEVEL_STEM, LevelStem.CODEC));
    public static final List<RegistryData<?>> SYNCHRONIZED_REGISTRIES = List.of(new RegistryData<Biome>(Registries.BIOME, Biome.NETWORK_CODEC), new RegistryData<ChatType>(Registries.CHAT_TYPE, ChatType.DIRECT_CODEC), new RegistryData<TrimPattern>(Registries.TRIM_PATTERN, TrimPattern.DIRECT_CODEC), new RegistryData<TrimMaterial>(Registries.TRIM_MATERIAL, TrimMaterial.DIRECT_CODEC), new RegistryData<WolfVariant>(Registries.WOLF_VARIANT, WolfVariant.NETWORK_CODEC, true), new RegistryData<WolfSoundVariant>(Registries.WOLF_SOUND_VARIANT, WolfSoundVariant.NETWORK_CODEC, true), new RegistryData<PigVariant>(Registries.PIG_VARIANT, PigVariant.NETWORK_CODEC, true), new RegistryData<FrogVariant>(Registries.FROG_VARIANT, FrogVariant.NETWORK_CODEC, true), new RegistryData<CatVariant>(Registries.CAT_VARIANT, CatVariant.NETWORK_CODEC, true), new RegistryData<CowVariant>(Registries.COW_VARIANT, CowVariant.NETWORK_CODEC, true), new RegistryData<ChickenVariant>(Registries.CHICKEN_VARIANT, ChickenVariant.NETWORK_CODEC, true), new RegistryData<ZombieNautilusVariant>(Registries.ZOMBIE_NAUTILUS_VARIANT, ZombieNautilusVariant.NETWORK_CODEC, true), new RegistryData<PaintingVariant>(Registries.PAINTING_VARIANT, PaintingVariant.DIRECT_CODEC, true), new RegistryData<DimensionType>(Registries.DIMENSION_TYPE, DimensionType.NETWORK_CODEC), new RegistryData<DamageType>(Registries.DAMAGE_TYPE, DamageType.DIRECT_CODEC), new RegistryData<BannerPattern>(Registries.BANNER_PATTERN, BannerPattern.DIRECT_CODEC), new RegistryData<Enchantment>(Registries.ENCHANTMENT, Enchantment.DIRECT_CODEC), new RegistryData<JukeboxSong>(Registries.JUKEBOX_SONG, JukeboxSong.DIRECT_CODEC), new RegistryData<Instrument>(Registries.INSTRUMENT, Instrument.DIRECT_CODEC), new RegistryData<TestEnvironmentDefinition>(Registries.TEST_ENVIRONMENT, TestEnvironmentDefinition.DIRECT_CODEC), new RegistryData<GameTestInstance>(Registries.TEST_INSTANCE, GameTestInstance.DIRECT_CODEC), new RegistryData<Dialog>(Registries.DIALOG, Dialog.DIRECT_CODEC), new RegistryData<Timeline>(Registries.TIMELINE, Timeline.NETWORK_CODEC));

    public static RegistryAccess.Frozen load(ResourceManager var0, List<HolderLookup.RegistryLookup<?>> var12, List<RegistryData<?>> var22) {
        return RegistryDataLoader.load((Loader<?> var1, RegistryOps.RegistryInfoLookup var2) -> var1.loadFromResources(var0, var2), var12, var22);
    }

    public static RegistryAccess.Frozen load(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> var0, ResourceProvider var1, List<HolderLookup.RegistryLookup<?>> var22, List<RegistryData<?>> var32) {
        return RegistryDataLoader.load((Loader<?> var2, RegistryOps.RegistryInfoLookup var3) -> var2.loadFromNetwork(var0, var1, var3), var22, var32);
    }

    private static RegistryAccess.Frozen load(LoadingFunction var0, List<HolderLookup.RegistryLookup<?>> var12, List<RegistryData<?>> var22) {
        HashMap var3 = new HashMap();
        List<Loader<?>> var4 = var22.stream().map(var1 -> var1.create(Lifecycle.stable(), var3)).collect(Collectors.toUnmodifiableList());
        RegistryOps.RegistryInfoLookup var5 = RegistryDataLoader.createContext(var12, var4);
        var4.forEach(var2 -> var0.apply((Loader<?>)var2, var5));
        var4.forEach(var1 -> {
            WritableRegistry var2 = var1.registry();
            try {
                var2.freeze();
            }
            catch (Exception var3) {
                var3.put(var2.key(), var3);
            }
            if (var1.data.requiredNonEmpty && var2.size() == 0) {
                var3.put(var2.key(), new IllegalStateException("Registry must be non-empty: " + String.valueOf(var2.key().identifier())));
            }
        });
        if (!var3.isEmpty()) {
            throw RegistryDataLoader.logErrors(var3);
        }
        return new RegistryAccess.ImmutableRegistryAccess(var4.stream().map(Loader::registry).toList()).freeze();
    }

    private static RegistryOps.RegistryInfoLookup createContext(List<HolderLookup.RegistryLookup<?>> var0, List<Loader<?>> var12) {
        final HashMap var2 = new HashMap();
        var0.forEach(var1 -> var2.put(var1.key(), RegistryDataLoader.createInfoForContextRegistry(var1)));
        var12.forEach(var1 -> var2.put(var1.registry.key(), RegistryDataLoader.createInfoForNewRegistry(var1.registry)));
        return new RegistryOps.RegistryInfoLookup(){

            @Override
            public <T> Optional<RegistryOps.RegistryInfo<T>> lookup(ResourceKey<? extends Registry<? extends T>> var0) {
                return Optional.ofNullable((RegistryOps.RegistryInfo)var2.get(var0));
            }
        };
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForNewRegistry(WritableRegistry<T> var0) {
        return new RegistryOps.RegistryInfo<T>(var0, var0.createRegistrationLookup(), var0.registryLifecycle());
    }

    private static <T> RegistryOps.RegistryInfo<T> createInfoForContextRegistry(HolderLookup.RegistryLookup<T> var0) {
        return new RegistryOps.RegistryInfo<T>(var0, var0, var0.registryLifecycle());
    }

    private static ReportedException logErrors(Map<ResourceKey<?>, Exception> var0) {
        RegistryDataLoader.printFullDetailsToLog(var0);
        return RegistryDataLoader.createReportWithBriefInfo(var0);
    }

    private static void printFullDetailsToLog(Map<ResourceKey<?>, Exception> var02) {
        StringWriter var1 = new StringWriter();
        PrintWriter var2 = new PrintWriter(var1);
        Map<Identifier, Map<Identifier, Exception>> var3 = var02.entrySet().stream().collect(Collectors.groupingBy(var0 -> ((ResourceKey)var0.getKey()).registry(), Collectors.toMap(var0 -> ((ResourceKey)var0.getKey()).identifier(), Map.Entry::getValue)));
        var3.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var12 -> {
            var2.printf(Locale.ROOT, "> Errors in registry %s:%n", var12.getKey());
            ((Map)var12.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(var1 -> {
                var2.printf(Locale.ROOT, ">> Errors in element %s:%n", var1.getKey());
                ((Exception)var1.getValue()).printStackTrace(var2);
            });
        });
        var2.flush();
        LOGGER.error("Registry loading errors:\n{}", (Object)var1);
    }

    private static ReportedException createReportWithBriefInfo(Map<ResourceKey<?>, Exception> var0) {
        CrashReport var1 = CrashReport.forThrowable(new IllegalStateException("Failed to load registries due to errors"), "Registry Loading");
        CrashReportCategory var2 = var1.addCategory("Loading info");
        var2.setDetail("Errors", () -> {
            StringBuilder var12 = new StringBuilder();
            var0.entrySet().stream().sorted(Map.Entry.comparingByKey(ERROR_KEY_COMPARATOR)).forEach(var1 -> var12.append("\n\t\t").append(((ResourceKey)var1.getKey()).registry()).append("/").append(((ResourceKey)var1.getKey()).identifier()).append(": ").append(((Exception)var1.getValue()).getMessage()));
            return var12.toString();
        });
        return new ReportedException(var1);
    }

    private static <E> void loadElementFromResource(WritableRegistry<E> var0, Decoder<E> var1, RegistryOps<JsonElement> var2, ResourceKey<E> var3, Resource var4, RegistrationInfo var5) throws IOException {
        try (BufferedReader var6 = var4.openAsReader();){
            JsonElement var7 = StrictJsonParser.parse(var6);
            DataResult var8 = var1.parse(var2, (Object)var7);
            Object var9 = var8.getOrThrow();
            var0.register(var3, var9, var5);
        }
    }

    static <E> void loadContentsFromManager(ResourceManager var0, RegistryOps.RegistryInfoLookup var1, WritableRegistry<E> var2, Decoder<E> var3, Map<ResourceKey<?>, Exception> var4) {
        FileToIdConverter var5 = FileToIdConverter.registry(var2.key());
        RegistryOps<JsonElement> var6 = RegistryOps.create(JsonOps.INSTANCE, var1);
        for (Map.Entry<Identifier, Resource> var8 : var5.listMatchingResources(var0).entrySet()) {
            Identifier var9 = var8.getKey();
            ResourceKey var10 = ResourceKey.create(var2.key(), var5.fileToId(var9));
            Resource var11 = var8.getValue();
            RegistrationInfo var12 = REGISTRATION_INFO_CACHE.apply(var11.knownPackInfo());
            try {
                RegistryDataLoader.loadElementFromResource(var2, var3, var6, var10, var11, var12);
            }
            catch (Exception var13) {
                var4.put(var10, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", var9, var11.sourcePackId()), var13));
            }
        }
        TagLoader.loadTagsForRegistry(var0, var2);
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> var0, ResourceProvider var1, RegistryOps.RegistryInfoLookup var2, WritableRegistry<E> var3, Decoder<E> var4, Map<ResourceKey<?>, Exception> var5) {
        NetworkedRegistryData var6 = var0.get(var3.key());
        if (var6 == null) {
            return;
        }
        RegistryOps<Tag> var7 = RegistryOps.create(NbtOps.INSTANCE, var2);
        RegistryOps<JsonElement> var8 = RegistryOps.create(JsonOps.INSTANCE, var2);
        FileToIdConverter var9 = FileToIdConverter.registry(var3.key());
        for (RegistrySynchronization.PackedRegistryEntry var11 : var6.elements) {
            Object var15;
            Identifier var14;
            ResourceKey var12 = ResourceKey.create(var3.key(), var11.id());
            Optional<Tag> var13 = var11.data();
            if (var13.isPresent()) {
                try {
                    var14 = var4.parse(var7, (Object)var13.get());
                    var15 = var14.getOrThrow();
                    var3.register(var12, var15, NETWORK_REGISTRATION_INFO);
                }
                catch (Exception var142) {
                    var5.put(var12, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", var13.get()), var142));
                }
                continue;
            }
            var14 = var9.idToFile(var11.id());
            try {
                var15 = var1.getResourceOrThrow(var14);
                RegistryDataLoader.loadElementFromResource(var3, var4, var8, var12, (Resource)var15, NETWORK_REGISTRATION_INFO);
            }
            catch (Exception var152) {
                var5.put(var12, new IllegalStateException("Failed to parse local data", var152));
            }
        }
        TagLoader.loadTagsFromNetwork(var6.tags, var3);
    }

    @FunctionalInterface
    static interface LoadingFunction {
        public void apply(Loader<?> var1, RegistryOps.RegistryInfoLookup var2);
    }

    public static final class NetworkedRegistryData
    extends Record {
        final List<RegistrySynchronization.PackedRegistryEntry> elements;
        final TagNetworkSerialization.NetworkPayload tags;

        public NetworkedRegistryData(List<RegistrySynchronization.PackedRegistryEntry> var0, TagNetworkSerialization.NetworkPayload var1) {
            this.elements = var0;
            this.tags = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NetworkedRegistryData.class, "elements;tags", "elements", "tags"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NetworkedRegistryData.class, "elements;tags", "elements", "tags"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NetworkedRegistryData.class, "elements;tags", "elements", "tags"}, this, var0);
        }

        public List<RegistrySynchronization.PackedRegistryEntry> elements() {
            return this.elements;
        }

        public TagNetworkSerialization.NetworkPayload tags() {
            return this.tags;
        }
    }

    static final class Loader<T>
    extends Record {
        final RegistryData<T> data;
        final WritableRegistry<T> registry;
        private final Map<ResourceKey<?>, Exception> loadingErrors;

        Loader(RegistryData<T> var0, WritableRegistry<T> var1, Map<ResourceKey<?>, Exception> var2) {
            this.data = var0;
            this.registry = var1;
            this.loadingErrors = var2;
        }

        public void loadFromResources(ResourceManager var0, RegistryOps.RegistryInfoLookup var1) {
            RegistryDataLoader.loadContentsFromManager(var0, var1, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends Registry<?>>, NetworkedRegistryData> var0, ResourceProvider var1, RegistryOps.RegistryInfoLookup var2) {
            RegistryDataLoader.loadContentsFromNetwork(var0, var1, var2, this.registry, this.data.elementCodec, this.loadingErrors);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Loader.class, "data;registry;loadingErrors", "data", "registry", "loadingErrors"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Loader.class, "data;registry;loadingErrors", "data", "registry", "loadingErrors"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Loader.class, "data;registry;loadingErrors", "data", "registry", "loadingErrors"}, this, var0);
        }

        public RegistryData<T> data() {
            return this.data;
        }

        public WritableRegistry<T> registry() {
            return this.registry;
        }

        public Map<ResourceKey<?>, Exception> loadingErrors() {
            return this.loadingErrors;
        }
    }

    public static final class RegistryData<T>
    extends Record {
        private final ResourceKey<? extends Registry<T>> key;
        final Codec<T> elementCodec;
        final boolean requiredNonEmpty;

        RegistryData(ResourceKey<? extends Registry<T>> var0, Codec<T> var1) {
            this(var0, var1, false);
        }

        public RegistryData(ResourceKey<? extends Registry<T>> var0, Codec<T> var1, boolean var2) {
            this.key = var0;
            this.elementCodec = var1;
            this.requiredNonEmpty = var2;
        }

        Loader<T> create(Lifecycle var0, Map<ResourceKey<?>, Exception> var1) {
            MappedRegistry var2 = new MappedRegistry(this.key, var0);
            return new Loader(this, var2, var1);
        }

        public void runWithArguments(BiConsumer<ResourceKey<? extends Registry<T>>, Codec<T>> var0) {
            var0.accept(this.key, this.elementCodec);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RegistryData.class, "key;elementCodec;requiredNonEmpty", "key", "elementCodec", "requiredNonEmpty"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RegistryData.class, "key;elementCodec;requiredNonEmpty", "key", "elementCodec", "requiredNonEmpty"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RegistryData.class, "key;elementCodec;requiredNonEmpty", "key", "elementCodec", "requiredNonEmpty"}, this, var0);
        }

        public ResourceKey<? extends Registry<T>> key() {
            return this.key;
        }

        public Codec<T> elementCodec() {
            return this.elementCodec;
        }

        public boolean requiredNonEmpty() {
            return this.requiredNonEmpty;
        }
    }
}

